/*
 * Decompiled with CFR 0.152.
 */
package dev.ultreon.devices.components;

import dev.ultreon.devices.components.GameComponent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class GameObject {
    private final Map<Class<? extends GameComponent>, GameComponent> components = new HashMap<Class<? extends GameComponent>, GameComponent>();

    public <T extends GameComponent> T getComponent(Class<T> componentClass) {
        return (T)((GameComponent)componentClass.cast(this.components.get(componentClass)));
    }

    public <T extends GameComponent> T getComponent(Class<T> componentClass, T defaultComponent) {
        T component = this.getComponent(componentClass);
        return component != null ? component : defaultComponent;
    }

    public <T extends GameComponent> List<T> getComponents(Class<T> componentClass) {
        ArrayList<GameComponent> list = new ArrayList<GameComponent>();
        for (GameComponent gameComponent : this.components.values()) {
            if (!componentClass.isInstance(gameComponent)) continue;
            GameComponent obj = (GameComponent)componentClass.cast(gameComponent);
            list.add(obj);
        }
        return list;
    }

    public void addComponent(GameComponent component) {
        this.components.put(component.getClass(), component);
    }

    public void removeComponent(GameComponent component) {
        this.components.remove(component.getClass());
    }

    public boolean hasComponent(Class<? extends GameComponent> componentClass) {
        return this.components.containsKey(componentClass);
    }
}

