/*
 * Decompiled with CFR 0.152.
 */
package dev.ultreon.devices.core;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import dev.ultreon.devices.Devices;
import dev.ultreon.devices.core.io.drive.AbstractDrive;
import dev.ultreon.devices.core.io.drive.ExternalDrive;
import dev.ultreon.devices.core.io.drive.InternalDrive;
import java.io.IOException;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;

public class DriveManager {
    private static final Cache<UUID, ExternalDrive> EXTERNAL_DRIVE_CACHE = CacheBuilder.newBuilder().expireAfterAccess(5L, TimeUnit.MINUTES).build();
    private static final Cache<UUID, InternalDrive> INTERNAL_DRIVE_CACHE = CacheBuilder.newBuilder().expireAfterAccess(5L, TimeUnit.MINUTES).build();

    public static InternalDrive getInternalDrive(UUID uuid) {
        try {
            return (InternalDrive)INTERNAL_DRIVE_CACHE.get((Object)uuid, () -> InternalDrive.load(uuid, AbstractDrive.getDrivePath(uuid)));
        }
        catch (ExecutionException e) {
            Devices.LOGGER.error("Failed to load internal drive", (Throwable)e);
            return null;
        }
    }

    public static ExternalDrive getExternalDrive(UUID uuid) {
        try {
            return (ExternalDrive)EXTERNAL_DRIVE_CACHE.get((Object)uuid, () -> ExternalDrive.load(uuid, AbstractDrive.getDrivePath(uuid)));
        }
        catch (ExecutionException e) {
            Devices.LOGGER.error("Failed to load external drive", (Throwable)e);
            return null;
        }
    }

    public static void registerExternalDrive(ExternalDrive externalDrive) throws IOException {
        EXTERNAL_DRIVE_CACHE.put((Object)externalDrive.getUuid(), (Object)externalDrive);
        externalDrive.flush();
    }

    public static void registerInternalDrive(InternalDrive internalDrive) throws IOException {
        INTERNAL_DRIVE_CACHE.put((Object)internalDrive.getUuid(), (Object)internalDrive);
        internalDrive.flush();
    }
}

