/*
 * Decompiled with CFR 0.152.
 */
package dev.ultreon.devices.core;

import dev.ultreon.devices.core.Ext2FS;
import dev.ultreon.devices.core.LockKey;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Iterator;
import org.jetbrains.annotations.Nullable;
import org.jnode.fs.FileSystemException;

public interface FS {
    public void close() throws IOException;

    public InputStream read(Path var1, OpenOption ... var2) throws IOException;

    public OutputStream write(Path var1, OpenOption ... var2) throws IOException;

    public boolean exists(Path var1) throws IOException;

    public void flush() throws IOException;

    public void createFile(Path var1, byte[] var2) throws IOException;

    public void createDirectory(Path var1) throws IOException;

    public Iterator<String> listDirectory(Path var1) throws IOException;

    public void delete(Path var1) throws IOException;

    public long size(Path var1) throws IOException;

    public void rename(Path var1, String var2) throws IOException;

    public boolean isFolder(Path var1) throws IOException;

    public boolean isFile(Path var1) throws IOException;

    public boolean isSymbolicLink(Path var1) throws IOException;

    @Nullable
    public LockKey lock(String var1) throws IOException;

    public void unlock(String var1);

    public boolean isLocked(String var1);

    public void setReadOnly(Path var1, boolean var2) throws IOException;

    public void setExecutable(Path var1, boolean var2) throws IOException;

    public boolean isExecutable(Path var1) throws IOException;

    public boolean isWritable(Path var1) throws IOException;

    public boolean isReadable(Path var1) throws IOException;

    public int getOwner(Path var1) throws IOException;

    public int getGroup(Path var1) throws IOException;

    public int getPermissions(Path var1) throws IOException;

    public void setPermissions(Path var1, int var2) throws IOException;

    public void setOwner(Path var1, int var2, int var3) throws IOException;

    public void setGroup(Path var1, int var2) throws IOException;

    public void setOwner(Path var1, int var2) throws IOException;

    public long getGeneration(Path var1) throws IOException;

    public void setGeneration(Path var1, long var2) throws IOException;

    public boolean isReadOnly(Path var1) throws IOException;

    public boolean canWrite(Path var1) throws IOException;

    public boolean canRead(Path var1) throws IOException;

    public boolean canExecute(Path var1) throws IOException;

    public static FS loadExt2(Path path) throws IOException, FileSystemException {
        return Ext2FS.open(false, path);
    }

    public static FS loadExt2Forced(Path path) throws IOException, FileSystemException {
        return Ext2FS.openForced(path);
    }

    public static FS loadExt2ReadOnly(Path path) throws IOException, FileSystemException {
        return Ext2FS.open(true, path);
    }

    public static FS formatExt2(Path path, long diskSize) throws IOException, FileSystemException {
        return Ext2FS.format(path, diskSize);
    }

    public long lastModified(Path var1) throws IOException;

    public long lastAccessed(Path var1) throws IOException;

    public long creationTime(Path var1) throws IOException;

    public void setLastAccessed(Path var1, long var2) throws IOException;

    public void setLastModified(Path var1, long var2) throws IOException;

    public void setCreationTime(Path var1, long var2) throws IOException;

    public long getTotalSpace() throws IOException;

    public long getUsableSpace() throws IOException;

    public long getFreeSpace() throws IOException;

    public void move(Path var1, Path var2) throws IOException;

    public void copy(Path var1, Path var2) throws IOException;

    public void write(Path var1, long var2, byte[] var4) throws IOException;

    public void write(Path var1, byte[] var2) throws IOException;

    public void truncate(Path var1, long var2) throws IOException;

    public void read(Path var1, ByteBuffer var2, long var3) throws IOException;
}

