/*
 * Decompiled with CFR 0.152.
 */
package dev.ultreon.devices.core;

import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import org.jnode.driver.block.BlockDeviceAPI;

public class VirtualBlockDevice
implements BlockDeviceAPI {
    private final RandomAccessFile file;

    public VirtualBlockDevice(String filePath, long size) throws IOException {
        Path path = Path.of(filePath, new String[0]);
        if (Files.notExists(path, new LinkOption[0])) {
            Files.createFile(path, new FileAttribute[0]);
        }
        this.file = new RandomAccessFile(filePath, "rw");
        if (this.file.length() < size) {
            this.file.setLength(size);
        }
    }

    public long getLength() throws IOException {
        return this.file.length();
    }

    public void read(long devOffset, ByteBuffer dest) throws IOException {
        if (devOffset < 0L || devOffset >= this.file.length()) {
            throw new IOException("Invalid read offset");
        }
        this.file.seek(devOffset);
        byte[] buffer = new byte[dest.remaining()];
        int bytesRead = this.file.read(buffer);
        if (bytesRead < 0) {
            throw new IOException("End of file reached");
        }
        dest.put(buffer, 0, bytesRead);
    }

    public void write(long devOffset, ByteBuffer src) throws IOException {
        if (devOffset < 0L || devOffset >= this.file.length()) {
            throw new IOException("Invalid write offset");
        }
        this.file.seek(devOffset);
        byte[] buffer = new byte[src.remaining()];
        src.get(buffer);
        this.file.write(buffer);
    }

    public void flush() throws IOException {
        this.file.getFD().sync();
    }

    public void close() throws IOException {
        this.file.close();
    }
}

