/*
 * Decompiled with CFR 0.152.
 */
package dev.ultreon.devices.core.io;

import dev.ultreon.devices.Devices;
import dev.ultreon.devices.api.app.Application;
import dev.ultreon.devices.api.io.Drive;
import dev.ultreon.devices.api.io.FSResponse;
import dev.ultreon.devices.api.task.Callback;
import dev.ultreon.devices.api.task.TaskManager;
import dev.ultreon.devices.block.entity.DriveInfo;
import dev.ultreon.devices.block.entity.computer.ComputerBlockEntity;
import dev.ultreon.devices.core.ComputerScreen;
import dev.ultreon.devices.core.DeviceFSException;
import dev.ultreon.devices.core.DriveManager;
import dev.ultreon.devices.core.Ext2FS;
import dev.ultreon.devices.core.io.ServerFolder;
import dev.ultreon.devices.core.io.action.FileAction;
import dev.ultreon.devices.core.io.drive.AbstractDrive;
import dev.ultreon.devices.core.io.drive.ExternalDrive;
import dev.ultreon.devices.core.io.drive.InternalDrive;
import dev.ultreon.devices.core.io.task.TaskGetMainDrive;
import dev.ultreon.devices.core.io.task.TaskSendAction;
import dev.ultreon.devices.debug.DebugLog;
import dev.ultreon.devices.init.DeviceDataComponents;
import dev.ultreon.devices.init.DeviceItems;
import dev.ultreon.devices.item.FlashDriveItem;
import dev.ultreon.devices.programs.system.component.FileInfo;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.regex.Pattern;
import net.minecraft.class_1767;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_9331;
import net.minecraft.class_9334;
import org.jetbrains.annotations.Nullable;

public class FileSystem {
    public static final Pattern PATTERN_FILE_NAME = Pattern.compile("^[\\w'.:_ ]{1,32}$");
    public static final Pattern PATTERN_DIRECTORY = Pattern.compile("^(/)|(/[\\w'.:_ ]{1,32})*$");
    public static final Path DIR_ROOT = Path.of("/", new String[0]);
    public static final Path DIR_APPLICATION_DATA = Path.of("/ApplicationData", new String[0]);
    public static final Path DIR_HOME = Path.of("/Home", new String[0]);
    public static final String LAPTOP_DRIVE_NAME = "Main";
    private AbstractDrive mainDrive = null;
    private final Map<UUID, AbstractDrive> additionalDrives = new HashMap<UUID, AbstractDrive>();
    private AbstractDrive attachedDrive = null;
    private class_1767 attachedDriveColor = class_1767.field_7952;
    private final ComputerBlockEntity blockEntity;

    public FileSystem(ComputerBlockEntity blockEntity) {
        this.blockEntity = blockEntity;
        this.setupDefault();
    }

    public FileSystem(ComputerBlockEntity blockEntity, class_2487 tag) {
        this.blockEntity = blockEntity;
        this.load(tag);
    }

    @Deprecated
    public static void sendAction(UUID drive, FileAction<?> action, @Nullable Callback<Response> callback) {
        if (ComputerScreen.getPos() != null) {
            DebugLog.log("Sending action " + String.valueOf(action) + " to " + String.valueOf(drive));
            TaskSendAction task = new TaskSendAction(drive, action);
            task.setCallback((tag, success) -> {
                DebugLog.log("Action " + String.valueOf(action) + " sent to " + String.valueOf(drive) + ": " + success);
                if (callback != null) {
                    assert (tag != null);
                    class_2520 response = tag.method_10580("response");
                    DebugLog.log("Callback: " + String.valueOf(response == null ? "null" : response));
                    callback.execute(Response.fromTag(tag.method_10562("response")), success);
                }
            });
            TaskManager.sendTask(task);
        } else {
            DebugLog.log("Sending action " + String.valueOf(action) + " to " + String.valueOf(drive) + " failed: Laptop not found");
        }
    }

    public static <T> void request(UUID drive, FileAction<T> action, @Nullable Consumer<FSResponse<T>> callback) {
        if (ComputerScreen.getPos() != null) {
            DebugLog.log("Sending action " + String.valueOf(action) + " to " + String.valueOf(drive));
            TaskSendAction task = new TaskSendAction(drive, action);
            task.setCallback((tag, success) -> {
                DebugLog.log("Action " + String.valueOf(action) + " sent to " + String.valueOf(drive) + ": " + success);
                if (callback != null) {
                    int status;
                    assert (tag != null);
                    class_2487 response = tag.method_10562("response");
                    DebugLog.log("Callback: " + String.valueOf(response));
                    int n = status = response.method_10573("status", 3) ? response.method_10550("status") : 0;
                    if (status != 1) {
                        success = false;
                    }
                    callback.accept(new FSResponse<Object>(success, status, (success ? (Object)action.deserialize(response.method_10562("data")) : null), response.method_10558("message")));
                }
            });
            TaskManager.sendTask(task);
        } else {
            DebugLog.log("Sending action " + String.valueOf(action) + " to " + String.valueOf(drive) + " failed: Laptop not found");
        }
    }

    public static void getApplicationFolder(Application app, Consumer<FSResponse<FileInfo>> callback) {
        if (Devices.hasAllowedApplications() && !Devices.getAllowedApplications().contains(app.getInfo())) {
            callback.accept(new FSResponse<Object>(false, 8, null, "Application not allowed"));
            return;
        }
        if (ComputerScreen.getMainDrive() == null) {
            TaskGetMainDrive task = new TaskGetMainDrive(ComputerScreen.getPos());
            task.setCallback((tag, success) -> {
                if (success) {
                    FileSystem.setupApplicationFolder(app, callback);
                } else {
                    callback.accept(new FSResponse<Object>(false, 7, null, "Drive unavailable"));
                }
            });
            TaskManager.sendTask(task);
        } else {
            FileSystem.setupApplicationFolder(app, callback);
        }
    }

    private static void setupApplicationFolder(Application app, Consumer<FSResponse<FileInfo>> callback) {
        Drive mainDrive = ComputerScreen.getMainDrive();
        assert (mainDrive != null);
        mainDrive.info(DIR_APPLICATION_DATA.resolve(app.getInfo().getFormattedId()), info -> mainDrive.exists(DIR_APPLICATION_DATA.resolve(app.getInfo().getFormattedId()), appDirExist -> {
            if (!((Boolean)appDirExist.data()).booleanValue()) {
                ((FileInfo)info.data()).createDirectory(app.getInfo().getFormattedId(), callback);
                return;
            }
            callback.accept(new FSResponse<Object>(false, 0, null, "Application folder still does not exist"));
        }));
    }

    public static Response createSuccessResponse() {
        return new Response(1);
    }

    public static Response createResponse(int status, String message) {
        return new Response(status, message);
    }

    public static Response createResponse(int status, String message, class_2487 data) {
        return new Response(status, message, data);
    }

    public static UUID getMainDriveId() {
        if (ComputerScreen.getMainDrive() != null) {
            return ComputerScreen.getMainDrive().getUUID();
        }
        return null;
    }

    private void load(class_2487 tag) {
        if (tag.method_10573("main_drive", 10)) {
            this.mainDrive = InternalDrive.fromTag(tag.method_10562("main_drive"));
        }
        if (tag.method_10573("drives", 9)) {
            class_2499 list = tag.method_10554("drives", 10);
            for (int i = 0; i < list.size(); ++i) {
                class_2487 driveTag = list.method_10602(i);
                AbstractDrive drive = InternalDrive.fromTag(driveTag.method_10562("drive"));
                this.additionalDrives.put(drive.getUuid(), drive);
            }
        }
        if (tag.method_10573("external_drive", 10)) {
            this.attachedDrive = ExternalDrive.fromTag(tag.method_10562("external_drive"));
        }
        if (tag.method_10573("external_drive_color", 1)) {
            this.attachedDriveColor = class_1767.method_7791((int)tag.method_10571("external_drive_color"));
        }
        this.setupDefault();
    }

    private void setupDefault() {
        if (this.mainDrive == null) {
            this.mainDrive = new InternalDrive(LAPTOP_DRIVE_NAME);
            this.blockEntity.method_5431();
        }
    }

    @Deprecated
    private ServerFolder createProtectedFolder(String name) {
        try {
            Constructor constructor = ServerFolder.class.getDeclaredConstructor(String.class, Boolean.TYPE);
            constructor.setAccessible(true);
            return (ServerFolder)constructor.newInstance(name, true);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            e.printStackTrace();
            return null;
        }
    }

    private boolean createSystemDirectory(String name) {
        try {
            Ext2FS fs = this.mainDrive.getFS();
            Path path = Path.of(name, new String[0]);
            fs.createDirectory(path);
            fs.setReadOnly(path, true);
            return true;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    public Response readAction(UUID driveUuid, FileAction<?> action, class_1937 level) {
        AbstractDrive drive = this.getAvailableDrives(level, true).get(driveUuid);
        if (drive != null) {
            Response response = drive.handleFileAction(this, action, level);
            if (response.getStatus() == 1) {
                this.blockEntity.method_5431();
            }
            return response;
        }
        return FileSystem.createResponse(7, "Drive unavailable or missing");
    }

    public AbstractDrive getMainDrive() {
        return this.mainDrive;
    }

    public Map<UUID, AbstractDrive> getAvailableDrives(@Nullable class_1937 level, boolean includeMain) {
        LinkedHashMap<UUID, AbstractDrive> drives = new LinkedHashMap<UUID, AbstractDrive>();
        if (includeMain && this.mainDrive != null) {
            drives.put(this.mainDrive.getUuid(), this.mainDrive);
        }
        drives.putAll(this.additionalDrives);
        if (this.attachedDrive != null) {
            drives.put(this.attachedDrive.getUuid(), this.attachedDrive);
        }
        return drives;
    }

    public AbstractDrive getAttachedDrive() {
        return this.attachedDrive;
    }

    public class_1767 getAttachedDriveColor() {
        return this.attachedDriveColor;
    }

    public boolean attachDrive(class_1799 flashDrive) {
        class_1792 class_17922 = flashDrive.method_7909();
        if (class_17922 instanceof FlashDriveItem) {
            ExternalDrive drive;
            FlashDriveItem flashDriveItem = (FlashDriveItem)class_17922;
            if (this.attachedDrive == null && (drive = FileSystem.getExternalDrive(flashDrive)) != null) {
                drive.setName(flashDrive.method_7964().getString());
                this.attachedDrive = drive;
                this.attachedDriveColor = flashDriveItem.getColor();
                this.blockEntity.getPipeline().method_10567("external_drive_color", (byte)this.attachedDriveColor.method_7789());
                this.blockEntity.sync();
                return true;
            }
        }
        return false;
    }

    @Nullable
    public class_1799 detachDrive() {
        if (this.attachedDrive != null) {
            class_1799 stack = new class_1799((class_1935)DeviceItems.getFlashDriveByColor(this.attachedDriveColor), 1);
            stack.method_57379(class_9334.field_49631, (Object)class_2561.method_43470((String)this.attachedDrive.getName()));
            stack.method_57379((class_9331)DeviceDataComponents.DISK.get(), (Object)this.attachedDrive.getUuid());
            this.attachedDrive = null;
            return stack;
        }
        return null;
    }

    @Deprecated
    public static class_2487 getExternalDriveTag(class_1799 stack) {
        if (!stack.method_57826((class_9331)DeviceDataComponents.DISK.get())) {
            ExternalDrive externalDrive = new ExternalDrive(stack.method_7954().getString());
            stack.method_57379((class_9331)DeviceDataComponents.DISK.get(), (Object)externalDrive.getUuid());
        }
        return new class_2487();
    }

    public static UUID getExternalDriveId(class_1799 stack) {
        if (!stack.method_57826((class_9331)DeviceDataComponents.DISK.get())) {
            ExternalDrive externalDrive = new ExternalDrive(stack.method_7954().getString());
            stack.method_57379((class_9331)DeviceDataComponents.DISK.get(), (Object)externalDrive.getUuid());
            return externalDrive.getUuid();
        }
        return (UUID)stack.method_57824((class_9331)DeviceDataComponents.DISK.get());
    }

    public static ExternalDrive getExternalDrive(class_1799 stack) {
        if (stack.method_57826((class_9331)DeviceDataComponents.DISK.get())) {
            UUID uuid = (UUID)stack.method_57824((class_9331)DeviceDataComponents.DISK.get());
            return DriveManager.getExternalDrive(uuid);
        }
        ExternalDrive externalDrive = new ExternalDrive(stack.method_7954().getString());
        try {
            DriveManager.registerExternalDrive(externalDrive);
        }
        catch (IOException e) {
            throw new DeviceFSException("Failed to register external drive", e);
        }
        stack.method_57379((class_9331)DeviceDataComponents.DISK.get(), (Object)externalDrive.getUuid());
        return externalDrive;
    }

    public class_2487 toTag() {
        class_2487 fileSystemTag = new class_2487();
        if (this.mainDrive != null) {
            fileSystemTag.method_10566("main_drive", (class_2520)this.mainDrive.toTag());
        }
        class_2499 list = new class_2499();
        this.additionalDrives.forEach((k, v) -> list.add((Object)v.toTag()));
        fileSystemTag.method_10566("drives", (class_2520)list);
        if (this.attachedDrive != null) {
            fileSystemTag.method_10566("external_drive", (class_2520)this.attachedDrive.toTag());
            fileSystemTag.method_10567("external_drive_color", (byte)this.attachedDriveColor.method_7789());
        }
        return fileSystemTag;
    }

    public Map<UUID, DriveInfo> getDrives() {
        HashMap<UUID, DriveInfo> drives = new HashMap<UUID, DriveInfo>();
        if (this.mainDrive != null) {
            drives.put(this.mainDrive.getUuid(), new DriveInfo(this.mainDrive.getName(), this.mainDrive.getUuid(), Drive.Type.INTERNAL, true));
        }
        this.additionalDrives.forEach((k, v) -> drives.put(v.getUuid(), new DriveInfo(v.getName(), v.getUuid(), Drive.Type.INTERNAL)));
        if (this.attachedDrive != null) {
            drives.put(this.attachedDrive.getUuid(), new DriveInfo(this.attachedDrive.getName(), this.attachedDrive.getUuid(), Drive.Type.EXTERNAL));
        }
        return drives;
    }

    public static final class Status {
        public static final int FAILED = 0;
        public static final int SUCCESSFUL = 1;
        public static final int FILE_INVALID = 2;
        public static final int FILE_IS_PROTECTED = 3;
        public static final int FILE_EXISTS = 4;
        public static final int FILE_INVALID_NAME = 5;
        public static final int FILE_INVALID_DATA = 6;
        public static final int DRIVE_UNAVAILABLE = 7;
        public static final int ACCESS_DENIED = 8;
        public static final int TOO_LARGE = 9;
        public static final int FILE_DOES_NOT_EXIST = 10;
    }

    public static class Response {
        private final int status;
        private String message = "";
        private class_2487 data = new class_2487();

        private Response(int status) {
            this.status = status;
        }

        private Response(int status, String message) {
            this.status = status;
            this.message = message;
        }

        private Response(int status, String message, class_2487 data) {
            this.status = status;
            this.message = message;
            this.data = data;
        }

        public static Response fromTag(class_2487 responseTag) {
            return new Response(responseTag.method_10550("status"), responseTag.method_10558("message"), responseTag.method_10562("data"));
        }

        public int getStatus() {
            return this.status;
        }

        public String getMessage() {
            return this.message;
        }

        public class_2487 getData() {
            return this.data;
        }

        public class_2487 toTag() {
            class_2487 responseTag = new class_2487();
            responseTag.method_10569("status", this.status);
            responseTag.method_10582("message", this.message);
            responseTag.method_10566("data", (class_2520)this.data);
            return responseTag;
        }
    }
}

