/*
 * Decompiled with CFR 0.152.
 */
package dev.ultreon.devices.core.io.drive;

import dev.ultreon.devices.Devices;
import dev.ultreon.devices.core.Ext2FS;
import dev.ultreon.devices.core.FS;
import dev.ultreon.devices.core.LockKey;
import dev.ultreon.devices.core.io.FileSystem;
import dev.ultreon.devices.core.io.ServerFolder;
import dev.ultreon.devices.core.io.action.FileAction;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Iterator;
import java.util.UUID;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2512;
import net.minecraft.class_2520;
import net.minecraft.class_5218;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jnode.fs.FileSystemException;

public abstract class AbstractDrive
implements FS {
    private boolean deferred;
    private Ext2FS fs;
    private boolean invalid = false;
    protected String name;
    protected UUID uuid;
    private boolean damaged;

    AbstractDrive() {
        this(UUID.randomUUID());
    }

    AbstractDrive(UUID uuid) {
        this.name = "Drive";
        this.uuid = uuid;
        if (Devices.getServer() == null) {
            this.deferred = true;
            this.setFs(null);
            return;
        }
        try {
            Path resolve = Devices.getServer().method_27050(class_5218.field_24188).resolve("data/devices/drives/" + String.valueOf(uuid) + ".ext2");
            if (Files.notExists(resolve, new LinkOption[0])) {
                if (Files.notExists(resolve.getParent(), new LinkOption[0])) {
                    Files.createDirectories(resolve.getParent(), new FileAttribute[0]);
                }
                this.setFs(Ext2FS.format(resolve, 1L));
                this.setup();
            } else {
                this.setFs(Ext2FS.open(resolve));
            }
        }
        catch (IOException | FileSystemException e) {
            this.invalid = true;
            this.setFs(null);
        }
    }

    protected void setup() {
    }

    AbstractDrive(UUID uuid, Path drivePath) throws FileSystemException, IOException {
        this.name = "OS";
        this.uuid = uuid;
        this.setFs(Ext2FS.open(drivePath));
    }

    AbstractDrive(String name) {
        this(name, UUID.randomUUID());
    }

    public AbstractDrive(String name, UUID uuid) {
        this.name = name;
        this.uuid = uuid;
        if (Devices.getServer() == null) {
            this.deferred = true;
            this.setFs(null);
            return;
        }
        try {
            Path resolve = Devices.getServer().method_27050(class_5218.field_24188).resolve("data/devices/drives/" + String.valueOf(uuid) + ".ext2");
            if (Files.notExists(resolve, new LinkOption[0])) {
                if (Files.notExists(resolve.getParent(), new LinkOption[0])) {
                    Files.createDirectories(resolve.getParent(), new FileAttribute[0]);
                }
                this.setFs(Ext2FS.format(resolve, 0x1000000L));
                this.setup();
            } else {
                this.setFs(Ext2FS.open(resolve));
            }
        }
        catch (IOException | FileSystemException e) {
            this.invalid = true;
            this.setFs(null);
        }
    }

    public static Path getDrivePath(UUID uuid) {
        return Devices.getServer().method_27050(class_5218.field_24188).resolve("data/devices/drives/" + String.valueOf(uuid) + ".ext2");
    }

    private void createProtectedFolder(Ext2FS fs, String name) {
        try {
            Path path = Path.of(name, new String[0]);
            fs.createDirectory(path);
            fs.setReadOnly(path, true);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public UUID getUuid() {
        return this.uuid;
    }

    @Deprecated
    public ServerFolder getRoot(class_1937 level) {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FileSystem.Response handleFileAction(FileSystem fileSystem, FileAction action, class_1937 level) {
        class_2487 actionData = action.data();
        LockKey lock = this.getFs().lock(actionData.method_10558("directory"));
        try {
            class_2487 data = actionData.method_10562("data");
            FileSystem.Response response = switch (action.type()) {
                case FileAction.Type.NEW_FILE -> this.newFile(actionData, data);
                case FileAction.Type.NEW_FOLDER -> this.newFolder(actionData, data);
                case FileAction.Type.NEW_FOLDERS -> this.newFolders(actionData, data);
                case FileAction.Type.DELETE -> this.delete(actionData);
                case FileAction.Type.RENAME -> this.rename(actionData);
                case FileAction.Type.WRITE -> this.writeData(actionData, data);
                case FileAction.Type.EXISTS -> this.exists(actionData);
                case FileAction.Type.READ -> this.readData(actionData);
                case FileAction.Type.LIST_DIR -> this.listDir(actionData);
                case FileAction.Type.INFO -> this.info(actionData);
                case FileAction.Type.MOVE -> this.move(actionData);
                case FileAction.Type.COPY -> this.copy(actionData);
                case FileAction.Type.EXTRA_INFO -> this.extraInfo(actionData);
                default -> throw new IOException("Invalid FS action: " + String.valueOf((Object)action.type()));
            };
            if (lock != null) {
                this.getFs().unlock(actionData.method_10558("directory"));
            }
            return response;
        }
        catch (Throwable throwable) {
            try {
                if (lock != null) {
                    this.getFs().unlock(actionData.method_10558("directory"));
                }
                throw throwable;
            }
            catch (IOException e) {
                return FileSystem.createResponse(2, "I/O error: " + e.getMessage());
            }
        }
    }

    private FileSystem.Response newFolders(class_2487 actionData, class_2487 data) throws IOException {
        Path path = Path.of(actionData.method_10558("path"), new String[0]);
        String string = path.toString();
        if (string.endsWith("/")) {
            string = string.substring(0, string.length() - 1);
        }
        if (string.startsWith("/")) {
            string = string.substring(1);
        }
        String[] folders = string.split("/");
        path = Path.of("/", new String[0]);
        for (int i = 0; i < folders.length; ++i) {
            path = path.resolve(folders[i]);
            try {
                if (this.getFs().exists(path)) continue;
                try {
                    this.getFs().createDirectory(path);
                    continue;
                }
                catch (IOException e) {
                    return FileSystem.createResponse(2, "Failed to create folder: " + e.getMessage());
                }
            }
            catch (IOException e) {
                return FileSystem.createResponse(2, "Failed to check folder: " + e.getMessage());
            }
        }
        return FileSystem.createResponse(1, "Created folder " + folders[folders.length - 1], this.info(path));
    }

    private class_2487 info(Path path) throws IOException {
        class_2487 data = new class_2487();
        class_2487 drive = new class_2487();
        drive.method_10582("name", this.getName());
        drive.method_10566("uuid", (class_2520)class_2512.method_25929((UUID)this.getUuid()));
        drive.method_10567("type", (byte)this.getType().ordinal());
        data.method_10566("drive", (class_2520)drive);
        data.method_10582("path", path.toString());
        data.method_10556("protected", this.getFs().isReadOnly(path));
        data.method_10556("folder", this.getFs().isFolder(path));
        data.method_10544("size", this.getFs().size(path));
        return data;
    }

    private FileSystem.Response extraInfo(class_2487 actionData) throws IOException {
        Path path = Path.of(actionData.method_10558("path"), new String[0]);
        if (!this.getFs().exists(path)) {
            return FileSystem.createResponse(2, "Can't ex-stat file, file not found!");
        }
        class_2487 data = new class_2487();
        data.method_10544("size", this.getFs().size(path));
        data.method_10544("lastModified", this.getFs().lastModified(path));
        data.method_10544("lastAccessed", this.getFs().lastAccessed(path));
        data.method_10544("creationTime", this.getFs().creationTime(path));
        return FileSystem.createResponse(1, "", data);
    }

    private FileSystem.Response move(class_2487 actionData) throws IOException {
        Path source = Path.of(actionData.method_10558("source"), new String[0]);
        Path destination = Path.of(actionData.method_10558("destination"), new String[0]);
        if (!this.getFs().exists(source)) {
            return FileSystem.createResponse(2, "Can't move file, file not found!");
        }
        try {
            this.getFs().move(source, destination);
            return FileSystem.createSuccessResponse();
        }
        catch (IOException e) {
            return FileSystem.createResponse(2, "I/O error: " + e.getMessage());
        }
    }

    private FileSystem.Response copy(class_2487 actionData) throws IOException {
        Path source = Path.of(actionData.method_10558("source"), new String[0]);
        Path destination = Path.of(actionData.method_10558("destination"), new String[0]);
        if (!this.getFs().exists(source)) {
            return FileSystem.createResponse(2, "Can't copy file, file not found!");
        }
        try {
            this.getFs().copy(source, destination);
            return FileSystem.createResponse(1, "", this.info(destination));
        }
        catch (IOException e) {
            return FileSystem.createResponse(2, "I/O error: " + e.getMessage());
        }
    }

    private FileSystem.Response info(class_2487 actionData) throws IOException {
        Path path = Path.of(actionData.method_10558("path"), new String[0]);
        if (!this.getFs().exists(path)) {
            return FileSystem.createResponse(2, "Can't stat file, file not found!");
        }
        return FileSystem.createResponse(1, "", this.info(path));
    }

    private FileSystem.Response listDir(class_2487 actionData) throws IOException {
        Path path = Path.of(actionData.method_10558("path"), new String[0]);
        if (!this.getFs().exists(path)) {
            return FileSystem.createResponse(2, "Can't list directory, file not found!");
        }
        class_2487 data = new class_2487();
        class_2499 list = new class_2499();
        Iterator<String> iterator = this.getFs().listDirectory(path);
        while (iterator.hasNext()) {
            String child = iterator.next();
            list.add((Object)this.info(path.resolve(child)));
        }
        data.method_10566("files", (class_2520)list);
        return FileSystem.createResponse(1, "", data);
    }

    private FileSystem.Response readData(class_2487 actionData) throws IOException {
        Path path = Path.of(actionData.method_10558("path"), new String[0]);
        if (!this.getFs().exists(path)) {
            return FileSystem.createResponse(2, "Can't read file, file not found!");
        }
        long offset = actionData.method_10537("offset");
        int length = actionData.method_10550("length");
        if (offset < 0L || length < 0) {
            try (InputStream read = this.read(path, StandardOpenOption.READ);){
                class_2487 data = new class_2487();
                data.method_10570("data", read.readAllBytes());
                FileSystem.Response response = FileSystem.createResponse(1, "", data);
                return response;
            }
        }
        ByteBuffer buffer = ByteBuffer.allocate(length);
        this.fs.read(path, buffer, offset);
        buffer.flip();
        class_2487 data = new class_2487();
        data.method_10570("data", buffer.array());
        return FileSystem.createResponse(1, "", data);
    }

    private FileSystem.Response exists(class_2487 actionData) throws IOException {
        Path path = Path.of(actionData.method_10558("path"), new String[0]);
        boolean exists = this.getFs().exists(path);
        class_2487 data = new class_2487();
        data.method_10556("exists", exists);
        return FileSystem.createResponse(1, "", data);
    }

    private @NotNull FileSystem.Response newFile(class_2487 actionData, class_2487 data) throws IOException {
        Path path = Path.of(actionData.method_10558("path"), new String[0]);
        boolean override = actionData.method_10577("override");
        byte[] dataBytes = data.method_10547("data");
        if (!override && this.getFs().exists(path)) {
            return FileSystem.createResponse(4, "File already exists");
        }
        if (this.getFS().exists(path)) {
            this.getFs().delete(path);
        }
        this.createFile(path, dataBytes);
        return FileSystem.createResponse(1, "", this.info(path));
    }

    private @NotNull FileSystem.Response newFolder(class_2487 actionData, class_2487 data) throws IOException {
        Path path = Path.of(actionData.method_10558("path"), new String[0]);
        if (path.toString().equals("/")) {
            throw new IOException("Can't create root folder");
        }
        boolean override = actionData.method_10577("override");
        byte[] dataBytes = data.method_10547("data");
        if (!override && this.getFs().exists(path)) {
            return FileSystem.createResponse(4, "File already exists");
        }
        this.createDirectory(path);
        return FileSystem.createResponse(1, "", this.info(path));
    }

    private @NotNull FileSystem.Response delete(class_2487 actionData) throws IOException {
        Path path = Path.of(actionData.method_10558("path"), new String[0]);
        if (!this.getFs().exists(path)) {
            return FileSystem.createResponse(2, "File not found on server. Please refresh!");
        }
        this.getFs().delete(path);
        return FileSystem.createSuccessResponse();
    }

    private @NotNull FileSystem.Response rename(class_2487 actionData) throws IOException {
        Path path = Path.of(actionData.method_10558("path"), new String[0]);
        String newName = actionData.method_10558("new_name");
        if (!this.getFs().exists(path)) {
            return FileSystem.createResponse(2, "File not found on server. Please refresh!");
        }
        this.getFs().rename(path, newName);
        return FileSystem.createSuccessResponse();
    }

    private @NotNull FileSystem.Response writeData(class_2487 actionData, class_2487 data) throws IOException {
        Path path = Path.of(actionData.method_10558("path"), new String[0]);
        long offset = actionData.method_10537("offset");
        if (!this.getFs().exists(path)) {
            return FileSystem.createResponse(7, "Invalid directory");
        }
        byte[] dataBytes = actionData.method_10547("data");
        if (offset == -1L) {
            try (OutputStream write = this.write(path, StandardOpenOption.WRITE, StandardOpenOption.TRUNCATE_EXISTING);){
                write.write(dataBytes);
            }
        } else {
            this.fs.write(path, offset, dataBytes);
        }
        return FileSystem.createResponse(1, "", this.info(path));
    }

    private @NotNull FileSystem.Response copyOrCut(FileSystem fileSystem, class_1937 level, class_2487 actionData) throws IOException {
        Path file = Path.of(actionData.method_10558("source"), new String[0]);
        if (!this.getFs().exists(file)) {
            return FileSystem.createResponse(2, "File not found on server. Please refresh!");
        }
        UUID uuid = UUID.fromString(actionData.method_10558("destination_drive"));
        AbstractDrive drive = fileSystem.getAvailableDrives(level, true).get(uuid);
        if (drive == null) {
            return FileSystem.createResponse(7, "Drive unavailable. Please refresh!");
        }
        Path destination = Path.of(actionData.method_10558("destination_folder"), new String[0]);
        if (!this.getFs().exists(destination)) {
            return FileSystem.createResponse(2, "Destination folder not found on server. Please refresh!");
        }
        for (Path temp = destination; temp != null; temp = temp.getParent()) {
            if (!temp.equals(file)) continue;
            return FileSystem.createResponse(0, "Destination folder can't be a subfolder");
        }
        try (InputStream read = this.read(file, StandardOpenOption.READ);){
            FileSystem.Response response;
            block20: {
                OutputStream write;
                block18: {
                    FileSystem.Response response2;
                    block19: {
                        this.createFile(destination, read.readAllBytes());
                        write = this.write(destination, StandardOpenOption.CREATE, StandardOpenOption.WRITE, StandardOpenOption.TRUNCATE_EXISTING);
                        try {
                            byte[] bytes = read.readAllBytes();
                            write.write(bytes);
                            write.flush();
                            if (actionData.method_10577("cut")) break block18;
                            response2 = FileSystem.createSuccessResponse();
                            if (write == null) break block19;
                        }
                        catch (Throwable throwable) {
                            if (write != null) {
                                try {
                                    write.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        write.close();
                    }
                    return response2;
                }
                this.getFs().delete(file);
                response = FileSystem.createSuccessResponse();
                if (write == null) break block20;
                write.close();
            }
            return response;
        }
    }

    public abstract class_2487 toTag();

    public abstract Type getType();

    @Deprecated
    @Nullable
    public ServerFolder getFolder(String path) {
        if (path == null) {
            throw new IllegalArgumentException("The path can not be null");
        }
        if (!FileSystem.PATTERN_DIRECTORY.matcher(path).matches()) {
            throw new IllegalArgumentException("The path \"" + path + "\" does not follow the correct format");
        }
        return null;
    }

    @Deprecated
    public ServerFolder getDriveStructure() {
        return null;
    }

    @Override
    public void close() throws IOException {
        this.getFs().close();
    }

    @Override
    public InputStream read(Path path, OpenOption ... options) throws IOException {
        return this.getFs().read(path, options);
    }

    @Override
    public OutputStream write(Path path, OpenOption ... options) throws IOException {
        return this.getFs().write(path, options);
    }

    @Override
    public boolean exists(Path path) throws IOException {
        return this.getFs().exists(path);
    }

    @Override
    public void flush() throws IOException {
        this.getFs().flush();
    }

    @Override
    public void createFile(Path path, byte[] data) throws IOException {
        this.getFs().createFile(path, data);
    }

    @Override
    public void createDirectory(Path path) throws IOException {
        this.getFs().createDirectory(path);
    }

    @Override
    public Iterator<String> listDirectory(Path of) throws IOException {
        return this.getFs().listDirectory(of);
    }

    @Override
    public void delete(Path path) throws IOException {
        this.getFs().delete(path);
    }

    @Override
    public long size(Path path) throws IOException {
        return this.getFs().size(path);
    }

    @Override
    public void rename(Path from, String name) throws IOException {
        this.getFs().rename(from, name);
    }

    @Override
    public boolean isFolder(Path path) throws IOException {
        return this.getFs().isFolder(path);
    }

    @Override
    public boolean isFile(Path path) throws IOException {
        return this.getFs().isFile(path);
    }

    @Override
    public boolean isSymbolicLink(Path path) throws IOException {
        return this.getFs().isSymbolicLink(path);
    }

    public void setDamaged(boolean b) {
        this.damaged = b;
    }

    public boolean isDamaged() {
        return this.damaged;
    }

    @Override
    public boolean canRead(Path of) throws IOException {
        return this.getFs().canRead(of);
    }

    @Override
    public boolean canWrite(Path of) throws IOException {
        return this.getFs().canWrite(of);
    }

    @Override
    public void setReadOnly(Path of, boolean b) throws IOException {
        this.getFs().setReadOnly(of, b);
    }

    @Override
    public void setExecutable(Path of, boolean b) throws IOException {
        this.getFs().setExecutable(of, b);
    }

    @Override
    public boolean canExecute(Path of) throws IOException {
        return this.getFs().canExecute(of);
    }

    public Ext2FS getFS() throws IOException {
        return this.getFs();
    }

    public Ext2FS getFs() throws IOException {
        if (this.deferred || this.fs == null) {
            this.deferred = false;
            if (this.fs != null) {
                return this.fs;
            }
            try {
                Path resolve = Devices.getServer().method_27050(class_5218.field_24188).resolve("data/devices/drives/" + String.valueOf(this.uuid) + ".ext2");
                if (Files.notExists(resolve, new LinkOption[0])) {
                    if (Files.notExists(resolve.getParent(), new LinkOption[0])) {
                        Files.createDirectories(resolve.getParent(), new FileAttribute[0]);
                    }
                    this.setFs(Ext2FS.format(resolve, 0x1000000L));
                    this.setup();
                } else {
                    this.setFs(Ext2FS.open(resolve));
                }
            }
            catch (IOException | FileSystemException e) {
                this.invalid = true;
                throw new IOException("Failed to open drive, vHardware failure. Device invalid!", e);
            }
        }
        if (this.invalid | this.damaged) {
            throw new IOException("Failed to open drive, vHardware failure. Previous error!");
        }
        if (this.fs == null) {
            throw new IOException("Failed to open drive, vHardware failure. Invalid filesystem!");
        }
        return this.fs;
    }

    public void setFs(Ext2FS fs) {
        if (this.fs != null) {
            throw new IllegalStateException("Already set!");
        }
        if (fs == null) {
            throw new IllegalArgumentException("The filesystem can not be null");
        }
        this.fs = fs;
    }

    @Override
    @Nullable
    public LockKey lock(String path) throws IOException {
        return this.fs.lock(path);
    }

    @Override
    public void unlock(String directory) {
        this.fs.unlock(directory);
    }

    @Override
    public boolean isLocked(String directory) {
        return this.fs.isLocked(directory);
    }

    @Override
    public boolean isExecutable(Path of) throws IOException {
        return this.fs.isExecutable(of);
    }

    @Override
    public boolean isWritable(Path of) throws IOException {
        return this.fs.isWritable(of);
    }

    @Override
    public boolean isReadable(Path of) throws IOException {
        return this.fs.isReadable(of);
    }

    @Override
    public int getOwner(Path of) throws IOException {
        return this.fs.getOwner(of);
    }

    @Override
    public int getGroup(Path of) throws IOException {
        return this.fs.getGroup(of);
    }

    @Override
    public int getPermissions(Path of) throws IOException {
        return this.fs.getPermissions(of);
    }

    @Override
    public void setPermissions(Path of, int mode) throws IOException {
        this.fs.setPermissions(of, mode);
    }

    @Override
    public void setOwner(Path of, int uid, int gid) throws IOException {
        this.fs.setOwner(of, uid, gid);
    }

    @Override
    public void setGroup(Path of, int gid) throws IOException {
        this.fs.setGroup(of, gid);
    }

    @Override
    public void setOwner(Path of, int uid) throws IOException {
        this.fs.setOwner(of, uid);
    }

    @Override
    public long getGeneration(Path of) throws IOException {
        return this.fs.getGeneration(of);
    }

    @Override
    public void setGeneration(Path of, long generation) throws IOException {
        this.fs.setGeneration(of, generation);
    }

    @Override
    public boolean isReadOnly(Path of) throws IOException {
        return this.fs.isReadOnly(of);
    }

    @Override
    public long lastModified(Path path) throws IOException {
        return this.fs.lastModified(path);
    }

    @Override
    public long lastAccessed(Path path) throws IOException {
        return this.fs.lastAccessed(path);
    }

    @Override
    public long creationTime(Path path) throws IOException {
        return this.fs.creationTime(path);
    }

    @Override
    public void setLastAccessed(Path path, long time) throws IOException {
        this.fs.setLastAccessed(path, time);
    }

    @Override
    public void setLastModified(Path path, long time) throws IOException {
        this.fs.setLastModified(path, time);
    }

    @Override
    public void setCreationTime(Path path, long time) throws IOException {
        this.fs.setCreationTime(path, time);
    }

    @Override
    public long getTotalSpace() throws IOException {
        return this.fs.getTotalSpace();
    }

    @Override
    public long getUsableSpace() throws IOException {
        return this.fs.getUsableSpace();
    }

    @Override
    public long getFreeSpace() throws IOException {
        return this.fs.getFreeSpace();
    }

    @Override
    public void move(Path source, Path destination) throws IOException {
        this.fs.move(source, destination);
    }

    @Override
    public void copy(Path source, Path destination) throws IOException {
        this.fs.copy(source, destination);
    }

    @Override
    public void write(Path path, long offset, byte[] dataBytes) throws IOException {
        this.fs.write(path, offset, dataBytes);
    }

    @Override
    public void write(Path path, byte[] dataBytes) throws IOException {
        this.fs.write(path, dataBytes);
    }

    @Override
    public void truncate(Path path, long size) throws IOException {
        this.fs.truncate(path, size);
    }

    @Override
    public void read(Path path, ByteBuffer buffer, long offset) throws IOException {
        this.fs.read(path, buffer, offset);
    }

    public static enum Type {
        INTERNAL,
        EXTERNAL,
        NETWORK;

    }
}

