/*
 * Decompiled with CFR 0.152.
 */
package dev.ultreon.devices.core.io.drive;

import dev.ultreon.devices.core.io.drive.AbstractDrive;
import java.io.IOException;
import java.nio.file.Path;
import java.util.UUID;
import java.util.function.Predicate;
import net.minecraft.class_2487;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jnode.fs.FileSystemException;

public final class ExternalDrive
extends AbstractDrive {
    private static final Predicate<class_2487> PREDICATE_DRIVE_TAG = tag -> tag.method_10573("name", 8) && tag.method_10573("uuid", 8) && tag.method_10573("root", 10);

    private ExternalDrive() {
    }

    public ExternalDrive(String displayName) {
        super(displayName);
    }

    private ExternalDrive(UUID uuid, Path drivePath) throws FileSystemException, IOException {
        super(uuid, drivePath);
    }

    private ExternalDrive(String s, UUID uuid) {
        super(s);
        this.uuid = uuid;
    }

    public static ExternalDrive load(UUID uuid, Path drivePath) {
        try {
            return new ExternalDrive(uuid, drivePath);
        }
        catch (IOException | FileSystemException e) {
            return null;
        }
    }

    @ApiStatus.Internal
    @NotNull
    public static ExternalDrive fromTag(class_2487 driveTag) {
        return new ExternalDrive(driveTag.method_10545("name") ? driveTag.method_10558("name") : "Drive", UUID.fromString(driveTag.method_10558("uuid")));
    }

    @Override
    @ApiStatus.Internal
    public class_2487 toTag() {
        class_2487 driveTag = new class_2487();
        driveTag.method_10582("name", this.name);
        driveTag.method_10582("uuid", this.uuid.toString());
        return driveTag;
    }

    @Override
    public AbstractDrive.Type getType() {
        return AbstractDrive.Type.EXTERNAL;
    }
}

