/*
 * Decompiled with CFR 0.152.
 */
package dev.ultreon.devices.core.network;

import dev.ultreon.devices.Devices;
import dev.ultreon.devices.block.entity.RouterBlockEntity;
import dev.ultreon.devices.core.network.Router;
import dev.ultreon.devices.debug.DebugLog;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2512;
import net.minecraft.class_2586;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Connection {
    private UUID routerId;
    private class_2338 routerPos;

    private Connection() {
    }

    public Connection(Router router) {
        this.routerId = router.getId();
        this.routerPos = router.getPos();
    }

    public UUID getRouterId() {
        return this.routerId;
    }

    @Nullable
    public class_2338 getRouterPos() {
        return this.routerPos;
    }

    public void setRouterPos(@Nullable class_2338 routerPos) {
        this.routerPos = routerPos;
    }

    @Nullable
    public Router getRouter(@NotNull class_1937 level) {
        if (this.routerPos == null) {
            return null;
        }
        class_2586 blockEntity = level.method_8321(this.routerPos);
        System.out.println("routerPos = " + String.valueOf(this.routerPos));
        System.out.println("blockEntity = " + String.valueOf(blockEntity));
        if (blockEntity instanceof RouterBlockEntity) {
            RouterBlockEntity router = (RouterBlockEntity)blockEntity;
            if (router.getRouter().getId().equals(this.routerId)) {
                return router.getRouter();
            }
            DebugLog.log("Invalid router ID");
        } else {
            DebugLog.log("Router is not a router");
        }
        return null;
    }

    public boolean isConnected() {
        return this.routerPos != null;
    }

    public class_2487 toTag() {
        class_2487 tag = new class_2487();
        tag.method_10582("id", this.routerId.toString());
        if (this.routerPos != null) {
            tag.method_10566("Pos", class_2512.method_10692((class_2338)this.routerPos));
        }
        return tag;
    }

    public static Connection fromTag(class_2487 tag) {
        Connection connection = new Connection();
        connection.routerId = UUID.fromString(tag.method_10558("id"));
        if (tag.method_10573("Pos", 10)) {
            Optional pos = class_2512.method_10691((class_2487)tag, (String)"Pos");
            if (pos.isEmpty()) {
                Devices.LOGGER.warn("Failed to read block position from connection tag!");
                connection.routerPos = null;
            } else {
                connection.routerPos = (class_2338)pos.get();
            }
        }
        return connection;
    }
}

