/*
 * Decompiled with CFR 0.152.
 */
package dev.ultreon.devices.core.network;

import dev.ultreon.devices.DeviceConfig;
import dev.ultreon.devices.api.event.RouterBeaconEvent;
import dev.ultreon.devices.block.entity.NetworkDeviceBlockEntity;
import dev.ultreon.devices.block.entity.RouterBlockEntity;
import dev.ultreon.devices.core.network.DeviceConnectEvent;
import dev.ultreon.devices.core.network.NetworkDevice;
import dev.ultreon.devices.init.DeviceBlockEntities;
import dev.ultreon.mods.xinexlib.event.system.EventSystem;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Predicate;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_6862;
import net.minecraft.class_7923;
import org.jetbrains.annotations.Nullable;

public class Router {
    private final Map<UUID, NetworkDevice> networkDevices = new HashMap<UUID, NetworkDevice>();
    private int timer;
    private UUID routerId;
    private class_2338 pos;

    public Router(class_2338 pos) {
        this.pos = pos;
    }

    public void tick(RouterBlockEntity blockEntity, class_1937 level) {
        if (++this.timer >= (Integer)DeviceConfig.BEACON_INTERVAL.get()) {
            this.sendBeacon(blockEntity, level);
            this.timer = 0;
        }
    }

    public boolean addDevice(UUID id, String name) {
        NetworkDevice networkDevice;
        if (this.networkDevices.size() >= (Integer)DeviceConfig.MAX_DEVICES.get()) {
            return this.networkDevices.containsKey(id);
        }
        if (!this.networkDevices.containsKey(id) && !((DeviceConnectEvent)EventSystem.MAIN.publish((Object)new DeviceConnectEvent(this, networkDevice = new NetworkDevice(id, name, this)))).isCanceled()) {
            this.networkDevices.put(id, networkDevice);
        }
        this.timer = (Integer)DeviceConfig.BEACON_INTERVAL.get();
        return true;
    }

    public boolean addDevice(NetworkDeviceBlockEntity device) {
        NetworkDevice networkDevice;
        if (this.networkDevices.size() >= (Integer)DeviceConfig.MAX_DEVICES.get()) {
            return this.networkDevices.containsKey(device.getId());
        }
        if (!this.networkDevices.containsKey(device.getId()) && !((DeviceConnectEvent)EventSystem.MAIN.publish((Object)new DeviceConnectEvent(this, networkDevice = new NetworkDevice(device)))).isCanceled()) {
            this.networkDevices.put(device.getId(), networkDevice);
        }
        return true;
    }

    public boolean isDeviceRegistered(NetworkDeviceBlockEntity device) {
        return this.networkDevices.containsKey(device.getId());
    }

    public boolean isDeviceConnected(NetworkDeviceBlockEntity device) {
        return this.isDeviceRegistered(device) && this.networkDevices.get(device.getId()).getPos() != null;
    }

    public void removeDevice(NetworkDeviceBlockEntity device) {
        this.networkDevices.remove(device.getId());
    }

    @Nullable
    public NetworkDeviceBlockEntity getDevice(class_1937 level, UUID id) {
        return this.networkDevices.containsKey(id) ? this.networkDevices.get(id).getDevice(level) : null;
    }

    public Collection<NetworkDevice> getNetworkDevices() {
        return this.networkDevices.values();
    }

    public Collection<NetworkDevice> getConnectedDevices(class_1937 level) {
        Optional blockEntity = level.method_35230(this.pos, (class_2591)DeviceBlockEntities.ROUTER.get());
        if (blockEntity.isEmpty()) {
            return Collections.emptyList();
        }
        this.sendBeacon((RouterBlockEntity)blockEntity.get(), level);
        return this.networkDevices.values().stream().filter(device -> device.getPos() != null).toList();
    }

    public Collection<NetworkDevice> getConnectedDevices(class_1937 level, class_2591<?> targetType) {
        Predicate<NetworkDevice> deviceType = networkDevice -> {
            NetworkDeviceBlockEntity device;
            if (networkDevice.getPos() == null) {
                return false;
            }
            class_2586 blockEntity = level.method_8321(networkDevice.getPos());
            return blockEntity instanceof NetworkDeviceBlockEntity && targetType.equals((device = (NetworkDeviceBlockEntity)blockEntity).method_11017());
        };
        return this.getConnectedDevices(level).stream().filter(deviceType).toList();
    }

    public Collection<NetworkDevice> getConnectedDevices(class_1937 level, class_6862<class_2591<?>> targetType) {
        Predicate<NetworkDevice> deviceType = networkDevice -> {
            if (networkDevice.getPos() == null) {
                return false;
            }
            class_2586 blockEntity = level.method_8321(networkDevice.getPos());
            if (blockEntity instanceof NetworkDeviceBlockEntity) {
                NetworkDeviceBlockEntity device = (NetworkDeviceBlockEntity)blockEntity;
                return class_7923.field_41181.method_47983((Object)blockEntity.method_11017()).method_40220(targetType);
            }
            return false;
        };
        return this.getConnectedDevices(level).stream().filter(deviceType).toList();
    }

    private void sendBeacon(RouterBlockEntity blockEntity, class_1937 level) {
        if (level.field_9236) {
            return;
        }
        EventSystem.MAIN.publish((Object)new RouterBeaconEvent(this, blockEntity, this.networkDevices));
        this.networkDevices.forEach((uuid, device) -> device.setPos(null));
        int range = (Integer)DeviceConfig.SIGNAL_RANGE.get();
        for (int x = -range; x <= range; ++x) {
            for (int y = -range; y <= range; ++y) {
                for (int z = -range; z <= range; ++z) {
                    this.sendBeaconAt(level, x, y, z);
                }
            }
        }
    }

    private void sendBeaconAt(class_1937 level, int x, int y, int z) {
        class_2338 currentPos = new class_2338(this.pos.method_10263() + x, this.pos.method_10264() + y, this.pos.method_10260() + z);
        class_2586 blockEntity = level.method_8321(currentPos);
        if (blockEntity instanceof NetworkDeviceBlockEntity) {
            NetworkDeviceBlockEntity device = (NetworkDeviceBlockEntity)blockEntity;
            if (!this.networkDevices.containsKey(device.getId())) {
                return;
            }
            if (device.receiveBeacon(this)) {
                this.networkDevices.get(device.getId()).setPos(currentPos);
            }
        }
    }

    public UUID getId() {
        if (this.routerId == null) {
            this.routerId = UUID.randomUUID();
        }
        return this.routerId;
    }

    public class_2338 getPos() {
        return this.pos;
    }

    public void setPos(class_2338 pos) {
        this.pos = pos;
    }

    public class_2487 toTag(boolean includePos) {
        class_2487 tag = new class_2487();
        tag.method_25927("id", this.getId());
        class_2499 deviceList = new class_2499();
        this.networkDevices.forEach((id, device) -> deviceList.add((Object)device.toTag(includePos)));
        tag.method_10566("network_devices", (class_2520)deviceList);
        return tag;
    }

    public static Router fromTag(class_2338 pos, class_2487 tag) {
        Router router = new Router(pos);
        router.routerId = tag.method_25926("id");
        class_2499 deviceList = tag.method_10554("network_devices", 10);
        for (int i = 0; i < deviceList.size(); ++i) {
            NetworkDevice device = NetworkDevice.fromTag(deviceList.method_10602(i));
            router.networkDevices.put(device.getId(), device);
        }
        return router;
    }

    public boolean equals(Object o) {
        if (!(o instanceof Router)) {
            return false;
        }
        Router router = (Router)o;
        return Objects.equals(this.routerId, router.routerId);
    }

    public int hashCode() {
        return Objects.hash(this.routerId);
    }
}

