/*
 * Decompiled with CFR 0.152.
 */
package dev.ultreon.devices.core.network.task;

import dev.ultreon.devices.api.task.Task;
import dev.ultreon.devices.block.entity.NetworkDeviceBlockEntity;
import dev.ultreon.devices.core.network.NetworkDevice;
import dev.ultreon.devices.core.network.Router;
import java.util.Collection;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2818;
import net.minecraft.class_7225;
import net.minecraft.class_7923;

public class TaskGetDevices
extends Task {
    private class_2338 devicePos;
    private class_2591<?> targetType;
    private Collection<NetworkDevice> foundDevices;
    private String reason;

    public TaskGetDevices() {
        super("get_network_devices");
    }

    public TaskGetDevices(class_2338 devicePos) {
        this();
        this.devicePos = devicePos;
    }

    public TaskGetDevices(class_2338 devicePos, class_2591<?> targetType) {
        this();
        this.devicePos = devicePos;
        this.targetType = targetType;
    }

    @Deprecated(forRemoval=true)
    public TaskGetDevices(class_2338 devicePos, Class<? extends NetworkDeviceBlockEntity> ignoredTargetDeviceClass) {
        this();
        this.devicePos = devicePos;
    }

    @Override
    public void prepareRequest(class_7225.class_7874 provider, class_2487 tag) {
        tag.method_10544("devicePos", this.devicePos.method_10063());
        if (this.targetType != null) {
            tag.method_10569("targetType", class_7923.field_41181.method_10206(this.targetType));
        }
    }

    @Override
    public void processRequest(class_7225.class_7874 provider, class_2487 tag, class_1937 level, class_1657 player) {
        class_2338 devicePos = class_2338.method_10092((long)tag.method_10537("devicePos"));
        int typeId = tag.method_10550("targetType");
        if (typeId < 0) {
            this.reason = "Invalid target ID received: " + typeId;
            return;
        }
        class_2591 targetType = (class_2591)class_7923.field_41181.method_10200(typeId);
        class_2586 tileEntity = level.method_8500(devicePos).method_12201(devicePos, class_2818.class_2819.field_12860);
        if (!(tileEntity instanceof NetworkDeviceBlockEntity)) {
            this.reason = "Not a network device";
            return;
        }
        NetworkDeviceBlockEntity tileEntityNetworkDevice = (NetworkDeviceBlockEntity)tileEntity;
        if (!tileEntityNetworkDevice.isConnected()) {
            this.reason = "Not connected to router";
            return;
        }
        Router router = tileEntityNetworkDevice.getRouter();
        if (router == null) {
            this.reason = "No internet access";
            return;
        }
        this.foundDevices = targetType != null ? router.getConnectedDevices(level) : router.getConnectedDevices(level, targetType);
        this.setSuccessful();
    }

    @Override
    public void prepareResponse(class_7225.class_7874 provider, class_2487 tag) {
        if (this.isSucessful()) {
            class_2499 deviceList = new class_2499();
            this.foundDevices.forEach(device -> deviceList.add((Object)device.toTag(true)));
            tag.method_10566("network_devices", (class_2520)deviceList);
        } else {
            tag.method_10582("reason", this.reason);
        }
    }

    @Override
    public void processResponse(class_7225.class_7874 provider, class_2487 tag) {
    }
}

