/*
 * Decompiled with CFR 0.152.
 */
package dev.ultreon.devices.core.print.task;

import dev.ultreon.devices.api.print.IPrint;
import dev.ultreon.devices.api.task.Task;
import dev.ultreon.devices.block.entity.NetworkDeviceBlockEntity;
import dev.ultreon.devices.block.entity.PrinterBlockEntity;
import dev.ultreon.devices.core.network.NetworkDevice;
import dev.ultreon.devices.core.network.Router;
import java.util.UUID;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2586;
import net.minecraft.class_2818;
import net.minecraft.class_7225;

public class TaskPrint
extends Task {
    private class_2338 devicePos;
    private UUID printerId;
    private IPrint print;
    private String reason = null;

    public TaskPrint() {
        super("print");
    }

    public TaskPrint(class_2338 devicePos, NetworkDevice printer, IPrint print) {
        this();
        this.devicePos = devicePos;
        this.printerId = printer.getId();
        this.print = print;
    }

    @Override
    public void prepareRequest(class_7225.class_7874 provider, class_2487 tag) {
        tag.method_10544("devicePos", this.devicePos.method_10063());
        tag.method_25927("printerId", this.printerId);
        tag.method_10566("print", (class_2520)IPrint.save(this.print));
    }

    @Override
    public void processRequest(class_7225.class_7874 provider, class_2487 tag, class_1937 level, class_1657 player) {
        class_2586 tileEntity = level.method_8500(class_2338.method_10092((long)tag.method_10537("devicePos"))).method_12201(class_2338.method_10092((long)tag.method_10537("devicePos")), class_2818.class_2819.field_12860);
        if (tileEntity instanceof NetworkDeviceBlockEntity) {
            NetworkDeviceBlockEntity device = (NetworkDeviceBlockEntity)tileEntity;
            Router router = device.getRouter();
            if (router != null) {
                NetworkDeviceBlockEntity printer = router.getDevice(level, tag.method_25926("printerId"));
                if (printer instanceof PrinterBlockEntity) {
                    IPrint print = IPrint.load(tag.method_10562("print"));
                    ((PrinterBlockEntity)printer).addToQueue(print);
                    this.setSuccessful();
                } else {
                    this.reason = "Network device is not a printer";
                }
            } else {
                this.reason = "Not connected to router";
            }
        } else {
            this.reason = "No network driver found";
        }
    }

    @Override
    public void prepareResponse(class_7225.class_7874 provider, class_2487 tag) {
        if (this.reason != null) {
            tag.method_10582("reason", this.reason);
        }
    }

    @Override
    public void processResponse(class_7225.class_7874 provider, class_2487 tag) {
    }
}

