/*
 * Decompiled with CFR 0.152.
 */
package dev.ultreon.devices.event;

import dev.ultreon.devices.api.WorldSavedData;
import dev.ultreon.devices.api.utils.BankUtil;
import dev.ultreon.devices.programs.email.EmailManager;
import dev.ultreon.mods.xinexlib.event.server.ServerLevelSaveEvent;
import dev.ultreon.mods.xinexlib.event.server.ServerStartingEvent;
import dev.ultreon.mods.xinexlib.event.system.EventSystem;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Objects;
import net.minecraft.class_2487;
import net.minecraft.class_2505;
import net.minecraft.class_2507;
import net.minecraft.class_3218;
import net.minecraft.class_5218;
import net.minecraft.server.MinecraftServer;

public class WorldDataHandler {
    private static final class_5218 DEVICES_MOD_DATA = new class_5218("data/devices-mod");

    public static void init() {
    }

    private static void load(ServerStartingEvent event) {
        MinecraftServer minecraftServer = event.getServer();
        Path modData = Objects.requireNonNull(minecraftServer, "World loaded without server").method_27050(DEVICES_MOD_DATA);
        if (Files.notExists(modData, new LinkOption[0])) {
            try {
                Files.createDirectories(modData, new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        WorldDataHandler.loadData(modData, "emails.dat", EmailManager.INSTANCE);
        WorldDataHandler.loadData(modData, "bank.dat", BankUtil.INSTANCE);
    }

    private static void save(ServerLevelSaveEvent event) {
        class_3218 serverLevel = event.getServerLevel();
        if (!serverLevel.method_27983().equals(class_3218.field_25179)) {
            return;
        }
        MinecraftServer server = serverLevel.method_8503();
        Path modData = server.method_27050(DEVICES_MOD_DATA);
        if (Files.notExists(modData, new LinkOption[0])) {
            try {
                Files.createDirectories(modData, new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        WorldDataHandler.saveData(modData, "emails.dat", EmailManager.INSTANCE);
        WorldDataHandler.saveData(modData, "bank.dat", BankUtil.INSTANCE);
    }

    private static void loadData(Path modData, String fileName, WorldSavedData data) {
        Path dataFile = modData.resolve(fileName);
        if (!Files.exists(dataFile, new LinkOption[0])) {
            return;
        }
        try {
            class_2487 nbt = class_2507.method_30613((Path)dataFile, (class_2505)class_2505.method_53898());
            data.load(nbt);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static void saveData(Path modData, String fileName, WorldSavedData data) {
        try {
            Path dataFile = modData.resolve(fileName);
            if (Files.notExists(dataFile, new LinkOption[0])) {
                Files.createFile(dataFile, new FileAttribute[0]);
            }
            class_2487 nbt = new class_2487();
            data.save(nbt);
            class_2507.method_30614((class_2487)nbt, (Path)dataFile);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    static {
        EventSystem.MAIN.on(ServerStartingEvent.class, WorldDataHandler::load);
        EventSystem.MAIN.on(ServerLevelSaveEvent.class, WorldDataHandler::save);
    }
}

