/*
 * Decompiled with CFR 0.152.
 */
package dev.ultreon.devices.init;

import com.google.common.collect.Streams;
import dev.ultreon.devices.Devices;
import dev.ultreon.devices.ModDeviceTypes;
import dev.ultreon.devices.init.DeviceBlocks;
import dev.ultreon.devices.item.BasicItem;
import dev.ultreon.devices.item.ColoredDeviceItem;
import dev.ultreon.devices.item.ComponentItem;
import dev.ultreon.devices.item.DeviceItem;
import dev.ultreon.devices.item.EthernetCableItem;
import dev.ultreon.devices.item.FlashDriveItem;
import dev.ultreon.devices.item.MotherboardItem;
import dev.ultreon.devices.util.DyeableRegistration;
import dev.ultreon.mods.xinexlib.platform.XinexPlatform;
import dev.ultreon.mods.xinexlib.registrar.Registrar;
import dev.ultreon.mods.xinexlib.registrar.RegistrySupplier;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.class_1747;
import net.minecraft.class_1767;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2248;
import net.minecraft.class_2561;
import net.minecraft.class_5250;
import net.minecraft.class_7924;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DeviceItems {
    private static final Registrar<class_1792> REGISTER = Devices.REGISTRIES.get().getRegistrar(class_7924.field_41197);
    public static final DyeableRegistration<ColoredDeviceItem, class_1792> LAPTOPS = new DyeableRegistration<ColoredDeviceItem, class_1792>(){

        @Override
        public RegistrySupplier<ColoredDeviceItem, class_1792> register(Registrar<class_1792> registrar, class_1767 color) {
            return registrar.register(color.method_7792() + "_laptop", () -> new ColoredDeviceItem((class_2248)DeviceBlocks.LAPTOPS.of(color).get(), new class_1792.class_1793(), color, ModDeviceTypes.COMPUTER));
        }

        @Override
        protected Registrar<class_1792> autoInit() {
            return REGISTER;
        }
    };
    public static final RegistrySupplier<DeviceItem, class_1792> MAC_MAX_X = REGISTER.register("mac_max_x", () -> new DeviceItem((class_2248)DeviceBlocks.MAC_MAX_X.get(), new class_1792.class_1793(), ModDeviceTypes.COMPUTER){

        @NotNull
        public class_2561 method_7848() {
            class_5250 normalName = class_2561.method_43471((String)"block.devices.mac_max_x");
            if (XinexPlatform.isModLoaded((String)"emojiful")) {
                return class_2561.method_43471((String)"block.devices.mac_max_x_emoji");
            }
            return normalName;
        }

        @NotNull
        public class_2561 method_7864(@NotNull class_1799 stack) {
            return this.method_7848();
        }
    });
    public static final DyeableRegistration<ColoredDeviceItem, class_1792> PRINTERS = new DyeableRegistration<ColoredDeviceItem, class_1792>(){

        @Override
        public RegistrySupplier<ColoredDeviceItem, class_1792> register(Registrar<class_1792> registrar, class_1767 color) {
            return registrar.register(color.method_7792() + "_printer", () -> new ColoredDeviceItem((class_2248)DeviceBlocks.PRINTERS.of(color).get(), new class_1792.class_1793(), color, ModDeviceTypes.PRINTER));
        }

        @Override
        protected Registrar<class_1792> autoInit() {
            return REGISTER;
        }
    };
    public static final DyeableRegistration<ColoredDeviceItem, class_1792> ROUTERS = new DyeableRegistration<ColoredDeviceItem, class_1792>(){

        @Override
        public RegistrySupplier<ColoredDeviceItem, class_1792> register(Registrar<class_1792> registrar, class_1767 color) {
            return registrar.register(color.method_7792() + "_router", () -> new ColoredDeviceItem((class_2248)DeviceBlocks.ROUTERS.of(color).get(), new class_1792.class_1793(), color, ModDeviceTypes.ROUTER));
        }

        @Override
        protected Registrar<class_1792> autoInit() {
            return REGISTER;
        }
    };
    public static final DyeableRegistration<ColoredDeviceItem, class_1792> OFFICE_CHAIRS = new DyeableRegistration<ColoredDeviceItem, class_1792>(){

        @Override
        public RegistrySupplier<ColoredDeviceItem, class_1792> register(Registrar<class_1792> registrar, class_1767 color) {
            return registrar.register(color.method_7792() + "_office_chair", () -> new ColoredDeviceItem((class_2248)DeviceBlocks.OFFICE_CHAIRS.of(color).get(), new class_1792.class_1793(), color, ModDeviceTypes.SEAT));
        }

        @Override
        protected Registrar<class_1792> autoInit() {
            return REGISTER;
        }
    };
    public static final DyeableRegistration<FlashDriveItem, class_1792> FLASH_DRIVE = new DyeableRegistration<FlashDriveItem, class_1792>(){

        @Override
        public RegistrySupplier<FlashDriveItem, class_1792> register(Registrar<class_1792> registrar, class_1767 color) {
            return registrar.register(color.method_7792() + "_flash_drive", () -> new FlashDriveItem(color));
        }

        @Override
        protected Registrar<class_1792> autoInit() {
            return REGISTER;
        }
    };
    public static final RegistrySupplier<class_1747, class_1792> PAPER = REGISTER.register("paper", () -> new class_1747((class_2248)DeviceBlocks.PAPER.get(), new class_1792.class_1793()));
    public static final RegistrySupplier<BasicItem, class_1792> PLASTIC_UNREFINED = REGISTER.register("plastic_unrefined", () -> new BasicItem(new class_1792.class_1793()));
    public static final RegistrySupplier<BasicItem, class_1792> PLASTIC = REGISTER.register("plastic", () -> new BasicItem(new class_1792.class_1793()));
    public static final RegistrySupplier<BasicItem, class_1792> PLASTIC_FRAME = REGISTER.register("plastic_frame", () -> new BasicItem(new class_1792.class_1793()));
    public static final RegistrySupplier<BasicItem, class_1792> WHEEL = REGISTER.register("wheel", () -> new BasicItem(new class_1792.class_1793()));
    public static final RegistrySupplier<class_1792, class_1792> GLASS_DUST = REGISTER.register("glass_dust", () -> new class_1792(new class_1792.class_1793()));
    public static final RegistrySupplier<ComponentItem, class_1792> COMPONENT_CIRCUIT_BOARD = REGISTER.register("circuit_board", () -> new ComponentItem(new class_1792.class_1793()));
    public static final RegistrySupplier<ComponentItem, class_1792> COMPONENT_MOTHERBOARD = REGISTER.register("motherboard", () -> new MotherboardItem(new class_1792.class_1793()));
    public static final RegistrySupplier<ComponentItem, class_1792> COMPONENT_MOTHERBOARD_FULL = REGISTER.register("motherboard_full", () -> new ComponentItem(new class_1792.class_1793()));
    public static final RegistrySupplier<ComponentItem, class_1792> COMPONENT_CPU = REGISTER.register("cpu", () -> new MotherboardItem.Component(new class_1792.class_1793()));
    public static final RegistrySupplier<ComponentItem, class_1792> COMPONENT_RAM = REGISTER.register("ram", () -> new MotherboardItem.Component(new class_1792.class_1793()));
    public static final RegistrySupplier<ComponentItem, class_1792> COMPONENT_GPU = REGISTER.register("gpu", () -> new MotherboardItem.Component(new class_1792.class_1793()));
    public static final RegistrySupplier<ComponentItem, class_1792> COMPONENT_WIFI = REGISTER.register("wifi", () -> new MotherboardItem.Component(new class_1792.class_1793()));
    public static final RegistrySupplier<ComponentItem, class_1792> COMPONENT_HARD_DRIVE = REGISTER.register("hard_drive", () -> new ComponentItem(new class_1792.class_1793()));
    public static final RegistrySupplier<ComponentItem, class_1792> COMPONENT_FLASH_CHIP = REGISTER.register("flash_chip", () -> new ComponentItem(new class_1792.class_1793()));
    public static final RegistrySupplier<ComponentItem, class_1792> COMPONENT_SOLID_STATE_DRIVE = REGISTER.register("solid_state_drive", () -> new ComponentItem(new class_1792.class_1793()));
    public static final RegistrySupplier<ComponentItem, class_1792> COMPONENT_BATTERY = REGISTER.register("battery", () -> new ComponentItem(new class_1792.class_1793()));
    public static final RegistrySupplier<ComponentItem, class_1792> COMPONENT_SCREEN = REGISTER.register("screen", () -> new ComponentItem(new class_1792.class_1793()));
    public static final RegistrySupplier<ComponentItem, class_1792> COMPONENT_CONTROLLER_UNIT = REGISTER.register("controller_unit", () -> new ComponentItem(new class_1792.class_1793()));
    public static final RegistrySupplier<ComponentItem, class_1792> COMPONENT_SMALL_ELECTRIC_MOTOR = REGISTER.register("small_electric_motor", () -> new ComponentItem(new class_1792.class_1793()));
    public static final RegistrySupplier<ComponentItem, class_1792> COMPONENT_CARRIAGE = REGISTER.register("carriage", () -> new ComponentItem(new class_1792.class_1793()));
    public static final RegistrySupplier<EthernetCableItem, class_1792> ETHERNET_CABLE = REGISTER.register("ethernet_cable", EthernetCableItem::new);

    public static Stream<class_1792> getAllItems() {
        return Streams.stream(REGISTER).map(RegistrySupplier::get);
    }

    @Nullable
    public static FlashDriveItem getFlashDriveByColor(class_1767 color) {
        return (FlashDriveItem)FLASH_DRIVE.of(color).get();
    }

    public static List<FlashDriveItem> getAllFlashDrives() {
        return DeviceItems.getAllItems().filter(item -> item.method_8389() instanceof FlashDriveItem).map(item -> (FlashDriveItem)item.method_8389()).toList();
    }

    public static List<ColoredDeviceItem> getAllLaptops() {
        return DeviceItems.getAllItems().filter(item -> item.method_8389() instanceof ColoredDeviceItem).map(item -> (ColoredDeviceItem)item.method_8389()).filter(item -> item.getDeviceType() == ModDeviceTypes.COMPUTER).toList();
    }

    public static List<ColoredDeviceItem> getAllPrinters() {
        return DeviceItems.getAllItems().filter(item -> item.method_8389() instanceof ColoredDeviceItem).map(item -> (ColoredDeviceItem)item.method_8389()).filter(item -> item.getDeviceType() == ModDeviceTypes.PRINTER).toList();
    }

    public static List<ColoredDeviceItem> getAllRouters() {
        return DeviceItems.getAllItems().filter(item -> item.method_8389() instanceof ColoredDeviceItem).map(item -> (ColoredDeviceItem)item.method_8389()).filter(item -> item.getDeviceType() == ModDeviceTypes.ROUTER).toList();
    }

    public static void register() {
        REGISTER.load();
    }
}

