/*
 * Decompiled with CFR 0.152.
 */
package dev.ultreon.devices.item;

import dev.ultreon.devices.DeviceConfig;
import dev.ultreon.devices.block.entity.NetworkDeviceBlockEntity;
import dev.ultreon.devices.block.entity.RouterBlockEntity;
import dev.ultreon.devices.core.network.Router;
import dev.ultreon.devices.init.CableData;
import dev.ultreon.devices.init.DeviceDataComponents;
import dev.ultreon.devices.util.KeyboardHelper;
import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1271;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1838;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_3222;
import net.minecraft.class_9331;
import net.minecraft.class_9334;
import org.jetbrains.annotations.NotNull;

public class EthernetCableItem
extends class_1792 {
    public EthernetCableItem() {
        super(new class_1792.class_1793().method_7889(1));
    }

    private static double getDistance(class_2338 source, class_2338 target) {
        return Math.sqrt(source.method_10268((double)target.method_10263() + 0.5, (double)target.method_10264() + 0.5, (double)target.method_10260() + 0.5));
    }

    @NotNull
    public class_1269 method_7884(class_1838 context) {
        class_1937 level = context.method_8045();
        class_1657 player = context.method_8036();
        class_2338 pos = context.method_8037();
        class_1268 hand = context.method_20287();
        if (!level.field_9236 && player != null) {
            class_1799 heldItem = player.method_5998(hand);
            class_2586 blockEntity = level.method_8321(pos);
            if (blockEntity instanceof RouterBlockEntity) {
                RouterBlockEntity routerBE = (RouterBlockEntity)blockEntity;
                if (!heldItem.method_57826((class_9331)DeviceDataComponents.CABLE_DATA.get())) {
                    this.sendGameInfoMessage(player, "message.devices.invalid_cable");
                    return class_1269.field_5812;
                }
                Router router = routerBE.getRouter();
                CableData tag = (CableData)heldItem.method_57824((class_9331)DeviceDataComponents.CABLE_DATA.get());
                assert (tag != null);
                class_2338 devicePos = tag.pos();
                class_2586 tileEntity1 = level.method_8321(devicePos);
                if (tileEntity1 instanceof NetworkDeviceBlockEntity) {
                    NetworkDeviceBlockEntity networkDeviceBlockEntity = (NetworkDeviceBlockEntity)tileEntity1;
                    if (!router.isDeviceRegistered(networkDeviceBlockEntity)) {
                        if (router.addDevice(networkDeviceBlockEntity)) {
                            networkDeviceBlockEntity.connect(router);
                            heldItem.method_7934(1);
                            if (EthernetCableItem.getDistance(tileEntity1.method_11016(), routerBE.method_11016()) > (double)((Integer)DeviceConfig.SIGNAL_RANGE.get()).intValue()) {
                                this.sendGameInfoMessage(player, "message.devices.successful_registered");
                            } else {
                                this.sendGameInfoMessage(player, "message.devices.successful_connection");
                            }
                        } else {
                            this.sendGameInfoMessage(player, "message.devices.router_max_devices");
                        }
                    } else {
                        this.sendGameInfoMessage(player, "message.devices.device_already_connected");
                    }
                } else if (router.addDevice(tag.id(), tag.name())) {
                    heldItem.method_7934(1);
                    this.sendGameInfoMessage(player, "message.devices.successful_registered");
                } else {
                    this.sendGameInfoMessage(player, "message.devices.router_max_devices");
                }
                return class_1269.field_5812;
            }
            if (blockEntity instanceof NetworkDeviceBlockEntity) {
                NetworkDeviceBlockEntity networkDeviceBlockEntity = (NetworkDeviceBlockEntity)blockEntity;
                CableData cableData = new CableData(networkDeviceBlockEntity.method_11016(), networkDeviceBlockEntity.getId(), networkDeviceBlockEntity.getCustomName());
                heldItem.method_57379((class_9331)DeviceDataComponents.CABLE_DATA.get(), (Object)cableData);
                this.sendGameInfoMessage(player, "message.devices.select_router");
                return class_1269.field_5812;
            }
        }
        return class_1269.field_5812;
    }

    private void sendGameInfoMessage(class_1657 player, String message) {
        if (player instanceof class_3222) {
            class_3222 serverPlayer = (class_3222)player;
            serverPlayer.method_43496((class_2561)class_2561.method_43471((String)message));
        }
    }

    @NotNull
    public class_1271<class_1799> method_7836(class_1937 level, @NotNull class_1657 player, @NotNull class_1268 usedHand) {
        if (!level.field_9236) {
            class_1799 heldItem = player.method_5998(usedHand);
            if (player.method_18276()) {
                heldItem.method_57381(class_9334.field_49631);
                heldItem.method_57381((class_9331)DeviceDataComponents.CABLE_DATA.get());
                return new class_1271(class_1269.field_5812, (Object)heldItem);
            }
        }
        return super.method_7836(level, player, usedHand);
    }

    public void method_7851(class_1799 stack, @NotNull class_1792.class_9635 context, @NotNull List<class_2561> tooltipComponents, @NotNull class_1836 tooltipFlag) {
        if (stack.method_57826((class_9331)DeviceDataComponents.CABLE_DATA.get())) {
            CableData tag = (CableData)stack.method_57824((class_9331)DeviceDataComponents.CABLE_DATA.get());
            if (tag != null) {
                tooltipComponents.add((class_2561)class_2561.method_43470((String)(String.valueOf(class_124.field_1080) + "Connected to: " + String.valueOf(class_124.field_1070) + tag.name())));
                tooltipComponents.add((class_2561)class_2561.method_43470((String)(String.valueOf(class_124.field_1080) + "Located at: " + String.valueOf(class_124.field_1070) + tag.pos().method_10263() + ", " + tag.pos().method_10264() + ", " + tag.pos().method_10260())));
                if (tooltipFlag.method_8035()) {
                    tooltipComponents.add((class_2561)class_2561.method_43473());
                    tooltipComponents.add((class_2561)class_2561.method_43470((String)(class_124.field_1061.toString() + String.valueOf(class_124.field_1067) + "ID: " + String.valueOf(class_124.field_1070) + String.valueOf(tag.id()))));
                    tooltipComponents.add((class_2561)class_2561.method_43470((String)(class_124.field_1061.toString() + String.valueOf(class_124.field_1067) + "Device: " + String.valueOf(class_124.field_1070) + tag.name())));
                    class_2338 devicePos = tag.pos();
                    String text = class_124.field_1061.toString() + String.valueOf(class_124.field_1067) + "X: " + String.valueOf(class_124.field_1070) + devicePos.method_10263() + " " + String.valueOf(class_124.field_1061) + String.valueOf(class_124.field_1067) + "Y: " + String.valueOf(class_124.field_1070) + devicePos.method_10264() + " " + String.valueOf(class_124.field_1061) + String.valueOf(class_124.field_1067) + "Z: " + String.valueOf(class_124.field_1070) + devicePos.method_10260();
                    tooltipComponents.add((class_2561)class_2561.method_43470((String)text));
                }
            }
        } else {
            if (!KeyboardHelper.isShiftDown()) {
                tooltipComponents.add((class_2561)class_2561.method_43470((String)(String.valueOf(class_124.field_1080) + "Use this cable to connect")));
                tooltipComponents.add((class_2561)class_2561.method_43470((String)(String.valueOf(class_124.field_1080) + "a device to a router.")));
                tooltipComponents.add((class_2561)class_2561.method_43470((String)(String.valueOf(class_124.field_1054) + "Hold SHIFT for How-To")));
                return;
            }
            tooltipComponents.add((class_2561)class_2561.method_43470((String)(String.valueOf(class_124.field_1080) + "Start by right clicking a")));
            tooltipComponents.add((class_2561)class_2561.method_43470((String)(String.valueOf(class_124.field_1080) + "device with this cable")));
            tooltipComponents.add((class_2561)class_2561.method_43470((String)(String.valueOf(class_124.field_1080) + "then right click the ")));
            tooltipComponents.add((class_2561)class_2561.method_43470((String)(String.valueOf(class_124.field_1080) + "router you want to")));
            tooltipComponents.add((class_2561)class_2561.method_43470((String)(String.valueOf(class_124.field_1080) + "connect this device to.")));
        }
        super.method_7851(stack, context, tooltipComponents, tooltipFlag);
    }

    public boolean method_7886(class_1799 stack) {
        return stack.method_57826((class_9331)DeviceDataComponents.CABLE_DATA.get());
    }

    @NotNull
    public class_2561 method_7864(class_1799 stack) {
        if (stack.method_57826((class_9331)DeviceDataComponents.CABLE_DATA.get())) {
            return super.method_7848().method_27661().method_27695(new class_124[]{class_124.field_1075, class_124.field_1067});
        }
        return super.method_7864(stack);
    }
}

