/*
 * Decompiled with CFR 0.152.
 */
package dev.ultreon.devices.network.task;

import com.google.common.collect.ImmutableList;
import dev.ultreon.devices.Devices;
import dev.ultreon.devices.api.ApplicationManager;
import dev.ultreon.devices.object.AppInfo;
import dev.ultreon.mods.xinexlib.network.Networker;
import dev.ultreon.mods.xinexlib.network.packet.PacketToClient;
import java.util.List;
import net.minecraft.class_2960;
import net.minecraft.class_9129;

public class SyncApplicationPacket
implements PacketToClient<SyncApplicationPacket> {
    private final List<AppInfo> allowedApps;

    public SyncApplicationPacket(class_9129 buf) {
        int size = buf.readInt();
        ImmutableList.Builder builder = ImmutableList.builder();
        for (int i = 0; i < size; ++i) {
            String appId = buf.method_19772();
            AppInfo info = ApplicationManager.getApplication(class_2960.method_12829((String)appId));
            if (info != null) {
                builder.add((Object)info);
                continue;
            }
            Devices.LOGGER.error("Missing application '{}'", (Object)appId);
        }
        this.allowedApps = builder.build();
    }

    public SyncApplicationPacket(List<AppInfo> allowedApps) {
        this.allowedApps = allowedApps;
    }

    public void write(class_9129 buf) {
        buf.method_53002(this.allowedApps.size());
        for (AppInfo appInfo : this.allowedApps) {
            buf.method_10812(appInfo.getId());
        }
    }

    public void handle(Networker networker) {
        Devices.setAllowedApps(this.allowedApps);
    }
}

