/*
 * Decompiled with CFR 0.152.
 */
package dev.ultreon.devices.object;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import com.google.gson.reflect.TypeToken;
import dev.ultreon.devices.Devices;
import dev.ultreon.devices.Reference;
import dev.ultreon.devices.core.ComputerScreen;
import dev.ultreon.devices.core.Permission;
import dev.ultreon.devices.core.PermissionManager;
import dev.ultreon.devices.debug.DebugLog;
import java.awt.Color;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.class_1074;
import net.minecraft.class_2487;
import net.minecraft.class_2960;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

public class AppInfo {
    public static final Comparator<AppInfo> SORT_NAME = Comparator.comparing(AppInfo::getName);
    private final transient class_2960 APP_ID;
    private final transient boolean systemApp;
    private static final TintProvider DEFAULT_TINT_PROVIDER = new TintProvider(){

        @Override
        public int getTintColor(AppInfo info, int o) {
            return switch (o) {
                case 1 -> ComputerScreen.getSystem().getSettings().getColorScheme().getBackgroundColor();
                case 2 -> ComputerScreen.getSystem().getSettings().getColorScheme().getBackgroundSecondaryColor();
                default -> new Color(255, 255, 255).getRGB();
            };
        }

        @Override
        public class_2487 toTag() {
            return new class_2487();
        }
    };
    private Set<String> extensions = new HashSet<String>();
    private TintProvider tintProvider = DEFAULT_TINT_PROVIDER;
    private String name;
    private String[] authors;
    private String[] contributors;
    private String description;
    private String version;
    private Icon icon;
    private String[] screenshots;
    private Support support;

    public static TintProvider getDefaultTintProvider() {
        return DEFAULT_TINT_PROVIDER;
    }

    public TintProvider getTintProvider() {
        return this.tintProvider;
    }

    public AppInfo(class_2960 identifier, boolean isSystemApp) {
        this.APP_ID = identifier;
        this.systemApp = isSystemApp;
    }

    public AppInfo(class_2960 identifier, boolean isSystemApp, TintProvider tintProvider) {
        this.APP_ID = identifier;
        this.systemApp = isSystemApp;
        this.tintProvider = tintProvider;
    }

    public void registerExtension(String extension) {
        if (PermissionManager.hasPermission(Permission.APP_EXTENSION_REGISTER)) {
            throw new IllegalArgumentException("No permission to register extension " + extension);
        }
        this.extensions.add(extension);
    }

    public class_2960 getId() {
        return this.APP_ID;
    }

    public String getFormattedId() {
        return this.getId().toString();
    }

    public String getName() {
        return this.name;
    }

    public String[] getAuthors() {
        return this.authors;
    }

    public String[] getContributors() {
        return this.contributors;
    }

    @Deprecated
    public String getAuthor() {
        StringBuilder a = new StringBuilder();
        if (this.authors == null) {
            return "<unknown>";
        }
        Arrays.stream(this.authors).forEach(str -> a.append((String)str).append(", "));
        if (a.length() >= 2) {
            a.deleteCharAt(a.length() - 1);
            a.deleteCharAt(a.length() - 1);
        }
        return a.toString();
    }

    public String getDescription() {
        return this.description;
    }

    public String getVersion() {
        return this.version;
    }

    public Icon getIcon() {
        return this.icon;
    }

    public int getTint(int i) {
        return this.tintProvider != null ? this.tintProvider.getTintColor(this, i) : DEFAULT_TINT_PROVIDER.getTintColor(this, i);
    }

    public void setTintProvider(TintProvider tintProvider) {
        this.tintProvider = tintProvider;
    }

    public Collection<String> getExtensions() {
        return this.extensions;
    }

    public String[] getScreenshots() {
        return this.screenshots;
    }

    public Support getSupport() {
        return this.support;
    }

    public boolean isSystemApp() {
        return this.systemApp;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AppInfo)) {
            return false;
        }
        AppInfo info = (AppInfo)obj;
        return this == info || this.getFormattedId().equals(info.getFormattedId());
    }

    public void reload(@NotNull class_3300 resourceManager) {
        this.resetInfo();
        class_2960 resourceLocation = class_2960.method_60655((String)this.APP_ID.method_12836(), (String)("apps/" + this.APP_ID.method_12832() + ".json"));
        DebugLog.log("Reloading app info for '" + String.valueOf(this.APP_ID) + "'");
        class_3298 resource = resourceManager.method_14486(resourceLocation).orElse(null);
        if (resource == null) {
            throw new NoSuchElementException("Missing app info json for '" + String.valueOf(this.APP_ID) + "'");
        }
        try (BufferedReader reader = resource.method_43039();){
            JsonElement obj = JsonParser.parseReader((Reader)reader);
            GsonBuilder builder = new GsonBuilder();
            builder.registerTypeAdapter(AppInfo.class, (Object)new Deserializer(this));
            Gson gson = builder.create();
            gson.fromJson(obj, AppInfo.class);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void resetInfo() {
        this.name = null;
        this.authors = null;
        this.contributors = null;
        this.description = null;
        this.version = null;
        this.icon = null;
        this.screenshots = null;
        this.support = null;
    }

    @ApiStatus.Experimental
    public static interface TintProvider {
        public int getTintColor(AppInfo var1, int var2);

        public class_2487 toTag();
    }

    public static class Icon {
        Glyph base;
        Glyph overlay0;
        Glyph overlay1;

        private Icon(AppInfo info) {
            this.base = Glyph.of(class_2960.method_60655((String)info.APP_ID.method_12836(), (String)("textures/app/icon/base/" + info.APP_ID.method_12832() + ".png")));
            this.base.type = 0;
            this.overlay0 = Glyph.of(class_2960.method_60655((String)info.APP_ID.method_12836(), (String)("textures/app/icon/overlay0/" + info.APP_ID.method_12832() + ".png")));
            this.overlay0.type = 1;
            this.overlay1 = Glyph.of(class_2960.method_60655((String)info.APP_ID.method_12836(), (String)("textures/app/icon/overlay1/" + info.APP_ID.method_12832() + ".png")));
            this.overlay1.type = 2;
        }

        @Deprecated
        private Icon() {
        }

        public Glyph getBase() {
            return this.base;
        }

        public Glyph getOverlay0() {
            return this.overlay0;
        }

        public Glyph getOverlay1() {
            return this.overlay1;
        }

        public static class Glyph {
            private class_2960 resourceLocation;
            private int u = -1;
            private int v = -1;
            private int type;

            private Glyph(class_2960 res) {
                this.resourceLocation = res;
            }

            private static Glyph of(class_2960 res) {
                return new Glyph(res);
            }

            public class_2960 getResourceLocation() {
                return this.resourceLocation;
            }

            public void setU(int u) {
                this.u = u;
            }

            public void setV(int v) {
                this.v = v;
            }

            public int getU() {
                return this.u;
            }

            public int getV() {
                return this.v;
            }

            public int getType() {
                return this.type;
            }
        }
    }

    private static class Support {
        private String paypal;
        private String patreon;
        public String kofi;
        private String twitter;
        private String youtube;

        private Support() {
        }
    }

    public static class Deserializer
    implements JsonDeserializer<AppInfo> {
        private static final Pattern LANG = Pattern.compile("\\$\\{[a-z]+}");
        private final AppInfo info;

        public Deserializer(AppInfo info) {
            this.info = info;
        }

        public AppInfo deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) {
            try {
                switch (this.getSchemaVersion(json)) {
                    case 0: {
                        this.deserializeSchemaVersion0(json, context);
                        break;
                    }
                    case 1: {
                        this.deserializeSchemaVersion1(json, context);
                        break;
                    }
                    case 2: {
                        this.deserializeSchemaVersion2(json, context);
                        break;
                    }
                    case 3: {
                        this.deserializeSchemaVersion3(json, context);
                        break;
                    }
                    default: {
                        throw new RuntimeException("Schema " + this.getSchemaVersion(json) + " is not implemented in " + Reference.VERSION + "!");
                    }
                }
            }
            catch (JsonParseException e) {
                Devices.LOGGER.error("Malformed app info json for '{}'", (Object)this.info.getFormattedId());
            }
            return this.info;
        }

        private void deserializeSchemaVersion0(JsonElement json, JsonDeserializationContext context) throws JsonParseException {
            this.info.name = this.convertToLocal(json.getAsJsonObject().get("name").getAsString());
            this.info.authors = new String[]{this.convertToLocal(json.getAsJsonObject().get("author").getAsString())};
            this.info.description = this.convertToLocal(json.getAsJsonObject().get("description").getAsString());
            this.info.version = json.getAsJsonObject().get("version").getAsString();
            if (json.getAsJsonObject().has("screenshots") && json.getAsJsonObject().get("screenshots").isJsonArray()) {
                this.info.screenshots = (String[])context.deserialize(json.getAsJsonObject().get("screenshots"), new TypeToken<String[]>(this){}.getType());
            }
            if (json.getAsJsonObject().has("icon") && json.getAsJsonObject().get("icon").isJsonPrimitive()) {
                this.info.icon = new Icon();
                this.info.icon.base = Icon.Glyph.of(class_2960.method_60654((String)json.getAsJsonObject().get("icon").getAsString()));
                this.info.icon.base.type = 0;
                this.info.icon.overlay0 = Icon.Glyph.of(class_2960.method_60655((String)this.info.APP_ID.method_12836(), (String)"textures/app/icon/overlay0/empty.png"));
                this.info.icon.overlay0.type = 1;
                this.info.icon.overlay1 = Icon.Glyph.of(class_2960.method_60655((String)this.info.APP_ID.method_12836(), (String)"textures/app/icon/overlay1/empty.png"));
                this.info.icon.overlay1.type = 2;
            }
            if (json.getAsJsonObject().has("support") && !json.getAsJsonObject().get("support").getAsJsonObject().isEmpty()) {
                JsonObject supportObj = json.getAsJsonObject().get("support").getAsJsonObject();
                Support support = new Support();
                if (supportObj.has("paypal")) {
                    support.paypal = supportObj.get("paypal").getAsString();
                }
                if (supportObj.has("patreon")) {
                    support.patreon = supportObj.get("patreon").getAsString();
                }
                if (supportObj.has("twitter")) {
                    support.twitter = supportObj.get("twitter").getAsString();
                }
                if (supportObj.has("youtube")) {
                    support.youtube = supportObj.get("youtube").getAsString();
                }
                this.info.support = support;
            }
        }

        private void deserializeSchemaVersion1(JsonElement json, JsonDeserializationContext context) throws JsonParseException {
            this.info.name = this.convertToLocal(json.getAsJsonObject().get("name").getAsString());
            this.info.authors = new String[]{this.convertToLocal(json.getAsJsonObject().get("author").getAsString())};
            this.info.description = this.convertToLocal(json.getAsJsonObject().get("description").getAsString());
            this.info.version = json.getAsJsonObject().get("version").getAsString();
            if (json.getAsJsonObject().has("screenshots") && json.getAsJsonObject().get("screenshots").isJsonArray()) {
                this.info.screenshots = (String[])context.deserialize(json.getAsJsonObject().get("screenshots"), new TypeToken<String[]>(this){}.getType());
            }
            if (json.getAsJsonObject().has("icon") && json.getAsJsonObject().get("icon").isJsonPrimitive()) {
                Devices.LOGGER.warn("{} uses removed \"icon\"! Please advise {} to fix the icon!", (Object)this.info.name, (Object)this.info.authors[0]);
            }
            if (json.getAsJsonObject().has("support") && !json.getAsJsonObject().get("support").getAsJsonObject().isEmpty()) {
                JsonObject supportObj = json.getAsJsonObject().get("support").getAsJsonObject();
                Support support = new Support();
                if (supportObj.has("paypal")) {
                    support.paypal = supportObj.get("paypal").getAsString();
                }
                if (supportObj.has("patreon")) {
                    support.patreon = supportObj.get("patreon").getAsString();
                }
                if (supportObj.has("twitter")) {
                    support.twitter = supportObj.get("twitter").getAsString();
                }
                if (supportObj.has("youtube")) {
                    support.youtube = supportObj.get("youtube").getAsString();
                }
                this.info.support = support;
            }
            this.info.icon = new Icon(this.info);
        }

        private void deserializeSchemaVersion2(JsonElement json, JsonDeserializationContext context) throws JsonParseException {
            this.info.name = this.convertToLocal(json.getAsJsonObject().get("name").getAsString());
            ArrayList authors = new ArrayList();
            if (json.getAsJsonObject().has("authors") && json.getAsJsonObject().get("authors").isJsonArray()) {
                json.getAsJsonObject().get("authors").getAsJsonArray().forEach(e -> authors.add(this.convertToLocal(e.getAsString())));
                this.info.authors = authors.toArray(new String[0]);
            }
            ArrayList contributors = new ArrayList();
            if (json.getAsJsonObject().has("contributors") && json.getAsJsonObject().get("contributors").isJsonArray()) {
                json.getAsJsonObject().get("contributors").getAsJsonArray().forEach(e -> contributors.add(this.convertToLocal(e.getAsString())));
            }
            boolean d = false;
            if (this.info.authors.length == 0) {
                this.info.authors = new String[]{"the application's developer"};
                d = true;
            }
            if (json.getAsJsonObject().has("author") && json.getAsJsonObject().get("author").isJsonPrimitive() && this.info.authors == null) {
                this.info.authors = new String[]{this.convertToLocal(json.getAsJsonObject().get("author").getAsString())};
                Devices.LOGGER.warn("{} uses deprecated \"author\"!, Please advise {} to replace \"author\": \"{}\" with the \"authors\": [] format", new Object[]{this.info.name, this.info.authors[0], this.info.authors[0]});
            }
            this.info.description = this.convertToLocal(json.getAsJsonObject().get("description").getAsString());
            this.info.version = json.getAsJsonObject().get("version").getAsString();
            if (json.getAsJsonObject().has("screenshots") && json.getAsJsonObject().get("screenshots").isJsonArray()) {
                this.info.screenshots = (String[])context.deserialize(json.getAsJsonObject().get("screenshots"), new TypeToken<String[]>(this){}.getType());
            }
            if (json.getAsJsonObject().has("icon") && json.getAsJsonObject().get("icon").isJsonPrimitive()) {
                Devices.LOGGER.warn("{} uses removed \"icon\"! Please advise {} to fix the icon!", (Object)this.info.name, (Object)this.info.authors[0]);
            }
            if (d) {
                this.info.authors = new String[0];
            }
            ArrayList<String> l = new ArrayList<String>(List.of(this.info.authors));
            l.addAll(contributors);
            this.info.contributors = l.toArray(new String[0]);
            if (json.getAsJsonObject().has("support") && !json.getAsJsonObject().get("support").getAsJsonObject().isEmpty()) {
                JsonObject supportObj = json.getAsJsonObject().get("support").getAsJsonObject();
                Support support = new Support();
                if (supportObj.has("paypal")) {
                    support.paypal = supportObj.get("paypal").getAsString();
                }
                if (supportObj.has("patreon")) {
                    support.patreon = supportObj.get("patreon").getAsString();
                }
                if (supportObj.has("twitter")) {
                    support.twitter = supportObj.get("twitter").getAsString();
                }
                if (supportObj.has("youtube")) {
                    support.youtube = supportObj.get("youtube").getAsString();
                }
                this.info.support = support;
            }
            this.info.icon = new Icon(this.info);
        }

        private void deserializeSchemaVersion3(JsonElement json, JsonDeserializationContext context) throws JsonParseException {
            this.info.name = this.convertToLocal(json.getAsJsonObject().get("name").getAsString());
            ArrayList authors = new ArrayList();
            if (json.getAsJsonObject().has("authors") && json.getAsJsonObject().get("authors").isJsonArray()) {
                json.getAsJsonObject().get("authors").getAsJsonArray().forEach(e -> authors.add(this.convertToLocal(e.getAsString())));
                this.info.authors = authors.toArray(new String[0]);
            }
            ArrayList contributors = new ArrayList();
            if (json.getAsJsonObject().has("contributors") && json.getAsJsonObject().get("contributors").isJsonArray()) {
                json.getAsJsonObject().get("contributors").getAsJsonArray().forEach(e -> contributors.add(this.convertToLocal(e.getAsString())));
            }
            if (this.info.authors.length == 0) {
                throw new RuntimeException("No authors defined!");
            }
            this.info.description = this.convertToLocal(json.getAsJsonObject().get("description").getAsString());
            this.info.version = json.getAsJsonObject().get("version").getAsString();
            if (json.getAsJsonObject().has("screenshots") && json.getAsJsonObject().get("screenshots").isJsonArray()) {
                this.info.screenshots = (String[])context.deserialize(json.getAsJsonObject().get("screenshots"), new TypeToken<String[]>(this){}.getType());
            }
            ArrayList<String> l = new ArrayList<String>(List.of(this.info.authors));
            l.addAll(contributors);
            this.info.contributors = l.toArray(new String[0]);
            if (json.getAsJsonObject().has("support") && !json.getAsJsonObject().get("support").getAsJsonObject().isEmpty()) {
                JsonObject supportObj = json.getAsJsonObject().get("support").getAsJsonObject();
                Support support = new Support();
                if (supportObj.has("paypal")) {
                    support.paypal = supportObj.get("paypal").getAsString();
                }
                if (supportObj.has("patreon")) {
                    support.patreon = supportObj.get("patreon").getAsString();
                }
                if (supportObj.has("ko-fi")) {
                    support.kofi = supportObj.get("ko-fi").getAsString();
                }
                if (supportObj.has("twitter")) {
                    support.twitter = supportObj.get("twitter").getAsString();
                }
                if (supportObj.has("youtube")) {
                    support.youtube = supportObj.get("youtube").getAsString();
                }
                this.info.support = support;
            }
            this.info.icon = new Icon(this.info);
        }

        private int getSchemaVersion(JsonElement json) {
            boolean isPrimitive;
            boolean has = json.getAsJsonObject().has("schemaVersion");
            boolean bl = isPrimitive = has && json.getAsJsonObject().get("schemaVersion").isJsonPrimitive();
            if (has && isPrimitive) {
                return json.getAsJsonObject().get("schemaVersion").getAsInt();
            }
            return 2;
        }

        private String convertToLocal(String s) {
            Matcher m = LANG.matcher(s);
            while (m.find()) {
                String found = m.group();
                s = s.replace(found, class_1074.method_4662((String)("app." + this.info.getFormattedId() + "." + found.substring(2, found.length() - 1)), (Object[])new Object[0]));
            }
            return s;
        }
    }
}

