/*
 * Decompiled with CFR 0.152.
 */
package dev.ultreon.devices.object;

import dev.ultreon.devices.api.app.Component;
import dev.ultreon.devices.api.app.Layout;
import dev.ultreon.devices.core.ComputerScreen;
import dev.ultreon.devices.object.Picture;
import dev.ultreon.devices.object.Tool;
import dev.ultreon.devices.object.tools.ToolBucket;
import dev.ultreon.devices.object.tools.ToolEraser;
import dev.ultreon.devices.object.tools.ToolEyeDropper;
import dev.ultreon.devices.object.tools.ToolPencil;
import dev.ultreon.devices.util.GuiHelper;
import java.awt.Color;
import net.minecraft.class_310;
import net.minecraft.class_332;

public class Canvas
extends Component {
    public static final Tool PENCIL = new ToolPencil();
    public static final Tool BUCKET = new ToolBucket();
    public static final Tool ERASER = new ToolEraser();
    public static final Tool EYE_DROPPER = new ToolEyeDropper();
    public int[] pixels;
    public Picture picture;
    private Tool currentTool;
    private int red;
    private int green;
    private int blue;
    private int currentColor = Color.BLACK.getRGB();
    private boolean drawing = false;
    private boolean showGrid = false;
    private boolean existingImage = false;
    private final int gridColor = new Color(200, 200, 200, 150).getRGB();

    public Canvas(int left, int top) {
        super(left, top);
        this.currentTool = PENCIL;
    }

    public void createPicture(String name, String author, Picture.Size size) {
        this.existingImage = false;
        this.picture = new Picture(name, author, size);
        this.pixels = new int[this.picture.size.width * this.picture.size.height];
    }

    public void setPicture(Picture picture) {
        this.existingImage = true;
        this.picture = picture;
        this.pixels = picture.copyPixels();
    }

    @Override
    public void init(Layout layout) {
    }

    @Override
    public void render(class_332 graphics, ComputerScreen computerScreen, class_310 mc, int x, int y, int mouseX, int mouseY, boolean windowActive, float partialTicks) {
        graphics.method_25294(this.xPosition, this.yPosition, this.xPosition + this.picture.getWidth() * this.picture.getPixelWidth() + 2, this.yPosition + this.picture.getHeight() * this.picture.getPixelHeight() + 2, Color.DARK_GRAY.getRGB());
        graphics.method_25294(this.xPosition + 1, this.yPosition + 1, this.xPosition + this.picture.getWidth() * this.picture.getPixelWidth() + 1, this.yPosition + this.picture.getHeight() * this.picture.getPixelHeight() + 1, Color.WHITE.getRGB());
        for (int i = 0; i < this.picture.getHeight(); ++i) {
            for (int j = 0; j < this.picture.getWidth(); ++j) {
                int pixelX = this.xPosition + j * this.picture.getPixelWidth() + 1;
                int pixelY = this.yPosition + i * this.picture.getPixelHeight() + 1;
                graphics.method_25294(pixelX, pixelY, pixelX + this.picture.getPixelWidth(), pixelY + this.picture.getPixelHeight(), this.pixels[j + i * this.picture.size.width]);
                if (!this.showGrid) continue;
                graphics.method_25294(pixelX, pixelY, pixelX + this.picture.getPixelWidth(), pixelY + 1, this.gridColor);
                graphics.method_25294(pixelX, pixelY, pixelX + 1, pixelY + this.picture.getPixelHeight(), this.gridColor);
            }
        }
    }

    @Override
    public void handleMouseClick(int mouseX, int mouseY, int mouseButton) {
        int endY;
        int startX = this.xPosition + 1;
        int startY = this.yPosition + 1;
        int endX = startX + this.picture.getWidth() * this.picture.getPixelWidth() - 1;
        if (GuiHelper.isMouseInside(mouseX, mouseY, startX, startY, endX, endY = startY + this.picture.getHeight() * this.picture.getPixelHeight() - 1)) {
            this.drawing = true;
            int pixelX = (mouseX - startX) / this.picture.getPixelWidth();
            int pixelY = (mouseY - startY) / this.picture.getPixelHeight();
            this.currentTool.handleClick(this, pixelX, pixelY);
        }
    }

    @Override
    public void handleMouseRelease(int mouseX, int mouseY, int mouseButton) {
        int endY;
        this.drawing = false;
        int startX = this.xPosition + 1;
        int startY = this.yPosition + 1;
        int endX = startX + this.picture.getWidth() * this.picture.getPixelWidth() - 1;
        if (GuiHelper.isMouseInside(mouseX, mouseY, startX, startY, endX, endY = startY + this.picture.getHeight() * this.picture.getPixelHeight() - 1)) {
            int pixelX = (mouseX - startX) / this.picture.getPixelWidth();
            int pixelY = (mouseY - startY) / this.picture.getPixelHeight();
            this.currentTool.handleRelease(this, pixelX, pixelY);
        }
    }

    @Override
    public void handleMouseDrag(int mouseX, int mouseY, int mouseButton) {
        int endY;
        int startX = this.xPosition + 1;
        int startY = this.yPosition + 1;
        int endX = startX + this.picture.getWidth() * this.picture.getPixelWidth() - 1;
        if (GuiHelper.isMouseInside(mouseX, mouseY, startX, startY, endX, endY = startY + this.picture.getHeight() * this.picture.getPixelHeight() - 1)) {
            int pixelX = (mouseX - startX) / this.picture.getPixelWidth();
            int pixelY = (mouseY - startY) / this.picture.getPixelHeight();
            this.currentTool.handleDrag(this, pixelX, pixelY);
        }
    }

    public int[] getPixels() {
        return this.pixels;
    }

    public int getPixel(int x, int y) {
        return this.pixels[x + y * this.picture.size.width];
    }

    public void setPixel(int x, int y, int color) {
        this.pixels[x + y * this.picture.size.width] = color;
    }

    public boolean isExistingImage() {
        return this.existingImage;
    }

    public void setColor(Color color) {
        this.currentColor = color.getRGB();
    }

    public void setColor(int color) {
        this.currentColor = color;
    }

    public void setRed(float red) {
        this.red = (int)(255.0 * Math.min(1.0, (double)red));
        this.compileColor();
    }

    public void setGreen(float green) {
        this.green = (int)(255.0 * Math.min(1.0, (double)green));
        this.compileColor();
    }

    public void setBlue(float blue) {
        this.blue = (int)(255.0 * Math.min(1.0, (double)blue));
        this.compileColor();
    }

    public void compileColor() {
        this.currentColor = 0xFF000000 | (this.red & 0xFF) << 16 | (this.green & 0xFF) << 8 | (this.blue & 0xFF) << 0;
    }

    public int getCurrentColor() {
        return this.currentColor;
    }

    public void setCurrentTool(Tool currentTool) {
        this.currentTool = currentTool;
    }

    public void setShowGrid(boolean showGrid) {
        this.showGrid = showGrid;
    }

    public int[] copyPixels() {
        int[] copiedPixels = new int[this.pixels.length];
        for (int i = 0; i < this.pixels.length; ++i) {
            copiedPixels[i] = this.pixels[i];
        }
        return copiedPixels;
    }

    public void clear() {
        if (this.pixels != null) {
            for (int i = 0; i < this.pixels.length; ++i) {
                this.pixels[i] = 0;
            }
        }
    }
}

