/*
 * Decompiled with CFR 0.152.
 */
package dev.ultreon.devices.object;

import com.mojang.blaze3d.systems.RenderSystem;
import dev.ultreon.devices.core.ComputerScreen;
import dev.ultreon.devices.object.Game;
import dev.ultreon.devices.object.tiles.Tile;
import dev.ultreon.devices.util.KeyboardHelper;
import dev.ultreon.devices.util.Vec2d;
import java.util.Objects;
import net.minecraft.class_1690;
import net.minecraft.class_1937;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_5617;
import net.minecraft.class_8685;
import net.minecraft.class_881;
import net.minecraft.class_898;
import org.joml.Quaternionf;

public class Player {
    private static final class_2960 boatTextures = class_2960.method_60654((String)"textures/entity/boat/oak.png");
    boolean canMove = false;
    private final Game game;
    private double posX;
    private double posY;
    private double posXPrev;
    private double posYPrev;
    private double speed;
    private int rotation;
    private int rotationPrev;
    private final Vec2d direction;
    private final Vec2d velocity;
    private final class_881 boatModel;
    private class_1690 boat;

    public static class_5617.class_5618 createEntityRendererContext() {
        class_310 mc = class_310.method_1551();
        class_898 erd = mc.method_1561();
        return new class_5617.class_5618(erd, mc.method_1480(), mc.method_1541(), erd.method_43336(), mc.method_1478(), mc.method_31974(), mc.field_1772);
    }

    public Player(Game game) {
        this.game = game;
        this.direction = new Vec2d(0.0, 0.0);
        this.velocity = new Vec2d(0.0, 0.0);
        this.boatModel = new class_881(Player.createEntityRendererContext(), false);
        assert (class_310.method_1551().field_1724 != null);
        boolean slim = class_310.method_1551().field_1724.method_52814().comp_1629().equals((Object)class_8685.class_7920.field_41122);
        if (!ComputerScreen.isWorldLess()) {
            this.boat = new class_1690((class_1937)Objects.requireNonNull(class_310.method_1551().field_1687), 0.0, 0.0, 0.0);
        }
    }

    public void tick() {
        Tile tile;
        this.rotationPrev = this.rotation;
        this.posXPrev = this.posX;
        this.posYPrev = this.posY;
        if (KeyboardHelper.isKeyDown(265)) {
            this.speed += 0.5;
            if (this.speed >= 3.0) {
                this.speed = 3.0;
            }
            if (KeyboardHelper.isKeyDown(42) || KeyboardHelper.isKeyDown(54)) {
                this.speed += 2.0;
            }
        } else {
            this.speed /= 1.1;
        }
        if (KeyboardHelper.isKeyDown(263)) {
            this.rotation -= 8;
        }
        if (KeyboardHelper.isKeyDown(262)) {
            this.rotation += 8;
        }
        if ((tile = this.game.getTile(Game.Layer.BACKGROUND, this.getPosX(), this.getPosY())) != null && tile.isSlow()) {
            this.speed *= 0.1;
        }
        this.direction.x = Math.cos(Math.toRadians(this.rotation));
        this.direction.y = Math.sin(Math.toRadians(this.rotation));
        this.direction.normalise();
        this.velocity.x = this.direction.x * this.speed;
        this.velocity.y = this.direction.y * this.speed;
        this.canMove = this.canMove();
        if (this.canMove) {
            this.posX += this.velocity.x;
            this.posY += this.velocity.y;
        } else {
            this.speed = 0.0;
        }
    }

    public boolean canMove() {
        if (this.posX + this.velocity.x <= 0.0) {
            return false;
        }
        if (this.posY + this.velocity.y <= 0.0) {
            return false;
        }
        if (this.posX + this.velocity.x >= (double)(this.game.mapWidth * 8)) {
            return false;
        }
        return !(this.posY + this.velocity.y >= (double)(this.game.mapHeight * 6));
    }

    public int getPosX() {
        return (int)(this.posX / 8.0);
    }

    public int getPosY() {
        return (int)(this.posY / 6.0);
    }

    public void render(class_332 graphics, int x, int y, float partialTicks) {
        float scale = 0.5f;
        double px = (double)x + this.posXPrev + (this.posX - this.posXPrev) * (double)partialTicks;
        double py = (double)y + this.posYPrev + (this.posY - this.posYPrev) * (double)partialTicks;
        float rot = (float)this.rotationPrev + (float)(this.rotation - this.rotationPrev) * partialTicks;
        graphics.method_51448().method_22903();
        graphics.method_51448().method_46416((float)px, (float)py, 3.0f);
        graphics.method_51448().method_22905(-scale, -scale, -scale);
        graphics.method_51448().method_22907(new Quaternionf(180.0f, 0.0f, 0.0f, 1.0f));
        graphics.method_51448().method_22907(new Quaternionf(90.0f, 1.0f, 0.0f, 0.0f));
        graphics.method_51448().method_22904(0.0, -3.0, 0.0);
        graphics.method_51448().method_22907(new Quaternionf(-90.0f, 1.0f, 0.0f, 0.0f));
        graphics.method_51448().method_22907(new Quaternionf(rot, 0.0f, 1.0f, 0.0f));
        RenderSystem.setShaderTexture((int)0, (class_2960)boatTextures);
        class_898 entityRender = class_310.method_1551().method_1561();
        graphics.method_51448().method_22909();
        graphics.method_51448().method_22903();
        graphics.method_51448().method_46416((float)px, (float)py, 3.0f);
        graphics.method_51448().method_22905(-scale, scale, scale);
        graphics.method_51448().method_22907(new Quaternionf(90.0f, 1.0f, 0.0f, 0.0f));
        graphics.method_51448().method_46416(0.0f, 5.0f, 0.0f);
        graphics.method_51448().method_22907(new Quaternionf(90.0f, 1.0f, 0.0f, 0.0f));
        graphics.method_51448().method_22907(new Quaternionf(180.0f, 0.0f, 0.0f, 1.0f));
        graphics.method_51448().method_22907(new Quaternionf(rot - 90.0f, 0.0f, 1.0f, 0.0f));
        graphics.method_51448().method_46416(0.0f, -12.0f, 5.0f);
        graphics.method_51448().method_22909();
    }
}

