/*
 * Decompiled with CFR 0.152.
 */
package dev.ultreon.devices.programs.gitweb;

import dev.ultreon.devices.api.app.Application;
import dev.ultreon.devices.api.app.Icons;
import dev.ultreon.devices.api.app.Layout;
import dev.ultreon.devices.api.app.System;
import dev.ultreon.devices.api.app.SystemAccessor;
import dev.ultreon.devices.api.app.component.Button;
import dev.ultreon.devices.api.app.component.Spinner;
import dev.ultreon.devices.api.app.component.TextField;
import dev.ultreon.devices.core.ComputerScreen;
import dev.ultreon.devices.programs.gitweb.component.GitWebFrame;
import dev.ultreon.devices.programs.gitweb.layout.TextLayout;
import dev.ultreon.devices.programs.system.SettingsApp;
import dev.ultreon.devices.programs.system.layout.StandardLayout;
import dev.ultreon.devices.util.DataHandler;
import java.awt.Color;
import java.util.Optional;
import net.minecraft.class_2487;
import org.jetbrains.annotations.Nullable;

public class GitWebApp
extends Application
implements SystemAccessor,
DataHandler {
    private Layout layoutBrowser;
    private Layout layoutPref;
    private Button btnSearch;
    private Button btnHome;
    private Button btnSettings;
    private GitWebFrame webFrame;
    private TextField textFieldAddress;
    private Spinner spinnerLoading;
    private TextLayout scrollable;
    private System system;

    public Optional<System> getSystem() {
        return Optional.ofNullable(this.system);
    }

    @Override
    public void init(@Nullable class_2487 intent) {
        this.layoutBrowser = new StandardLayout(null, 362, 240, this, null);
        this.layoutBrowser.setBackground((graphics, mc, x, y, width, height, mouseX, mouseY, windowActive) -> {
            Color color = new Color(ComputerScreen.getSystem().getSettings().getColorScheme().getBackgroundColor(), true);
            graphics.method_25294(x, y + 21, x + width, y + 164, color.getRGB());
        });
        this.layoutPref = new SettingsApp.Menu("Preferences");
        this.setUpPreferences();
        this.textFieldAddress = new TextField(2, 2, 304);
        this.textFieldAddress.setPlaceholder("Enter Address");
        this.textFieldAddress.setKeyListener(c -> {
            if (c == '\r') {
                this.webFrame.loadWebsite(this.getAddress());
                return false;
            }
            return true;
        });
        this.layoutBrowser.addComponent(this.textFieldAddress);
        this.spinnerLoading = new Spinner(291, 4);
        this.spinnerLoading.setVisible(false);
        this.layoutBrowser.addComponent(this.spinnerLoading);
        this.btnSearch = new Button(308, 2, 16, 16, Icons.ARROW_RIGHT);
        this.btnSearch.setToolTip("Refresh", "Loads the entered address.");
        this.btnSearch.setClickListener((mouseX, mouseY, mouseButton) -> this.webFrame.loadWebsite(this.getAddress()));
        this.layoutBrowser.addComponent(this.btnSearch);
        this.btnHome = new Button(326, 2, 16, 16, Icons.HOME);
        this.btnHome.setToolTip("Home", "Loads page set in settings.");
        this.btnHome.setClickListener((mouseX, mouseY, mouseButton) -> this.webFrame.loadWebsite("welcome.official"));
        this.layoutBrowser.addComponent(this.btnHome);
        this.btnSettings = new Button(344, 2, 16, 16, Icons.WRENCH);
        this.btnSettings.setToolTip("Settings", "Change your preferences.");
        this.btnSettings.setClickListener((mouseX, mouseY, mouseButton) -> this.setCurrentLayout(this.layoutPref));
        this.layoutBrowser.addComponent(this.btnSettings);
        this.webFrame = new GitWebFrame(this, 0, 21, 362, 143);
        this.webFrame.loadWebsite("welcome.official");
        this.webFrame.setLoadingCallback((s, success) -> {
            this.spinnerLoading.setVisible(true);
            this.textFieldAddress.setFocused(false);
            this.textFieldAddress.setEditable(false);
            this.textFieldAddress.setText((String)s);
            this.btnSearch.setEnabled(false);
        });
        this.webFrame.setLoadedCallback((s, success) -> {
            this.spinnerLoading.setVisible(false);
            this.textFieldAddress.setEditable(true);
            this.btnSearch.setEnabled(true);
        });
        this.layoutBrowser.addComponent(this.webFrame);
        this.setCurrentLayout(this.layoutBrowser);
    }

    private void setUpPreferences() {
        Button backBtn = new Button(2, 2, Icons.ARROW_LEFT);
        backBtn.setVisible(true);
        backBtn.setClickListener((mouseX, mouseY, mouseButton) -> {
            if (mouseButton == 0) {
                this.setCurrentLayout(this.layoutBrowser);
            }
        });
        this.layoutPref.addComponent(backBtn);
    }

    @Override
    @Deprecated
    public void handleKeyTyped(char character, int code) {
        super.handleKeyTyped(character, code);
    }

    private String getAddress() {
        return this.textFieldAddress.getText().replace("\\s+", "");
    }

    @Override
    public void load(class_2487 tag) {
    }

    @Override
    public void save(class_2487 tag) {
    }

    @Override
    public void sendSystem(System system) {
        this.system = system;
    }
}

