/*
 * Decompiled with CFR 0.152.
 */
package dev.ultreon.devices.programs.gitweb.module;

import com.mojang.brigadier.exceptions.CommandSyntaxException;
import dev.ultreon.devices.api.app.Layout;
import dev.ultreon.devices.api.app.component.Label;
import dev.ultreon.devices.api.app.component.Text;
import dev.ultreon.devices.programs.gitweb.component.GitWebFrame;
import dev.ultreon.devices.programs.gitweb.component.container.ContainerBox;
import dev.ultreon.devices.programs.gitweb.module.Module;
import java.util.Map;
import net.minecraft.class_124;
import net.minecraft.class_1799;
import net.minecraft.class_2520;
import net.minecraft.class_2522;
import net.minecraft.class_310;
import net.minecraft.class_638;
import net.minecraft.class_7225;

public abstract class ContainerModule
extends Module {
    @Override
    public String[] getRequiredData() {
        return new String[0];
    }

    @Override
    public String[] getOptionalData() {
        return new String[]{"title", "desc"};
    }

    @Override
    public final int calculateHeight(Map<String, String> data, int width) {
        int height = this.getHeight() + 22;
        if (data.containsKey("desc")) {
            String desc = GitWebFrame.parseFormatting(data.get("desc"));
            Text text = new Text(desc, 0, data.containsKey("title") ? 12 : 5, width - 128 - 5);
            text.setPadding(5);
            height += Math.max(0, text.getHeight() + text.top - height);
        }
        return height;
    }

    @Override
    public final void generate(GitWebFrame frame, Layout layout, int width, Map<String, String> data) {
        int craftingX = (width - 128) / 2;
        int craftingY = 5;
        if (data.containsKey("title") || data.containsKey("desc")) {
            String s;
            if (data.containsKey("title")) {
                s = GitWebFrame.parseFormatting(data.get("title"));
                Label label = new Label(String.valueOf(class_124.field_1067) + s, 5, 5);
                layout.addComponent(label);
            }
            if (data.containsKey("desc")) {
                s = GitWebFrame.parseFormatting(data.get("desc"));
                Text text = new Text(s, 0, data.containsKey("title") ? 12 : 5, width - 128 - 5);
                text.setPadding(5);
                layout.addComponent(text);
            }
            craftingX = width - 128 - 5;
        }
        ContainerBox box = this.createContainer(data);
        box.left = craftingX;
        box.top = craftingY;
        layout.addComponent(box);
    }

    public abstract int getHeight();

    public abstract ContainerBox createContainer(Map<String, String> var1);

    protected static class_1799 getItem(Map<String, String> data, String key) {
        if (data.containsKey(key)) {
            try {
                class_638 level = class_310.method_1551().field_1687;
                if (level != null) {
                    return class_1799.method_57360((class_7225.class_7874)level.method_30349(), (class_2520)class_2522.method_10718((String)data.get(key))).orElse(class_1799.field_8037);
                }
            }
            catch (CommandSyntaxException e) {
                return class_1799.field_8037;
            }
        }
        return class_1799.field_8037;
    }
}

