/*
 * Decompiled with CFR 0.152.
 */
package dev.ultreon.devices.programs.system;

import dev.ultreon.devices.api.app.Application;
import dev.ultreon.devices.api.app.Layout;
import dev.ultreon.devices.api.app.component.Button;
import dev.ultreon.devices.api.app.component.Text;
import dev.ultreon.devices.api.app.listener.ClickListener;
import dev.ultreon.devices.object.AppInfo;
import dev.ultreon.devices.programs.system.SystemApp;
import java.awt.Color;
import net.minecraft.class_2487;
import net.minecraft.class_310;
import org.jetbrains.annotations.Nullable;

public final class DiagnosticsApp
extends SystemApp {
    private String messageText;
    private final AppInfo appInfo;
    private final Application application;
    private ClickListener positiveListener;

    public DiagnosticsApp() {
        this.messageText = "Unknown app crashed";
        this.appInfo = null;
        this.application = null;
    }

    public DiagnosticsApp(AppInfo appInfo) {
        Object messageText;
        this.appInfo = appInfo;
        try {
            messageText = "App Crashed:\n" + appInfo.getName();
        }
        catch (Exception e) {
            messageText = "App Crashed";
        }
        this.messageText = messageText;
        this.application = null;
    }

    public DiagnosticsApp(Application app) {
        String messageText;
        AppInfo appInfo;
        try {
            appInfo = app.getInfo();
        }
        catch (Exception e) {
            appInfo = null;
        }
        this.appInfo = appInfo;
        try {
            messageText = appInfo == null ? "App Crashed" : "App Crashed:\n" + this.appInfo.getName();
        }
        catch (Exception e) {
            messageText = "App Crashed";
        }
        this.messageText = messageText;
        this.application = app;
    }

    @Override
    public void init(@Nullable class_2487 intent) {
        String applicationName = null;
        if (intent != null) {
            applicationName = intent.method_10558("applicationName");
        }
        this.messageText = applicationName == null ? "App Crashed" : "App Crashed:\n" + applicationName;
        Layout layoutMain = new Layout(150, 40);
        int textHeight = class_310.method_1551().field_1772.method_1713(this.messageText, this.getWidth() - 10);
        layoutMain.height += textHeight;
        layoutMain.setBackground((graphics, mc, x, y, width, height, mouseX, mouseY, windowActive) -> graphics.method_25294(x, y, x + width, y + height, Color.LIGHT_GRAY.getRGB()));
        Text message = new Text(this.messageText, 5, 5, this.getWidth() - 10);
        this.addComponent(message);
        Button buttonPositive = new Button(this.getWidth() - 41, this.getHeight() - 20, "Close");
        buttonPositive.setSize(36, 16);
        buttonPositive.setClickListener((mouseX, mouseY, mouseButton) -> {
            if (this.positiveListener != null) {
                this.positiveListener.onClick(mouseX, mouseY, mouseButton);
            }
            this.getWindow().close();
        });
        this.addComponent(buttonPositive);
    }

    @Override
    public void load(class_2487 tag) {
    }

    @Override
    public void save(class_2487 tag) {
    }

    public void setPositiveListener(ClickListener positiveListener) {
        this.positiveListener = positiveListener;
    }

    public AppInfo getAppInfo() {
        return this.appInfo;
    }

    public Application getApplication() {
        return this.application;
    }
}

