/*
 * Decompiled with CFR 0.152.
 */
package dev.ultreon.devices.programs.system;

import com.google.common.base.CaseFormat;
import dev.ultreon.devices.Devices;
import dev.ultreon.devices.Reference;
import dev.ultreon.devices.api.ApplicationManager;
import dev.ultreon.devices.api.app.Dialog;
import dev.ultreon.devices.api.app.Icons;
import dev.ultreon.devices.api.app.Layout;
import dev.ultreon.devices.api.app.ScrollableLayout;
import dev.ultreon.devices.api.app.component.Button;
import dev.ultreon.devices.api.app.component.ComboBox;
import dev.ultreon.devices.api.app.component.Image;
import dev.ultreon.devices.api.app.component.ItemList;
import dev.ultreon.devices.api.app.component.Text;
import dev.ultreon.devices.api.app.renderer.ItemRenderer;
import dev.ultreon.devices.api.app.renderer.ListItemRenderer;
import dev.ultreon.devices.api.utils.OnlineRequest;
import dev.ultreon.devices.core.ComputerScreen;
import dev.ultreon.devices.object.AppInfo;
import dev.ultreon.devices.object.TrayItem;
import dev.ultreon.devices.programs.system.PredefinedResolution;
import dev.ultreon.devices.programs.system.SystemApp;
import dev.ultreon.devices.programs.system.component.Palette;
import dev.ultreon.devices.programs.system.object.ColorScheme;
import dev.ultreon.devices.programs.system.object.ColorSchemePresetRegistry;
import dev.ultreon.devices.programs.system.object.Preset;
import java.awt.Color;
import java.nio.file.Path;
import java.text.MessageFormat;
import java.util.Objects;
import java.util.Stack;
import net.minecraft.class_2487;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SettingsApp
extends SystemApp {
    private Button backBtn;
    private Layout layoutMain;
    private Layout layoutGeneral;
    private Layout layoutPersonalise;
    private Layout layoutWallpaper;
    private Button prevWallpaperBtn;
    private Button nextWallpaperBtn;
    private Button urlWallpaperBtn;
    private Layout layoutColorScheme;
    private Layout layoutColorSchemes;
    private Button buttonColorSchemeApply;
    private final Stack<Layout> predecessor = new Stack();
    private ComboBox.List<PredefinedResolution> comboDisplayResolutions;

    private void resetColorSchemeClick(int mouseX, int mouseY, int mouseButton) {
        if (mouseButton == 0) {
            ComputerScreen.getSystem().getSettings().getColorScheme().resetDefault();
        }
    }

    @Override
    public void init(@Nullable class_2487 intent) {
        this.backBtn = new Button(2, 2, Icons.ARROW_LEFT);
        this.backBtn.setVisible(false);
        this.backBtn.setClickListener((mouseX, mouseY, mouseButton) -> {
            if (mouseButton == 0) {
                if (!this.predecessor.isEmpty()) {
                    this.setCurrentLayout(this.predecessor.pop());
                }
                if (this.predecessor.isEmpty()) {
                    this.backBtn.setVisible(false);
                }
            }
        });
        this.layoutMain = this.addMainLayout();
        this.setCurrentLayout(this.layoutMain);
    }

    private Menu addMainLayout() {
        Menu layoutMain = new Menu("Home");
        Button aboutButton = this.createAboutButton(layoutMain);
        layoutMain.addComponent(aboutButton);
        this.layoutPersonalise = this.createPersonaliseLayout();
        this.layoutColorSchemes = this.createColorSchemesLayout();
        this.layoutGeneral = this.createGeneralLayout();
        Button buttonColorScheme = new Button(5, 50, "Personalise", Icons.EDIT);
        buttonColorScheme.setSize(90, 20);
        buttonColorScheme.setToolTip("Personalise", "Change the wallpaper, UI colors, and more!");
        buttonColorScheme.setClickListener((mouseX, mouseY, mouseButton) -> {
            if (mouseButton == 0) {
                this.showMenu(this.layoutPersonalise);
            }
        });
        layoutMain.addComponent(buttonColorScheme);
        Button buttonColorSchemes = new Button(5, 76, "Themes", Icons.WRENCH);
        buttonColorSchemes.setSize(90, 20);
        buttonColorSchemes.setToolTip("Color Schemes", "Change the color scheme using presets or choose a custom one.");
        buttonColorSchemes.setClickListener((mouseX, mouseY, mouseButton) -> {
            if (mouseButton == 0) {
                this.showMenu(this.layoutColorSchemes);
            }
        });
        layoutMain.addComponent(buttonColorSchemes);
        Button buttonGeneral = new Button(5, 102, "Advanced", Icons.WRENCH);
        buttonGeneral.setSize(90, 20);
        buttonGeneral.setToolTip("General", "General settings.");
        buttonGeneral.setClickListener((mouseX, mouseY, mouseButton) -> {
            if (mouseButton == 0) {
                this.showMenu(this.layoutGeneral);
            }
        });
        layoutMain.addComponent(buttonGeneral);
        return layoutMain;
    }

    @NotNull
    private Button createAboutButton(Menu layoutMain) {
        Button aboutButton = new Button(5, 26, "About", Icons.INFO);
        aboutButton.setSize(90, 20);
        aboutButton.setClickListener((mouseX, mouseY, mouseButton) -> {
            Menu qq = new Menu("About");
            qq.addComponent(this.backBtn);
            ScrollableLayout l = new ScrollableLayout(layoutMain.width, layoutMain.height, 124);
            l.top = 26;
            l = ScrollableLayout.create(0, 26, layoutMain.width, 124, MessageFormat.format("Version: {0} ({1})\n", Reference.getVerInfo()[0], Reference.getVerInfo()[1]));
            qq.addComponent(l);
            this.showMenu(qq);
        });
        return aboutButton;
    }

    private Layout createGeneralLayout() {
        Menu layoutGeneral = new Menu("General");
        layoutGeneral.addComponent(this.backBtn);
        this.comboDisplayResolutions = new ComboBox.List<PredefinedResolution>(5, 50, PredefinedResolution.getResolutionList());
        this.comboDisplayResolutions.setListItemRenderer(new ListItemRenderer<PredefinedResolution>(this, 20){

            @Override
            public void render(class_332 graphics, PredefinedResolution resolution, class_310 mc, int x, int y, int width, int height, boolean selected) {
                graphics.method_25303(class_310.method_1551().field_1772, resolution.getDisplayName(), x + 5, y + 5, 0xFFFFFF);
            }
        });
        this.comboDisplayResolutions.setChangeListener((oldValue, newValue) -> {
            ComputerScreen computerScreen;
            if (newValue != null && (computerScreen = this.getLaptop()) != null) {
                computerScreen.setDisplayResolution((PredefinedResolution)newValue);
            }
        });
        layoutGeneral.addComponent(this.comboDisplayResolutions);
        return layoutGeneral;
    }

    private Layout createPersonaliseLayout() {
        Menu layoutPersonalise = new Menu("Personalise");
        layoutPersonalise.addComponent(this.backBtn);
        Button buttonWallpaper = new Button(5, 26, "Wallpaper", Icons.EDIT);
        buttonWallpaper.setSize(90, 20);
        buttonWallpaper.setToolTip("Wallpaper", "Manage the wallpaper.");
        buttonWallpaper.setClickListener(this::wallpaperClick);
        layoutPersonalise.addComponent(buttonWallpaper);
        this.layoutWallpaper = this.addWallpaperLayout();
        Button buttonReset = new Button(6, 100, "Reset Color Scheme");
        buttonReset.setClickListener(this::resetColorSchemeClick);
        buttonReset.top = layoutPersonalise.height - buttonReset.getHeight() - 5;
        layoutPersonalise.addComponent(buttonReset);
        layoutPersonalise.addComponent(this.backBtn);
        this.layoutColorScheme = this.createColorSchemeLayout();
        Button buttonColorScheme = new Button(6, 80, "Color scheme");
        buttonColorScheme.setClickListener(this::colorSchemeClick);
        buttonColorScheme.top = layoutPersonalise.height - buttonColorScheme.getHeight() - 25;
        layoutPersonalise.addComponent(buttonColorScheme);
        return layoutPersonalise;
    }

    private Layout createColorSchemesLayout() {
        Menu layoutColorSchemes = new Menu("Themes");
        layoutColorSchemes.addComponent(this.backBtn);
        Preset custom = new Preset(null, Devices.res("custom"));
        ItemList<Preset> list = new ItemList<Preset>(0, 21, layoutColorSchemes.width, layoutColorSchemes.height - 21);
        for (Preset colorScheme : ColorSchemePresetRegistry.getValues()) {
            list.addItem(colorScheme);
        }
        list.addItem(custom);
        list.setItemClickListener((preset, index, button) -> {
            if (preset == custom) {
                preset = null;
            }
            ComputerScreen.getSystem().getSettings().setPreset((Preset)preset);
        });
        list.setListItemRenderer(new ListItemRenderer<Preset>(this, 20){

            @Override
            public void render(class_332 graphics, Preset scheme, class_310 mc, int x, int y, int width, int height, boolean selected) {
                class_2960 key = ColorSchemePresetRegistry.getKey(scheme);
                if (key == null) {
                    key = Devices.res("custom");
                }
                graphics.method_25303(mc.field_1772, CaseFormat.LOWER_UNDERSCORE.to(CaseFormat.UPPER_CAMEL, key.method_12832()).replaceAll("[A-Z]", " $0").substring(1), x + 5, y + 5, Color.WHITE.getRGB());
            }
        });
        layoutColorSchemes.addComponent(list);
        return layoutColorSchemes;
    }

    private Layout createColorSchemeLayout() {
        Menu layoutColorScheme = new Menu("UI Colors");
        layoutColorScheme.addComponent(this.backBtn);
        ComboBox.Custom<Integer> comboBoxTextColor = this.createColorPicker(145, 26);
        comboBoxTextColor.setValue(ComputerScreen.getSystem().getSettings().getColorScheme().getTextColor());
        layoutColorScheme.addComponent(comboBoxTextColor);
        ComboBox.Custom<Integer> comboBoxTextSecondaryColor = this.createColorPicker(145, 44);
        comboBoxTextSecondaryColor.setValue(ComputerScreen.getSystem().getSettings().getColorScheme().getTextSecondaryColor());
        layoutColorScheme.addComponent(comboBoxTextSecondaryColor);
        ComboBox.Custom<Integer> comboBoxHeaderColor = this.createColorPicker(145, 62);
        comboBoxHeaderColor.setValue(ComputerScreen.getSystem().getSettings().getColorScheme().getHeaderColor());
        layoutColorScheme.addComponent(comboBoxHeaderColor);
        ComboBox.Custom<Integer> comboBoxBackgroundColor = this.createColorPicker(145, 80);
        comboBoxBackgroundColor.setValue(ComputerScreen.getSystem().getSettings().getColorScheme().getBackgroundColor());
        layoutColorScheme.addComponent(comboBoxBackgroundColor);
        ComboBox.Custom<Integer> comboBoxBackgroundSecondaryColor = this.createColorPicker(145, 98);
        comboBoxBackgroundSecondaryColor.setValue(ComputerScreen.getSystem().getSettings().getColorScheme().getBackgroundSecondaryColor());
        layoutColorScheme.addComponent(comboBoxBackgroundSecondaryColor);
        ComboBox.Custom<Integer> comboBoxItemBackgroundColor = this.createColorPicker(145, 116);
        comboBoxItemBackgroundColor.setValue(ComputerScreen.getSystem().getSettings().getColorScheme().getItemBackgroundColor());
        layoutColorScheme.addComponent(comboBoxItemBackgroundColor);
        ComboBox.Custom<Integer> comboBoxItemHighlightColor = this.createColorPicker(145, 134);
        comboBoxItemHighlightColor.setValue(ComputerScreen.getSystem().getSettings().getColorScheme().getItemHighlightColor());
        layoutColorScheme.addComponent(comboBoxItemHighlightColor);
        this.buttonColorSchemeApply = new Button(5, 79, Icons.CHECK);
        this.buttonColorSchemeApply.setEnabled(false);
        this.buttonColorSchemeApply.setToolTip("Apply", "Set these colors as the new color scheme");
        this.buttonColorSchemeApply.setClickListener((mouseX, mouseY, mouseButton) -> {
            if (mouseButton == 0) {
                ColorScheme colorScheme = ComputerScreen.getSystem().getSettings().getColorScheme();
                colorScheme.setTextColor((Integer)comboBoxTextColor.getValue());
                colorScheme.setTextSecondaryColor((Integer)comboBoxTextSecondaryColor.getValue());
                colorScheme.setHeaderColor((Integer)comboBoxHeaderColor.getValue());
                colorScheme.setBackgroundColor((Integer)comboBoxBackgroundColor.getValue());
                colorScheme.setBackgroundSecondaryColor((Integer)comboBoxBackgroundSecondaryColor.getValue());
                colorScheme.setItemBackgroundColor((Integer)comboBoxItemBackgroundColor.getValue());
                colorScheme.setItemHighlightColor((Integer)comboBoxItemHighlightColor.getValue());
                this.buttonColorSchemeApply.setEnabled(false);
            }
        });
        layoutColorScheme.addComponent(this.buttonColorSchemeApply);
        return layoutColorScheme;
    }

    private Layout addWallpaperLayout() {
        Menu wallpaperLayout = new Menu("Wallpaper");
        Image image = new Image(6, 29, 128, 99);
        image.setBorderThickness(1);
        image.setBorderVisible(true);
        image.setImage(Objects.requireNonNull(this.getLaptop()).getCurrentWallpaper());
        wallpaperLayout.addComponent(image);
        this.prevWallpaperBtn = new Button(135, 27, Icons.ARROW_LEFT);
        this.prevWallpaperBtn.setSize(25, 20);
        this.prevWallpaperBtn.setClickListener((mouseX, mouseY, mouseButton) -> {
            if (mouseButton != 0) {
                return;
            }
            ComputerScreen computerScreen = this.getLaptop();
            if (computerScreen != null) {
                computerScreen.prevWallpaper();
                image.setImage(this.getLaptop().getCurrentWallpaper());
            }
        });
        this.prevWallpaperBtn.setEnabled(this.getLaptop().getCurrentWallpaper().isBuiltIn());
        wallpaperLayout.addComponent(this.prevWallpaperBtn);
        this.nextWallpaperBtn = new Button(165, 27, Icons.ARROW_RIGHT);
        this.nextWallpaperBtn.setSize(25, 20);
        this.nextWallpaperBtn.setClickListener((mouseX, mouseY, mouseButton) -> {
            if (mouseButton != 0) {
                return;
            }
            ComputerScreen computerScreen = this.getLaptop();
            if (computerScreen != null) {
                computerScreen.nextWallpaper();
                image.setImage(this.getLaptop().getCurrentWallpaper());
            }
        });
        this.nextWallpaperBtn.setEnabled(this.getLaptop().getCurrentWallpaper().isBuiltIn());
        wallpaperLayout.addComponent(this.nextWallpaperBtn);
        Button resetWallpaperBtn = new Button(6, 100, "Reset Wallpaper");
        resetWallpaperBtn.setClickListener((mouseX, mouseY, mouseButton) -> {
            if (mouseButton == 0) {
                this.getLaptop().setWallpaper(0);
                image.setImage(this.getLaptop().getCurrentWallpaper());
                this.prevWallpaperBtn.setEnabled(this.getLaptop().getCurrentWallpaper().isBuiltIn());
                this.nextWallpaperBtn.setEnabled(this.getLaptop().getCurrentWallpaper().isBuiltIn());
            }
        });
        resetWallpaperBtn.top = wallpaperLayout.height - resetWallpaperBtn.getHeight() - 5;
        wallpaperLayout.addComponent(resetWallpaperBtn);
        wallpaperLayout.addComponent(this.backBtn);
        this.urlWallpaperBtn = new Button(135, 52, "Load", Icons.EARTH);
        this.urlWallpaperBtn.setSize(55, 20);
        this.urlWallpaperBtn.setClickListener((mouseX, mouseY, mouseButton) -> {
            if (mouseButton != 0) {
                return;
            }
            Dialog.Input dialog = new Dialog.Input("Enter the URL of the image");
            dialog.setResponseHandler((success, string) -> {
                if (this.getLaptop() != null) {
                    OnlineRequest.getInstance().make((String)string, (success2, data) -> {
                        dialog.close();
                        if (!success2) {
                            Dialog.Message message = new Dialog.Message("Failed to download image: " + new String(data));
                            this.openDialog(message);
                            return;
                        }
                        Path path = Path.of("/Home/Library/Backgrounds/loaded.png", new String[0]);
                        ComputerScreen.getOrLoadMainDrive((drive, success3) -> {
                            if (!success3) {
                                Dialog.Message message = new Dialog.Message("Failed to load main drive");
                                this.openDialog(message);
                                return;
                            }
                            if (drive != null) {
                                drive.createDirectories(path.getParent(), response -> {
                                    if (!response.success()) {
                                        Dialog.Message message = new Dialog.Message("Failed to create backgrounds directory: " + response.message());
                                        this.openDialog(message);
                                        return;
                                    }
                                    ComputerScreen.getMainDrive().createFile(path.getParent(), path.getFileName().toString(), true, response2 -> {
                                        if (!response2.success()) {
                                            Dialog.Message message = new Dialog.Message("Failed to create background file: " + response2.message());
                                            this.openDialog(message);
                                            return;
                                        }
                                        ComputerScreen.getMainDrive().write(path, data, response3 -> {
                                            if (!response3.success()) {
                                                Dialog.Message message = new Dialog.Message("Failed to write background file: " + response3.message());
                                                this.openDialog(message);
                                                return;
                                            }
                                            this.getLaptop().setWallpaper(path);
                                            image.setImage(this.getLaptop().getCurrentWallpaper());
                                            this.prevWallpaperBtn.setEnabled(this.getLaptop().getCurrentWallpaper().isBuiltIn());
                                            this.nextWallpaperBtn.setEnabled(this.getLaptop().getCurrentWallpaper().isBuiltIn());
                                        });
                                    });
                                });
                            } else {
                                Dialog.Message message = new Dialog.Message("Main drive unavailable");
                                this.openDialog(message);
                            }
                        });
                    }, true);
                }
                return success;
            });
            this.openDialog(dialog);
        });
        wallpaperLayout.addComponent(this.urlWallpaperBtn);
        Text wallpaperText = new Text("Wallpaper", image.left + 3, image.top + 3, image.componentWidth - 6);
        wallpaperText.setShadow(true);
        wallpaperText.setTextColor(new Color(this.getLaptop().getSettings().getColorScheme().getTextColor()));
        wallpaperLayout.addComponent(wallpaperText);
        return wallpaperLayout;
    }

    @Override
    public void load(class_2487 tag) {
    }

    @Override
    public void save(class_2487 tag) {
    }

    private void showMenu(Layout layout) {
        this.predecessor.push(this.getCurrentLayout());
        this.backBtn.setVisible(true);
        this.setCurrentLayout(layout);
    }

    @Override
    public void onClose() {
        super.onClose();
        this.predecessor.clear();
    }

    private void wallpaperClick(int mouseX, int mouseY, int mouseButton) {
        if (mouseButton == 0) {
            this.showMenu(this.layoutWallpaper);
        }
    }

    private void colorSchemeClick(int mouseX, int mouseY, int mouseButton) {
        if (mouseButton == 0) {
            this.showMenu(this.layoutColorScheme);
        }
    }

    @Deprecated
    private void showAllAppsClick(int mouseX, int mouseY, int mouseButton) {
    }

    public ComboBox.Custom<Integer> createColorPicker(int left, int top) {
        ComboBox.Custom<Integer> colorPicker = new ComboBox.Custom<Integer>(left, top, 50, 100, 100);
        colorPicker.setValue(Color.RED.getRGB());
        colorPicker.setItemRenderer(new ItemRenderer<Integer>(this){

            @Override
            public void render(class_332 graphics, Integer integer, class_310 mc, int x, int y, int width, int height) {
                if (integer != null) {
                    graphics.method_25294(x, y, x + width, y + height, integer.intValue());
                }
            }
        });
        colorPicker.setChangeListener((oldValue, newValue) -> {
            if (this.buttonColorSchemeApply != null) {
                this.buttonColorSchemeApply.setEnabled(true);
            }
        });
        Palette palette = new Palette(5, 5, colorPicker);
        Layout.Context layout = colorPicker.getLayout();
        layout.addComponent(palette);
        return colorPicker;
    }

    public static class Menu
    extends Layout {
        private final String title;

        public Menu(String title) {
            super(200, 150);
            this.title = title;
        }

        @Override
        public void render(class_332 graphics, ComputerScreen computerScreen, class_310 mc, int x, int y, int mouseX, int mouseY, boolean windowActive, float partialTicks) {
            Color color = new Color(ComputerScreen.getSystem().getSettings().getColorScheme().getHeaderColor());
            graphics.method_25294(x, y, x + this.width, y + 20, color.getRGB());
            graphics.method_25294(x, y + 20, x + this.width, y + 21, color.darker().getRGB());
            graphics.method_25303(mc.field_1772, this.title, x + 22, y + 6, Color.WHITE.getRGB());
            super.render(graphics, computerScreen, mc, x, y, mouseX, mouseY, windowActive, partialTicks);
        }
    }

    public static class SettingsTrayItem
    extends TrayItem {
        public SettingsTrayItem() {
            super(Icons.WRENCH, Devices.res("settings"));
        }

        @Override
        public void handleClick(int mouseX, int mouseY, int mouseButton) {
            AppInfo info = ApplicationManager.getApplication(Devices.res("settings"));
            if (info != null) {
                ComputerScreen.getSystem().launchApp(info);
            }
        }
    }
}

