/*
 * Decompiled with CFR 0.152.
 */
package dev.ultreon.devices.programs.system.component;

import com.mojang.blaze3d.systems.RenderSystem;
import dev.ultreon.devices.api.ApplicationManager;
import dev.ultreon.devices.api.app.Application;
import dev.ultreon.devices.api.app.Component;
import dev.ultreon.devices.api.app.Dialog;
import dev.ultreon.devices.api.app.Icons;
import dev.ultreon.devices.api.app.Layout;
import dev.ultreon.devices.api.app.component.Button;
import dev.ultreon.devices.api.app.component.ComboBox;
import dev.ultreon.devices.api.app.component.ItemList;
import dev.ultreon.devices.api.app.component.Label;
import dev.ultreon.devices.api.app.component.Spinner;
import dev.ultreon.devices.api.app.listener.ItemClickListener;
import dev.ultreon.devices.api.app.renderer.ListItemRenderer;
import dev.ultreon.devices.api.io.Drive;
import dev.ultreon.devices.api.io.DriveRoot;
import dev.ultreon.devices.api.task.Callback;
import dev.ultreon.devices.api.task.TaskManager;
import dev.ultreon.devices.api.utils.RenderUtil;
import dev.ultreon.devices.core.ComputerScreen;
import dev.ultreon.devices.core.Window;
import dev.ultreon.devices.core.Wrappable;
import dev.ultreon.devices.core.io.FileSystem;
import dev.ultreon.devices.core.io.task.TaskSetupFileBrowser;
import dev.ultreon.devices.object.AppInfo;
import dev.ultreon.devices.programs.system.SystemApp;
import dev.ultreon.devices.programs.system.component.FileInfo;
import java.awt.Color;
import java.nio.file.Path;
import java.util.List;
import java.util.Stack;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.class_124;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import org.jetbrains.annotations.Nullable;

public class FileBrowser
extends Component {
    private static final class_2960 ASSETS = class_2960.method_60654((String)"devices:textures/gui/file_browser.png");
    private static final Color HEADER_BACKGROUND = Color.decode("0x535861");
    private static final Color ITEM_BACKGROUND = Color.decode("0x9E9E9E");
    private static final Color ITEM_SELECTED = Color.decode("0x757575");
    private static final Color PROTECTED_FILE = new Color(155, 237, 242);
    private static final ListItemRenderer<FileInfo> ITEM_RENDERER = new ListItemRenderer<FileInfo>(18){

        @Override
        public void render(class_332 graphics, FileInfo file, class_310 mc, int x, int y, int width, int height, boolean selected) {
            Color bgColor = new Color(ComputerScreen.getSystem().getSettings().getColorScheme().getBackgroundColor(), true);
            graphics.method_25294(x, y, x + width, y + height, selected ? bgColor.brighter().brighter().getRGB() : bgColor.brighter().getRGB());
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.setShaderTexture((int)0, (class_2960)ASSETS);
            if (file.isFolder()) {
                RenderUtil.drawRectWithTexture(ASSETS, graphics, x + 3, y + 2, 0.0f, 0.0f, 14, 14, 14.0f, 14.0f);
            } else {
                if (file.getOpeningApp() == null) {
                    return;
                }
                AppInfo info = ApplicationManager.getApplication(class_2960.method_12829((String)file.getOpeningApp()));
                RenderUtil.drawApplicationIcon(graphics, info, x + 3, y + 2);
            }
            graphics.method_25303(class_310.method_1551().field_1772, file.getName(), x + 22, y + 5, file.protectedFile() ? PROTECTED_FILE.getRGB() : ComputerScreen.getSystem().getSettings().getColorScheme().getTextColor());
        }
    };
    public static boolean refreshList = false;
    private final Wrappable wrappable;
    private final Mode mode;
    private Layout layoutMain;
    private ItemList<FileInfo> fileList;
    private Button btnPreviousFolder;
    private Button btnNewFolder;
    private Button btnRename;
    private Button btnCopy;
    private Button btnCut;
    private Button btnPaste;
    private Button btnDelete;
    private ComboBox.List<Drive> comboBoxDrive;
    private Label labelPath;
    private Layout layoutLoading;
    private Spinner spinnerLoading;
    private final Stack<FileInfo> history = new Stack();
    private FileInfo currentPath;
    private FileInfo clipboardFile;
    private FileInfo clipboardDir;
    private Path initialFolder = FileSystem.DIR_ROOT;
    private boolean loadedStructure = false;
    private long lastClick = 0L;
    private ItemClickListener<FileInfo> itemClickListener;
    private Predicate<FileInfo> filter;
    private final Path path = Path.of("/", new String[0]);

    public FileBrowser(int left, int top, Wrappable wrappable, Mode mode) {
        super(left, top);
        this.wrappable = wrappable;
        this.mode = mode;
    }

    @Override
    public void init(Layout layout) {
        this.layoutMain = new Layout(this.mode.getWidth(), this.mode.getHeight());
        this.layoutMain.setBackground((graphics, mc, x, y, width, height, mouseX, mouseY, windowActive) -> {
            Color color = new Color(ComputerScreen.getSystem().getSettings().getColorScheme().getHeaderColor());
            graphics.method_25294(x, y, x + width, y + 20, color.getRGB());
            graphics.method_25294(x, y + 20, x + width, y + 21, color.darker().getRGB());
        });
        this.btnPreviousFolder = new Button(5, 2, Icons.ARROW_LEFT);
        this.btnPreviousFolder.setClickListener((mouseX, mouseY, mouseButton) -> {
            if (mouseButton == 0) {
                this.goToPreviousFolder();
            }
        });
        this.btnPreviousFolder.setToolTip("Previous Folder", "Go back to the previous folder");
        this.btnPreviousFolder.setEnabled(false);
        this.layoutMain.addComponent(this.btnPreviousFolder);
        int btnIndex = 0;
        this.btnNewFolder = new Button(5, 25, Icons.NEW_FOLDER);
        this.btnNewFolder.setClickListener((mouseX, mouseY, mouseButton) -> {
            if (mouseButton == 0) {
                this.createFolder();
            }
        });
        this.btnNewFolder.setEnabled(false);
        this.btnNewFolder.setToolTip("New Folder", "Creates a new folder in this directory");
        this.layoutMain.addComponent(this.btnNewFolder);
        this.btnRename = new Button(5, 25 + ++btnIndex * 20, Icons.RENAME);
        this.btnRename.setClickListener((mouseX, mouseY, mouseButton) -> {
            if (mouseButton == 0) {
                this.renameSelectedFile();
            }
        });
        this.btnRename.setToolTip("Rename", "Change the name of the selected file or folder");
        this.btnRename.setEnabled(false);
        this.layoutMain.addComponent(this.btnRename);
        if (this.mode == Mode.FULL) {
            this.btnCopy = new Button(5, 25 + ++btnIndex * 20, Icons.COPY);
            this.btnCopy.setClickListener((mouseX, mouseY, mouseButton) -> {
                if (mouseButton == 0) {
                    this.setClipboardFileToSelected();
                }
            });
            this.btnCopy.setToolTip("Copy", "Copies the selected file or folder");
            this.btnCopy.setEnabled(false);
            this.layoutMain.addComponent(this.btnCopy);
            this.btnCut = new Button(5, 25 + ++btnIndex * 20, Icons.CUT);
            this.btnCut.setClickListener((mouseX, mouseY, mouseButton) -> {
                if (mouseButton == 0) {
                    this.cutSelectedFile();
                }
            });
            this.btnCut.setToolTip("Cut", "Cuts the selected file or folder");
            this.btnCut.setEnabled(false);
            this.layoutMain.addComponent(this.btnCut);
            this.btnPaste = new Button(5, 25 + ++btnIndex * 20, Icons.CLIPBOARD);
            this.btnPaste.setClickListener((mouseX, mouseY, mouseButton) -> {
                if (mouseButton == 0) {
                    this.pasteClipboardFile();
                }
            });
            this.btnPaste.setToolTip("Paste", "Pastes the copied file into this directory");
            this.btnPaste.setEnabled(false);
            this.layoutMain.addComponent(this.btnPaste);
        }
        this.btnDelete = new Button(5, 25 + ++btnIndex * 20, Icons.TRASH);
        this.btnDelete.setClickListener((mouseX, mouseY, mouseButton) -> {
            if (mouseButton == 0) {
                this.deleteSelectedFile();
            }
        });
        this.btnDelete.setToolTip("Delete", "Deletes the selected file or folder");
        this.btnDelete.setEnabled(false);
        this.layoutMain.addComponent(this.btnDelete);
        this.fileList = new ItemList(this.mode.getOffset(), 25, 180, this.mode.getVisibleItems());
        this.fileList.setListItemRenderer(ITEM_RENDERER);
        this.fileList.sortBy(FileInfo.SORT_BY_NAME);
        this.fileList.setItemClickListener((E file, int index, int mouseButton) -> {
            if (mouseButton == 0) {
                this.btnRename.setEnabled(true);
                this.btnDelete.setEnabled(true);
                if (this.mode == Mode.FULL) {
                    this.btnCopy.setEnabled(true);
                    this.btnCut.setEnabled(true);
                }
                if (System.currentTimeMillis() - this.lastClick <= 200L) {
                    SystemApp systemApp;
                    ComputerScreen computerScreen;
                    Wrappable patt0$temp;
                    if (file.isFolder()) {
                        this.fileList.setSelectedIndex(-1);
                        this.openFolder((FileInfo)file, true, (folder, success) -> {
                            if (this.mode == Mode.FULL) {
                                this.btnRename.setEnabled(false);
                                this.btnCopy.setEnabled(false);
                                this.btnCut.setEnabled(false);
                                this.btnDelete.setEnabled(false);
                            }
                        });
                    } else if (this.mode == Mode.FULL && (patt0$temp = this.wrappable) instanceof SystemApp && (computerScreen = (systemApp = (SystemApp)patt0$temp).getLaptop()) != null) {
                        String openingApp = file.getOpeningApp();
                        if (openingApp == null) {
                            this.createErrorDialog("This file does not have an application associated with it.");
                            return;
                        }
                        Application targetApp = computerScreen.getApplication(openingApp);
                        if (targetApp == null) {
                            this.createErrorDialog("This file does not have an application associated with it.");
                            return;
                        }
                        if (!computerScreen.isApplicationInstalled(targetApp.getInfo())) {
                            this.createErrorDialog(targetApp.getInfo().getName() + " is not installed.");
                        }
                        if (computerScreen.isApplicationInstalled(targetApp.getInfo())) {
                            computerScreen.launchApp(targetApp.getInfo(), (FileInfo)file, launcherResponse -> {
                                if (launcherResponse.error() != null) {
                                    this.createErrorDialog(launcherResponse.error());
                                    return;
                                }
                                if (!launcherResponse.success()) {
                                    this.createErrorDialog(targetApp.getInfo().getName() + " was unable to open the file.");
                                    return;
                                }
                                computerScreen.sendApplicationToFront(targetApp.getInfo());
                            });
                        } else {
                            this.createErrorDialog("This file could not be open because the application '" + String.valueOf(class_124.field_1054) + targetApp.getInfo().getName() + String.valueOf(class_124.field_1070) + "' is not installed.");
                        }
                    }
                } else {
                    this.lastClick = System.currentTimeMillis();
                }
            }
            if (this.itemClickListener != null) {
                this.itemClickListener.onClick((FileInfo)file, index, mouseButton);
            }
        });
        this.layoutMain.addComponent(this.fileList);
        this.comboBoxDrive = new ComboBox.List<Drive>(26, 3, 44, 100, new Drive[0]);
        this.comboBoxDrive.setChangeListener((oldValue, newValue) -> this.openDrive((Drive)newValue));
        this.comboBoxDrive.setListItemRenderer(new ListItemRenderer<Drive>(12){

            @Override
            public void render(class_332 graphics, Drive drive, class_310 mc, int x, int y, int width, int height, boolean selected) {
                Color bgColor = new Color(FileBrowser.this.getColorScheme().getBackgroundColor(), true);
                graphics.method_25294(x, y, x + width, y + height, selected ? bgColor.brighter().brighter().getRGB() : bgColor.brighter().getRGB());
                RenderSystem.setShaderTexture((int)0, (class_2960)ASSETS);
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                RenderUtil.drawRectWithTexture(ASSETS, graphics, x + 2, y + 2, drive.getType().ordinal() * 8, 30.0f, 8, 8, 8.0f, 8.0f);
                Object text = drive.getName();
                if (mc.field_1772.method_1727((String)text) > 87) {
                    text = mc.field_1772.method_27523(drive.getName(), 78) + "...";
                }
                graphics.method_25303(mc.field_1772, (String)text, x + 13, y + 2, Color.WHITE.getRGB());
            }
        });
        this.layoutMain.addComponent(this.comboBoxDrive);
        this.labelPath = new Label("/", 72, 6);
        this.layoutMain.addComponent(this.labelPath);
        layout.addComponent(this.layoutMain);
        this.layoutLoading = new Layout(this.mode.getOffset(), 25, this.fileList.getWidth(), this.fileList.getHeight());
        this.layoutLoading.setBackground((graphics, mc, x, y, width, height, mouseX, mouseY, windowActive) -> graphics.method_25294(x, y, x + width, y + height, Window.COLOR_WINDOW_DARK));
        this.layoutLoading.setVisible(false);
        this.spinnerLoading = new Spinner((this.layoutLoading.width - 12) / 2, (this.layoutLoading.height - 12) / 2);
        this.layoutLoading.addComponent(this.spinnerLoading);
        layout.addComponent(this.layoutLoading);
        this.setLoading(true);
    }

    @Override
    public void handleLoad() {
        if (!this.loadedStructure) {
            this.setLoading(true);
            TaskSetupFileBrowser task = new TaskSetupFileBrowser(ComputerScreen.getPos(), ComputerScreen.getMainDrive() == null);
            task.setCallback((tag, success) -> {
                if (success) {
                    Drive currentDrive1;
                    if (ComputerScreen.getMainDrive() == null) {
                        assert (tag != null);
                        if (!tag.method_10573("main_drive", 10)) {
                            this.createErrorDialog("Unable to find main drive.");
                            return;
                        }
                        Drive drive = new Drive(tag.method_10562("main_drive"));
                        ComputerScreen.setMainDrive(drive);
                    }
                    assert (tag != null);
                    class_2499 driveList = tag.method_10554("available_drives", 10);
                    Drive[] drives = new Drive[driveList.size() + 1];
                    drives[0] = currentDrive1 = ComputerScreen.getMainDrive();
                    for (int i = 0; i < driveList.size(); ++i) {
                        class_2487 driveTag = driveList.method_10602(i);
                        drives[i + 1] = new Drive(driveTag);
                    }
                    this.comboBoxDrive.setItems((Drive[])drives);
                    currentDrive1.exists(this.initialFolder, response -> {
                        if (((Boolean)response.data()).booleanValue()) {
                            this.initial(currentDrive1);
                        } else {
                            currentDrive1.createDirectory(this.initialFolder.getParent(), this.initialFolder.getFileName().toString(), response1 -> {
                                if (!response1.success()) {
                                    this.createErrorDialog("Unable to create directory '" + String.valueOf(this.initialFolder) + "': " + response1.message());
                                    return;
                                }
                                this.initial(currentDrive1);
                            });
                        }
                    });
                } else {
                    this.createErrorDialog("A critical error occurred while initializing.");
                }
            });
            TaskManager.sendTask(task);
            this.loadedStructure = true;
        } else {
            this.setLoading(false);
        }
    }

    private void initial(Drive currentDrive1) {
        currentDrive1.info(this.initialFolder, response1 -> {
            if (!response1.success()) {
                this.createErrorDialog("Unable to open directory '" + String.valueOf(this.initialFolder) + "': " + response1.message());
                return;
            }
            this.currentPath = (FileInfo)response1.data();
            this.openFolder((FileInfo)response1.data(), true, (path, success2) -> {
                if (!success2) {
                    this.createErrorDialog("A critical error occurred while initializing.");
                }
                this.setLoading(false);
            });
        });
    }

    @Override
    public void handleTick() {
        if (refreshList) {
            this.currentPath.list(response -> {
                if (response.success()) {
                    this.fileList.removeAll();
                    this.fileList.setItems((List)response.data());
                } else {
                    this.createErrorDialog(response.message());
                }
            });
        }
    }

    public void openFolder(Path directory) {
        this.initialFolder = directory;
    }

    private void openDrive(Drive drive) {
        this.history.clear();
        this.setLoading(true);
        drive.open(response -> {
            if (response.success()) {
                this.fileList.removeAll();
                this.fileList.setItems(((DriveRoot)response.data()).files());
                this.currentPath = ((DriveRoot)response.data()).info();
                this.updatePath();
                this.setLoading(false);
                return;
            }
            this.createErrorDialog(response.message());
            this.setLoading(false);
        });
    }

    private void openFolder(FileInfo info, boolean push, Callback<FileInfo> callback) {
        class_2338 pos = ComputerScreen.getPos();
        if (pos == null) {
            if (callback != null) {
                callback.execute(info, false);
            }
            return;
        }
        this.setLoading(true);
        if (!info.isFolder()) {
            if (callback != null) {
                callback.execute(info, false);
            }
            this.createErrorDialog("Path is not a folder.");
            return;
        }
        info.list(response -> {
            if (!response.success()) {
                this.setLoading(false);
                if (callback != null) {
                    callback.execute(info, false);
                }
                return;
            }
            List<FileInfo> files = (List<FileInfo>)response.data();
            if (this.filter != null) {
                files = files.stream().filter(this.filter).toList();
            }
            this.fileList.removeAll();
            this.fileList.setItems(files);
            this.updatePath();
            this.setLoading(false);
            this.fileList.setItems(files);
            if (push) {
                this.history.push(info);
            }
            callback.execute(info, true);
            this.updatePath();
        });
    }

    private void setCurrentFolder(FileInfo path, boolean push) {
        if (push) {
            this.history.push(path);
            this.btnPreviousFolder.setEnabled(true);
        }
        this.currentPath = path;
        this.fileList.removeAll();
        this.setLoading(true);
        this.currentPath.list(response -> {
            if (!response.success()) {
                this.createErrorDialog(response.message());
                this.setLoading(false);
                return;
            }
            List files = (List)response.data();
            if (this.filter != null) {
                files = files.stream().filter(this.filter).collect(Collectors.toList());
            }
            this.fileList.setItems(files);
            this.updatePath();
        });
    }

    private void createFolder() {
        if (this.currentPath == null) {
            this.createErrorDialog("Browser not loaded yet...");
            return;
        }
        Dialog.Input dialog = new Dialog.Input("Enter a name");
        dialog.setResponseHandler((success, v) -> {
            if (success) {
                if (this.currentPath == null) {
                    this.createErrorDialog("Browser not loaded yet...");
                    return false;
                }
                this.currentPath.createDirectory((String)v, response -> {
                    if (response == null) {
                        this.createErrorDialog("Unable to create folder");
                    } else {
                        if (response.success()) {
                            this.openFolder((FileInfo)response.data(), true, (folder, success2) -> {
                                if (!success2) {
                                    this.createErrorDialog("Unable to open folder");
                                }
                            });
                            return;
                        }
                        this.createErrorDialog(response.message());
                    }
                });
            }
            return true;
        });
        dialog.setTitle("Create a Folder");
        dialog.setPositiveText("Create");
        this.wrappable.openDialog(dialog);
    }

    private void goToPreviousFolder() {
        if (!this.history.isEmpty()) {
            this.setLoading(true);
            FileInfo folder = this.history.pop();
            this.openFolder(folder, false, (folder2, success) -> {
                if (success) {
                    if (this.isRootFolder()) {
                        this.btnPreviousFolder.setEnabled(false);
                    }
                    this.updatePath();
                } else {
                    this.createErrorDialog("Unable to open previous folder");
                }
                this.setLoading(false);
            });
        }
    }

    @Nullable
    public FileInfo getSelectedFile() {
        return this.fileList.getSelectedItem();
    }

    public void addFile(FileInfo file) {
    }

    private void deleteSelectedFile() {
        @Nullable FileInfo file = this.fileList.getSelectedItem();
        if (file != null) {
            if (file.isProtected()) {
                String message = "This " + (file.isFolder() ? "folder" : "file") + " is protected and can not be deleted.";
                Dialog.Message dialog = new Dialog.Message(message);
                this.wrappable.openDialog(dialog);
                return;
            }
            Dialog.Confirmation dialog = new Dialog.Confirmation();
            StringBuilder builder = new StringBuilder();
            builder.append("Are you sure you want to delete this ");
            if (file.isFolder()) {
                builder.append("folder");
            } else {
                builder.append("file");
            }
            builder.append(" '").append(file.getName()).append("'?");
            dialog.setMessageText(builder.toString());
            dialog.setTitle("Delete");
            dialog.setPositiveText("Yes");
            dialog.setPositiveListener((mouseX, mouseY, mouseButton) -> {
                this.removeFile(this.fileList.getSelectedIndex());
                this.btnRename.setEnabled(false);
                this.btnDelete.setEnabled(false);
                if (this.mode == Mode.FULL) {
                    this.btnCopy.setEnabled(false);
                    this.btnCut.setEnabled(false);
                }
            });
            this.wrappable.openDialog(dialog);
        }
    }

    private void removeFile(int index) {
        FileInfo file = this.fileList.getItem(index);
        if (file != null) {
            if (file.isProtected()) {
                String message = "This " + (file.isFolder() ? "folder" : "file") + " is protected and can not be deleted.";
                Dialog.Message dialog = new Dialog.Message(message);
                this.wrappable.openDialog(dialog);
                return;
            }
            this.setLoading(true);
            file.delete(response -> {
                if (response.success()) {
                    this.fileList.removeItem(index);
                    refreshList = true;
                } else {
                    this.createErrorDialog(response.message());
                }
                this.setLoading(false);
            });
        }
    }

    public void removeFile(String name) {
        this.setLoading(true);
        this.currentPath.list(response -> {
            if (!response.success()) {
                this.createErrorDialog(response.message());
                this.setLoading(false);
                return;
            }
            List files = (List)response.data();
            this.fileList.setItems(files);
            for (int i = 0; i < files.size(); ++i) {
                FileInfo file = (FileInfo)files.get(i);
                if (!file.getName().equals(name)) continue;
                if (file.isProtected()) {
                    this.createErrorDialog("This file is protected and can not be deleted.");
                    this.setLoading(false);
                    return;
                }
                this.removeFile(i);
                this.setLoading(false);
                return;
            }
            this.createErrorDialog("File not found");
            this.setLoading(false);
        });
    }

    private void setClipboardFileToSelected() {
        @Nullable FileInfo file = this.fileList.getSelectedItem();
        if (file != null) {
            if (file.isProtected()) {
                String message = "This " + (file.isFolder() ? "folder" : "file") + " is protected and can not be copied.";
                Dialog.Message dialog = new Dialog.Message(message);
                this.wrappable.openDialog(dialog);
                return;
            }
            this.clipboardFile = file;
            this.btnPaste.setEnabled(true);
        } else {
            Dialog.Message dialog = new Dialog.Message("The file/folder you are trying to copy does not exist.");
            this.wrappable.openDialog(dialog);
        }
    }

    private void cutSelectedFile() {
        @Nullable FileInfo file = this.fileList.getSelectedItem();
        if (file != null) {
            if (file.isProtected()) {
                String message = "This " + (file.isFolder() ? "folder" : "file") + " is protected and can not be moved.";
                Dialog.Message dialog = new Dialog.Message(message);
                this.wrappable.openDialog(dialog);
                return;
            }
            this.clipboardDir = this.currentPath;
            this.clipboardFile = file;
            this.btnPaste.setEnabled(true);
        } else {
            Dialog.Message dialog = new Dialog.Message("The file/folder you are trying to cut does not exist.");
            this.wrappable.openDialog(dialog);
        }
    }

    private void pasteClipboardFile() {
        if (this.clipboardFile != null) {
            if (this.canPasteHere()) {
                this.handleCopyCut(false);
            } else {
                Dialog.Message dialog = new Dialog.Message("Destination folder can't be a subfolder");
                this.wrappable.openDialog(dialog);
            }
        }
    }

    private void handleCopyCut(boolean override) {
        this.setLoading(true);
        if (this.clipboardDir != null) {
            this.clipboardFile.moveTo(this.currentPath.getPath(), override, response -> {
                if (response.status() == 4) {
                    Dialog.Confirmation dialog = new Dialog.Confirmation("A file with the same name already exists in this directory. Do you want to override it?");
                    dialog.setPositiveText("Override");
                    dialog.setPositiveListener((mouseX, mouseY, mouseButton) -> {
                        if (mouseButton == 0) {
                            this.handleCopyCut(true);
                        }
                    });
                    this.wrappable.openDialog(dialog);
                    return;
                }
                if (!response.success()) {
                    this.createErrorDialog(response.message());
                    return;
                }
                this.resetClipboard();
            });
        } else {
            this.clipboardFile.copyTo(this.currentPath.getPath(), override, response -> {
                if (response.status() == 4) {
                    Dialog.Confirmation dialog = new Dialog.Confirmation("A file with the same name already exists in this directory. Do you want to override it?");
                    dialog.setPositiveText("Override");
                    dialog.setPositiveListener((mouseX, mouseY, mouseButton) -> {
                        if (mouseButton == 0) {
                            this.handleCopyCut(true);
                        }
                    });
                    this.wrappable.openDialog(dialog);
                    return;
                }
                if (!response.success()) {
                    this.createErrorDialog(response.message());
                    return;
                }
                this.resetClipboard();
            });
        }
    }

    private void resetClipboard() {
        if (this.clipboardDir != null) {
            this.clipboardDir = null;
            this.clipboardFile = null;
            this.btnPaste.setEnabled(false);
        }
        this.currentPath.list(response -> {
            if (!response.success()) {
                this.createErrorDialog(response.message());
                this.setLoading(false);
                return;
            }
            if (this.mode == Mode.FULL) {
                this.btnRename.setEnabled(false);
                this.btnCopy.setEnabled(false);
                this.btnCut.setEnabled(false);
                this.btnDelete.setEnabled(false);
            }
        });
    }

    private boolean canPasteHere() {
        if (this.clipboardFile != null && this.clipboardFile.isFolder()) {
            return !this.history.contains(this.clipboardFile) && this.currentPath != this.clipboardFile;
        }
        return true;
    }

    private boolean isRootFolder() {
        return this.history.isEmpty();
    }

    private void updatePath() {
        Object path = this.currentPath.getPath().toString();
        int width = class_310.method_1551().field_1772.method_1727((String)(path = ((String)path).replace("/", String.valueOf(class_124.field_1065) + "/" + String.valueOf(class_124.field_1070))));
        if (width > 144) {
            path = "..." + class_310.method_1551().field_1772.method_27524((String)path, 144, true);
        }
        this.labelPath.setText((String)path);
    }

    public void setLoading(boolean loading) {
        this.layoutLoading.setVisible(loading);
        if (loading) {
            this.disableAllButtons();
        } else {
            this.updateButtons();
        }
    }

    private void updateButtons() {
        boolean hasSelectedFile = this.fileList.getSelectedIndex() != -1;
        this.btnNewFolder.setEnabled(true);
        this.btnRename.setEnabled(hasSelectedFile);
        this.btnDelete.setEnabled(hasSelectedFile);
        if (this.mode == Mode.FULL) {
            this.btnCopy.setEnabled(hasSelectedFile);
            this.btnCut.setEnabled(hasSelectedFile);
            this.btnPaste.setEnabled(this.clipboardFile != null);
        }
        this.btnPreviousFolder.setEnabled(!this.isRootFolder());
    }

    private void disableAllButtons() {
        this.btnPreviousFolder.setEnabled(false);
        this.btnNewFolder.setEnabled(false);
        this.btnRename.setEnabled(false);
        this.btnDelete.setEnabled(false);
        if (this.mode == Mode.FULL) {
            this.btnCopy.setEnabled(false);
            this.btnCut.setEnabled(false);
            this.btnPaste.setEnabled(false);
        }
    }

    private void renameSelectedFile() {
        @Nullable FileInfo file = this.fileList.getSelectedItem();
        if (file != null) {
            if (file.protectedFile()) {
                String message = "This " + (file.isFolder() ? "folder" : "file") + " is protected and can not be renamed.";
                Dialog.Message dialog = new Dialog.Message(message);
                this.wrappable.openDialog(dialog);
                return;
            }
            Dialog.Input dialog = new Dialog.Input("Enter a name");
            dialog.setResponseHandler((success, s) -> {
                if (success) {
                    this.setLoading(true);
                    file.rename((String)s, response -> {
                        assert (response != null);
                        if (response.status() == 1) {
                            dialog.close();
                        } else {
                            this.createErrorDialog(response.message());
                        }
                        this.setLoading(false);
                    });
                }
                return false;
            });
            dialog.setTitle("Rename " + (file.isFolder() ? "Folder" : "File"));
            dialog.setInputText(file.getName());
            this.wrappable.openDialog(dialog);
        }
    }

    private void createErrorDialog(String message) {
        Dialog.Message dialog = new Dialog.Message(message);
        dialog.setTitle("Error");
        this.wrappable.openDialog(dialog);
    }

    public void setFilter(Predicate<FileInfo> filter) {
        this.filter = filter;
    }

    public void setItemClickListener(ItemClickListener<FileInfo> itemClickListener) {
        this.itemClickListener = itemClickListener;
    }

    public static enum Mode {
        FULL(225, 145, 26, 6),
        BASIC(211, 105, 26, 4);

        private final int width;
        private final int height;
        private final int offset;
        private final int visibleItems;

        private Mode(int width, int height, int offset, int visibleItems) {
            this.width = width;
            this.height = height;
            this.offset = offset;
            this.visibleItems = visibleItems;
        }

        public int getWidth() {
            return this.width;
        }

        public int getHeight() {
            return this.height;
        }

        public int getOffset() {
            return this.offset;
        }

        public int getVisibleItems() {
            return this.visibleItems;
        }
    }
}

