/*
 * Decompiled with CFR 0.152.
 */
package dev.ultreon.devices.programs.themes;

import dev.ultreon.devices.api.app.Application;
import dev.ultreon.devices.api.app.Component;
import dev.ultreon.devices.api.app.Dialog;
import dev.ultreon.devices.api.app.Icons;
import dev.ultreon.devices.api.app.Layout;
import dev.ultreon.devices.api.app.ScrollableLayout;
import dev.ultreon.devices.api.app.System;
import dev.ultreon.devices.api.app.SystemAccessor;
import dev.ultreon.devices.api.app.component.Button;
import dev.ultreon.devices.api.app.component.TextField;
import dev.ultreon.devices.api.utils.RenderUtil;
import dev.ultreon.devices.core.ComputerScreen;
import dev.ultreon.devices.object.AppInfo;
import java.awt.Color;
import java.math.BigInteger;
import net.minecraft.class_2487;
import net.minecraft.class_310;
import net.minecraft.class_332;
import org.jetbrains.annotations.Nullable;

public class ThemesApp
extends Application
implements SystemAccessor {
    private System system;
    private int[] lastMousePositionsX = null;
    private int[] lastMousePositionsY = null;
    private final int[] currentMouse = new int[2];
    int marginX = 10;
    int marginY = 10;
    int paddingY = 4;

    @Override
    public void init(@Nullable class_2487 intent) {
        this.setCurrentLayout(this.createMainMenu());
    }

    @Override
    public void load(class_2487 tag) {
    }

    @Override
    public void save(class_2487 tag) {
    }

    @Override
    public void sendSystem(System system) {
        this.system = system;
    }

    @Override
    public void render(class_332 graphics, ComputerScreen computerScreen, class_310 mc, int x, int y, int mouseX, int mouseY, boolean active, float partialTicks) {
        super.render(graphics, computerScreen, mc, x, y, mouseX, mouseY, active, partialTicks);
    }

    @Override
    public void onTick() {
        super.onTick();
        if (this.lastMousePositionsX != null) {
            int[] newX = new int[20];
            int[] newY = new int[20];
            assert (this.lastMousePositionsX.length == this.lastMousePositionsY.length);
            for (int i = 0; i < newX.length - 1; ++i) {
                int x = this.lastMousePositionsX[i];
                int y = this.lastMousePositionsY[i];
                newX[i + 1] = x;
                newY[i + 1] = y;
            }
            newX[0] = this.currentMouse[0];
            newY[0] = this.currentMouse[1];
            this.lastMousePositionsX = newX;
            this.lastMousePositionsY = newY;
        }
    }

    private void renderBackground(class_332 graphics, class_310 minecraft, int x, int y, int width, int height, int mouseX, int mouseY, boolean active) {
    }

    private Layout createMainMenu() {
        Layout mainMenu = new Layout(200, 100);
        mainMenu.setBackground(this::renderBackground);
        mainMenu.addComponent(new Button(this.marginX, this.marginY, "Themes"));
        mainMenu.addComponent(this.createTintButton());
        return mainMenu;
    }

    private Button createTintButton() {
        Button button = new Button(this.marginX, this.marginY + 16 + this.paddingY, "Tints");
        button.setClickListener((mouseX, mouseY, btn) -> this.setCurrentLayout(this.createTintMenu()));
        return button;
    }

    private Layout createTintMenu() {
        Layout ly = new Layout(200, 100){

            @Override
            public void init() {
                super.init();
                ScrollableLayout s = new ScrollableLayout(200, 800, 100);
                int i = 0;
                for (AppInfo installedApplication : ThemesApp.this.system.getInstalledApplications()) {
                    s.addComponent(new AppTintSet(0, 16 * i, installedApplication));
                    ++i;
                }
                this.addComponent(s);
            }
        };
        ly.setTitle("Tints");
        return ly;
    }

    private static void createCTP() {
    }

    private static class ThemeTintProvider
    implements AppInfo.TintProvider {
        private final Color l;
        private final Color ll;

        ThemeTintProvider(Color l, Color ll) {
            this.l = l;
            this.ll = ll;
        }

        @Override
        public int getTintColor(AppInfo info, int i) {
            return switch (i) {
                case 0 -> new Color(255, 255, 255).getRGB();
                case 1 -> this.l.getRGB();
                case 2 -> this.ll.getRGB();
                default -> new Color(255, 255, 255).getRGB();
            };
        }

        @Override
        public class_2487 toTag() {
            class_2487 l = new class_2487();
            l.method_10569("0", this.getTintColor(null, 0));
            l.method_10569("1", this.getTintColor(null, 1));
            l.method_10569("2", this.getTintColor(null, 2));
            return l;
        }
    }

    private class AppTintSet
    extends Component {
        private static final int width = 200;
        private static final int height = 16;
        private final AppInfo info;
        private boolean editing;

        public AppTintSet(int left, int top, AppInfo info) {
            super(left, top);
            this.info = info;
        }

        @Override
        protected void init(Layout layout) {
            super.init(layout);
            TextField primaryTint = new TextField(this.left + 16, this.top, 50);
            primaryTint.setText(this.toColorHex(this.info.getTint(1)));
            primaryTint.setBackgroundColor(new Color(this.getColorScheme().getBackgroundColor()).darker().darker());
            primaryTint.setTextColor(Color.WHITE.darker());
            primaryTint.setEnabled(false);
            layout.addComponent(primaryTint);
            TextField secondaryTint = new TextField(this.left + 16 + 50, this.top, 50);
            secondaryTint.setText(this.toColorHex(this.info.getTint(2)));
            secondaryTint.setBackgroundColor(new Color(this.getColorScheme().getBackgroundColor()).darker().darker());
            secondaryTint.setTextColor(Color.WHITE.darker());
            secondaryTint.setEnabled(false);
            layout.addComponent(secondaryTint);
            Button editButton = new Button(this.left + 16 + 50 + 50, this.top, Icons.EDIT);
            editButton.setSize(16, 16);
            Button resetButton = new Button(this.left + 16 + 50 + 50 + 16, this.top, Icons.RELOAD);
            resetButton.setSize(16, 16);
            resetButton.setEnabled(false);
            Button okButton = new Button(this.left + 16 + 50 + 50 + 16 + 16, this.top, Icons.CHECK);
            resetButton.setClickListener((__, ___, ____) -> {
                this.info.setTintProvider(AppInfo.getDefaultTintProvider());
                primaryTint.setText(this.toColorHex(this.info.getTint(1)));
                primaryTint.setBackgroundColor(new Color(this.getColorScheme().getBackgroundColor()).darker().darker());
                primaryTint.setTextColor(Color.WHITE.darker());
                primaryTint.setEnabled(false);
                secondaryTint.setText(this.toColorHex(this.info.getTint(2)));
                secondaryTint.setBackgroundColor(new Color(this.getColorScheme().getBackgroundColor()).darker().darker());
                secondaryTint.setTextColor(Color.WHITE.darker());
                secondaryTint.setEnabled(false);
                resetButton.setEnabled(false);
                editButton.setEnabled(true);
                okButton.setEnabled(false);
            });
            layout.addComponent(resetButton);
            okButton.setSize(16, 16);
            okButton.setEnabled(false);
            okButton.setClickListener((__, ___, ____) -> {
                try {
                    Color l = new Color(new BigInteger(primaryTint.getText().replace("#", ""), 16).intValue());
                    Color ll = new Color(new BigInteger(secondaryTint.getText().replace("#", ""), 16).intValue());
                    this.info.setTintProvider(new ThemeTintProvider(l, ll));
                    resetButton.setEnabled(true);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    ThemesApp.this.openDialog(new Dialog.Message("Failed to set tint"));
                }
            });
            layout.addComponent(okButton);
            editButton.setClickListener((__, ___, ____) -> {
                primaryTint.setBackgroundColor(new Color(this.getColorScheme().getBackgroundColor()));
                primaryTint.setTextColor(Color.WHITE);
                primaryTint.setEnabled(true);
                secondaryTint.setBackgroundColor(new Color(this.getColorScheme().getBackgroundColor()));
                secondaryTint.setTextColor(Color.WHITE);
                secondaryTint.setEnabled(true);
                this.editing = true;
                okButton.setEnabled(true);
                editButton.setEnabled(false);
            });
            layout.addComponent(editButton);
            if (this.info.getTintProvider() instanceof ThemeTintProvider) {
                editButton.forceClick(0, 0, 0);
                resetButton.setEnabled(true);
            }
        }

        private String toColorHex(int b) {
            String hexColor = String.format("#%06X", 0xFFFFFF & b);
            return hexColor;
        }

        @Override
        protected void render(class_332 graphics, ComputerScreen computerScreen, class_310 mc, int x, int y, int mouseX, int mouseY, boolean windowActive, float partialTicks) {
            super.render(graphics, computerScreen, mc, x, y, mouseX, mouseY, windowActive, partialTicks);
            graphics.method_51448().method_22903();
            RenderUtil.drawIcon(graphics, x, y, this.info, 16, 16);
            graphics.method_51448().method_22909();
        }
    }
}

