/*
 * Decompiled with CFR 0.152.
 */
package dev.ultreon.devices.util;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import dev.ultreon.devices.util.ScaledResolution;
import java.awt.Color;
import java.nio.ByteBuffer;
import java.util.Stack;
import net.minecraft.class_310;
import org.lwjgl.BufferUtils;

public class GLHelper {
    public static Stack<Scissor> scissorStack = new Stack();

    public static void pushScissor(int x, int y, int width, int height) {
        if (scissorStack.size() > 0) {
            Scissor scissor = scissorStack.peek();
            x = Math.max(scissor.x, x);
            y = Math.max(scissor.y, y);
            width = x + width > scissor.x + scissor.width ? scissor.x + scissor.width - x : width;
            height = y + height > scissor.y + scissor.height ? scissor.y + scissor.height - y : height;
        } else {
            GlStateManager._enableScissorTest();
        }
        class_310 mc = class_310.method_1551();
        ScaledResolution resolution = new ScaledResolution(mc);
        double scale = resolution.getScaleFactor();
        GlStateManager._scissorBox((int)((int)((double)x * scale)), (int)((int)((double)mc.method_22683().method_4506() - (double)y * scale - (double)height * scale)), (int)((int)Math.max(0.0, (double)width * scale)), (int)((int)Math.max(0.0, (double)height * scale)));
        scissorStack.push(new Scissor(x, y, width, height));
    }

    public static void popScissor() {
        if (!scissorStack.isEmpty()) {
            scissorStack.pop();
        }
        GLHelper.restoreScissor();
    }

    private static void restoreScissor() {
        if (!scissorStack.isEmpty()) {
            Scissor scissor = scissorStack.peek();
            class_310 mc = class_310.method_1551();
            ScaledResolution resolution = new ScaledResolution(mc);
            double scale = resolution.getScaleFactor();
            GlStateManager._scissorBox((int)((int)((double)scissor.x * scale)), (int)((int)((double)mc.method_22683().method_4506() - (double)scissor.y * scale - (double)scissor.height * scale)), (int)((int)Math.max(0.0, (double)scissor.width * scale)), (int)((int)Math.max(0.0, (double)scissor.height * scale)));
        } else {
            GlStateManager._disableScissorTest();
        }
    }

    public static boolean isScissorStackEmpty() {
        return scissorStack.isEmpty();
    }

    public static void clearScissorStack() {
        scissorStack.clear();
    }

    public static Color getPixel(int x, int y) {
        class_310 mc = class_310.method_1551();
        ScaledResolution resolution = new ScaledResolution(mc);
        double scale = resolution.getScaleFactor();
        ByteBuffer buffer = BufferUtils.createByteBuffer((int)3);
        RenderSystem.readPixels((int)((int)((double)x * scale)), (int)((int)((double)mc.method_22683().method_4506() - (double)y * scale - scale)), (int)1, (int)1, (int)6407, (int)5120, (ByteBuffer)buffer);
        return new Color(Math.min(255, buffer.get(0) % 256 * 2), Math.min(255, buffer.get(1) % 256 * 2), Math.min(255, buffer.get(2) % 256 * 2));
    }

    public static class Scissor {
        public int x;
        public int y;
        public int width;
        public int height;

        Scissor(int x, int y, int width, int height) {
            this.x = x;
            this.y = y;
            this.width = width;
            this.height = height;
        }
    }
}

