/*
 * Decompiled with CFR 0.152.
 */
package dev.ultreon.devices.api;

import dev.ultreon.devices.UltreonDevices;
import dev.ultreon.devices.api.app.Application;
import dev.ultreon.devices.object.AppInfo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Marker;
import org.slf4j.MarkerFactory;

public final class ApplicationManager {
    private static final Map<ResourceLocation, AppInfo> APP_INFO = new HashMap<ResourceLocation, AppInfo>();
    private static final Marker MARKER = MarkerFactory.getMarker((String)"ApplicationManager");

    private ApplicationManager() {
    }

    @Nullable
    public static Application registerApplication(ResourceLocation identifier, final Supplier<Supplier<Application>> app, final boolean isSystem) {
        UltreonDevices.LOGGER.debug(MARKER, "Registering application {}", (Object)identifier);
        Application application = UltreonDevices.getInstance().registerApplication(identifier, new UltreonDevices.ApplicationSupplier(){

            @Override
            public Supplier<Application> get() {
                return (Supplier)app.get();
            }

            @Override
            public boolean isSystem() {
                return isSystem;
            }
        });
        if (application != null) {
            APP_INFO.put(identifier, application.getInfo());
            return application;
        }
        return null;
    }

    public static List<AppInfo> getAvailableApplications() {
        Predicate<AppInfo> FILTER = info -> !info.isSystemApp() && (!UltreonDevices.hasAllowedApplications() || UltreonDevices.getAllowedApplications().contains(info));
        return APP_INFO.values().stream().filter(FILTER).collect(Collectors.toList());
    }

    public static List<AppInfo> getSystemApplications() {
        return APP_INFO.values().stream().filter(AppInfo::isSystemApp).collect(Collectors.toList());
    }

    public static List<AppInfo> getAllApplications() {
        return new ArrayList<AppInfo>(APP_INFO.values());
    }

    @Nullable
    public static AppInfo getApplication(ResourceLocation appId) {
        return APP_INFO.get(appId);
    }

    public static AppInfo getApplicationForExtension(String upperCase) {
        return APP_INFO.values().stream().filter(info -> info.getExtensions().contains(upperCase)).findFirst().orElse(null);
    }
}

