/*
 * Decompiled with CFR 0.152.
 */
package dev.ultreon.devices.api.app;

import dev.ultreon.devices.api.app.Application;
import dev.ultreon.devices.api.app.Component;
import dev.ultreon.devices.api.app.Icons;
import dev.ultreon.devices.api.app.Layout;
import dev.ultreon.devices.api.app.component.Button;
import dev.ultreon.devices.api.app.component.Image;
import dev.ultreon.devices.api.app.component.ItemList;
import dev.ultreon.devices.api.app.component.Label;
import dev.ultreon.devices.api.app.component.Text;
import dev.ultreon.devices.api.app.component.TextField;
import dev.ultreon.devices.api.app.listener.ClickListener;
import dev.ultreon.devices.api.app.renderer.ListItemRenderer;
import dev.ultreon.devices.api.print.IPrint;
import dev.ultreon.devices.api.task.TaskManager;
import dev.ultreon.devices.api.utils.RenderUtil;
import dev.ultreon.devices.core.ComputerScreen;
import dev.ultreon.devices.core.PermissionRequest;
import dev.ultreon.devices.core.PermissionResult;
import dev.ultreon.devices.core.Wrappable;
import dev.ultreon.devices.core.io.FileSystem;
import dev.ultreon.devices.core.io.Path;
import dev.ultreon.devices.core.network.NetworkDevice;
import dev.ultreon.devices.core.network.task.TaskGetDevices;
import dev.ultreon.devices.core.print.task.TaskPrint;
import dev.ultreon.devices.init.DeviceBlockEntities;
import dev.ultreon.devices.programs.system.component.FileBrowser;
import dev.ultreon.devices.programs.system.component.FileInfo;
import dev.ultreon.devices.programs.system.object.ColorScheme;
import dev.ultreon.devices.util.GLHelper;
import java.io.IOException;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.world.level.block.entity.BlockEntityType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class Dialog
extends Wrappable {
    protected final ColorScheme colorScheme = ComputerScreen.getInstance().getSettings().getColorScheme();
    protected final Layout defaultLayout = new Layout(150, 40);
    private String title = "Message";
    private int width;
    private int height;
    private Layout customLayout;
    private boolean pendingLayoutUpdate = true;
    private boolean pendingClose = false;

    protected final void addComponent(Component c) {
        if (c != null) {
            this.defaultLayout.addComponent(c);
            c.init(this.defaultLayout);
        }
    }

    protected final void setLayout(Layout layout) {
        this.customLayout = layout;
        this.width = layout.width;
        this.height = layout.height;
        this.pendingLayoutUpdate = true;
        this.customLayout.handleLoad();
    }

    @Override
    public void init(@Nullable CompoundTag intent) {
        this.defaultLayout.clear();
        this.setLayout(this.defaultLayout);
    }

    @Override
    public void onTick() {
        if (this.pendingClose && this.getWindow().getDialogWindow() == null) {
            this.getWindow().close();
        }
        if (this.customLayout == null) {
            return;
        }
        this.customLayout.handleTick();
    }

    @Override
    public void render(GuiGraphics graphics, ComputerScreen computerScreen, Minecraft mc, int x, int y, int mouseX, int mouseY, boolean active, float partialTicks) {
        if (this.customLayout == null) {
            return;
        }
        GLHelper.pushScissor(x, y, this.width, this.height);
        this.customLayout.render(graphics, computerScreen, mc, x, y, mouseX, mouseY, active, partialTicks);
        GLHelper.popScissor();
        this.customLayout.renderOverlay(graphics, computerScreen, mc, mouseX, mouseY, active);
    }

    @Override
    public void handleMouseClick(int mouseX, int mouseY, int mouseButton) {
        this.customLayout.handleMouseClick(mouseX, mouseY, mouseButton);
    }

    @Override
    public void handleMouseDrag(int mouseX, int mouseY, int mouseButton) {
        this.customLayout.handleMouseDrag(mouseX, mouseY, mouseButton);
    }

    @Override
    public void handleMouseRelease(int mouseX, int mouseY, int mouseButton) {
        this.customLayout.handleMouseRelease(mouseX, mouseY, mouseButton);
    }

    @Override
    public void handleMouseScroll(int mouseX, int mouseY, double delta, boolean direction) {
        this.customLayout.handleMouseScroll(mouseX, mouseY, direction);
    }

    @Override
    public void handleKeyPressed(int keyCode, int scanCode, int modifiers) {
        this.customLayout.handleKeyPressed(keyCode, scanCode, modifiers);
    }

    @Override
    public void handleKeyReleased(int keyCode, int scanCode, int modifiers) {
        this.customLayout.handleKeyReleased(keyCode, scanCode, modifiers);
    }

    @Override
    public void handleCharTyped(char character, int modifiers) {
        this.customLayout.handleCharTyped(character, modifiers);
    }

    public void setTitle(String title) {
        this.title = title;
    }

    @Override
    public String getWindowTitle() {
        return this.title;
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public void markForLayoutUpdate() {
        this.pendingLayoutUpdate = true;
    }

    @Override
    public boolean isPendingLayoutUpdate() {
        return this.pendingLayoutUpdate;
    }

    @Override
    public void clearPendingLayout() {
        this.pendingLayoutUpdate = false;
    }

    @Override
    public void updateComponents(int x, int y) {
        this.customLayout.updateComponents(x, y);
    }

    public void close() {
        this.pendingClose = true;
    }

    public static class Permission
    extends Dialog {
        private PermissionRequest permissionRequest;
        private Consumer<PermissionResult> callback;
        private String reason;

        public Permission(PermissionRequest permissionRequest, Consumer<PermissionResult> callback, String reason) {
            this.setTitle("Permission Request");
            this.setReason(reason);
            this.setCallback(callback);
            this.setPermissionRequest(permissionRequest);
        }

        public void setPermissionRequest(PermissionRequest permissionRequest) {
            this.permissionRequest = permissionRequest;
        }

        public void setCallback(Consumer<PermissionResult> callback) {
            this.callback = callback;
        }

        public void setReason(String reason) {
            this.reason = reason;
        }

        @Override
        public void init(@Nullable CompoundTag intent) {
            super.init(intent);
            Layout layoutMain = new Layout(120, 70);
            Label labelName = new Label(ChatFormatting.GOLD.toString() + String.valueOf(ChatFormatting.BOLD) + this.permissionRequest.app().getName(), 5, 5);
            layoutMain.addComponent(labelName);
            Label labelReason = new Label(this.reason, 5, 18);
            labelReason.setShadow(false);
            layoutMain.addComponent(labelReason);
            Button buttonAccept = new Button(5, 49, "Accept");
            buttonAccept.setClickListener((mouseX, mouseY, mouseButton) -> {
                if (mouseButton == 0) {
                    this.callback.accept(PermissionResult.GRANTED);
                    this.close();
                }
            });
            layoutMain.addComponent(buttonAccept);
            Button buttonDeny = new Button(70, 49, "Deny");
            buttonDeny.setClickListener((mouseX, mouseY, mouseButton) -> {
                if (mouseButton == 0) {
                    this.callback.accept(PermissionResult.DENIED);
                    this.close();
                }
            });
            layoutMain.addComponent(buttonDeny);
            this.setLayout(layoutMain);
        }
    }

    public static class Print
    extends Dialog {
        private final IPrint print;
        private Layout layoutMain;
        private Label labelMessage;
        private Button buttonRefresh;
        private ItemList<NetworkDevice> itemListPrinters;
        private Button buttonPrint;
        private Button buttonCancel;
        private Button buttonInfo;

        public Print(IPrint print) {
            this.print = print;
            this.setTitle("Print");
        }

        @Override
        public void init(@Nullable CompoundTag intent) {
            super.init(intent);
            this.layoutMain = new Layout(150, 132);
            this.labelMessage = new Label("Select a Printer", 5, 5);
            this.layoutMain.addComponent(this.labelMessage);
            this.buttonRefresh = new Button(131, 2, Icons.RELOAD);
            this.buttonRefresh.setPadding(2);
            this.buttonRefresh.setToolTip("Refresh", "Retrieve an updated list of printers");
            this.buttonRefresh.setClickListener((mouseX, mouseY, mouseButton) -> {
                if (mouseButton == 0) {
                    this.itemListPrinters.setSelectedIndex(-1);
                    this.getPrinters(this.itemListPrinters);
                }
            });
            this.layoutMain.addComponent(this.buttonRefresh);
            this.itemListPrinters = new ItemList(5, 18, 140, 5);
            this.itemListPrinters.setListItemRenderer(new ListItemRenderer<NetworkDevice>(this, 16){

                @Override
                public void render(GuiGraphics graphics, NetworkDevice networkDevice, Minecraft mc, int x, int y, int width, int height, boolean selected) {
                    ColorScheme colorScheme = ComputerScreen.getSystem().getSettings().getColorScheme();
                    graphics.fill(x, y, x + width, y + height, selected ? colorScheme.getItemHighlightColor() : colorScheme.getItemBackgroundColor());
                    Icons.PRINTER.draw(graphics, mc, x + 3, y + 3);
                    RenderUtil.drawStringClipped(graphics, networkDevice.getName(), x + 18, y + 4, 118, ComputerScreen.getSystem().getSettings().getColorScheme().getTextColor(), true);
                }
            });
            this.itemListPrinters.setItemClickListener((blockPos, index, mouseButton) -> {
                if (mouseButton == 0) {
                    this.buttonPrint.setEnabled(true);
                    this.buttonInfo.setEnabled(true);
                }
            });
            this.itemListPrinters.sortBy((o1, o2) -> {
                BlockPos laptopPos = ComputerScreen.getPos();
                assert (laptopPos != null);
                BlockPos pos1 = o1.getPos();
                assert (pos1 != null);
                double distance1 = laptopPos.distToCenterSqr((double)pos1.getX() + 0.5, (double)pos1.getY() + 0.5, (double)pos1.getZ() + 0.5);
                BlockPos pos2 = o2.getPos();
                assert (pos2 != null);
                double distance2 = laptopPos.distToCenterSqr((double)pos2.getX() + 0.5, (double)pos2.getY() + 0.5, (double)pos2.getZ() + 0.5);
                return Double.compare(distance1, distance2);
            });
            this.layoutMain.addComponent(this.itemListPrinters);
            this.buttonPrint = new Button(98, 108, "Print", Icons.CHECK);
            this.buttonPrint.setPadding(5);
            this.buttonPrint.setEnabled(false);
            this.buttonPrint.setClickListener((mouseX, mouseY, mouseButton) -> {
                NetworkDevice networkDevice;
                if (mouseButton == 0 && (networkDevice = this.itemListPrinters.getSelectedItem()) != null) {
                    TaskPrint task = new TaskPrint(ComputerScreen.getPos(), networkDevice, this.print);
                    task.setCallback((tag, success) -> {
                        if (success) {
                            this.close();
                        }
                    });
                    TaskManager.sendTask(task);
                }
            });
            this.layoutMain.addComponent(this.buttonPrint);
            this.buttonCancel = new Button(74, 108, Icons.CROSS);
            this.buttonCancel.setPadding(5);
            this.buttonCancel.setClickListener((mouseX, mouseY, mouseButton) -> {
                if (mouseButton == 0) {
                    this.close();
                }
            });
            this.layoutMain.addComponent(this.buttonCancel);
            this.buttonInfo = new Button(5, 108, Icons.HELP);
            this.buttonInfo.setEnabled(false);
            this.buttonInfo.setPadding(5);
            this.buttonInfo.setClickListener((mouseX, mouseY, mouseButton) -> {
                NetworkDevice printerEntry;
                if (mouseButton == 0 && (printerEntry = this.itemListPrinters.getSelectedItem()) != null) {
                    Info info = new Info(printerEntry);
                    this.openDialog(info);
                }
            });
            this.layoutMain.addComponent(this.buttonInfo);
            this.setLayout(this.layoutMain);
            this.getPrinters(this.itemListPrinters);
        }

        private void getPrinters(ItemList<NetworkDevice> itemList) {
            itemList.removeAll();
            itemList.setLoading(true);
            TaskGetDevices task = new TaskGetDevices(ComputerScreen.getPos(), (BlockEntityType)DeviceBlockEntities.PRINTER.get());
            task.setCallback((tag, success) -> {
                if (success) {
                    assert (tag != null);
                    ListTag list = tag.getList("network_devices", 10);
                    for (int i = 0; i < list.size(); ++i) {
                        itemList.addItem(NetworkDevice.fromTag(list.getCompound(i)));
                    }
                    itemList.setLoading(false);
                } else {
                    String reason = tag == null ? "${null}" : tag.getString("reason");
                    this.openDialog(new Message("Failed to load printers: " + reason));
                }
            });
            TaskManager.sendTask(task);
        }

        private static class Info
        extends Dialog {
            private final NetworkDevice entry;
            private Layout layoutMain;
            private Label labelName;
            private Image imagePaper;
            private Label labelPaper;
            private Label labelPosition;
            private Button buttonClose;

            private Info(NetworkDevice entry) {
                this.entry = entry;
                this.setTitle("Details");
            }

            @Override
            public void init(@Nullable CompoundTag intent) {
                super.init(intent);
                this.layoutMain = new Layout(120, 70);
                this.labelName = new Label(ChatFormatting.GOLD.toString() + String.valueOf(ChatFormatting.BOLD) + this.entry.getName(), 5, 5);
                this.layoutMain.addComponent(this.labelName);
                this.labelPaper = new Label(String.valueOf(ChatFormatting.DARK_GRAY) + "Paper: " + String.valueOf(ChatFormatting.RESET) + "0", 5, 18);
                this.labelPaper.setAlignment(0);
                this.labelPaper.setShadow(false);
                this.layoutMain.addComponent(this.labelPaper);
                assert (this.entry.getPos() != null);
                String position = String.valueOf(ChatFormatting.DARK_GRAY) + "X: " + String.valueOf(ChatFormatting.RESET) + this.entry.getPos().getX() + " " + String.valueOf(ChatFormatting.DARK_GRAY) + "Y: " + String.valueOf(ChatFormatting.RESET) + this.entry.getPos().getY() + " " + String.valueOf(ChatFormatting.DARK_GRAY) + "Z: " + String.valueOf(ChatFormatting.RESET) + this.entry.getPos().getZ();
                this.labelPosition = new Label(position, 5, 30);
                this.labelPosition.setShadow(false);
                this.layoutMain.addComponent(this.labelPosition);
                this.buttonClose = new Button(5, 49, "Close");
                this.buttonClose.setClickListener((mouseX, mouseY, mouseButton) -> {
                    if (mouseButton == 0) {
                        this.close();
                    }
                });
                this.layoutMain.addComponent(this.buttonClose);
                this.setLayout(this.layoutMain);
            }
        }
    }

    public static class SaveFile
    extends Dialog {
        private final Application app;
        public ResponseHandler<FileInfo> responseHandler;
        private String name;
        private String positiveText = "Save";
        private String negativeText = "Cancel";
        private Layout main;
        private FileBrowser browser;
        private TextField textFieldFileName;
        private Button buttonPositive;
        private Button buttonNegative;
        private Predicate<FileInfo> filter;
        private Path path = FileSystem.DIR_HOME;

        @Deprecated
        public SaveFile(Application app, byte[] data) {
            this.app = app;
            this.setTitle("Save File");
        }

        @Deprecated
        public SaveFile(Application app, CompoundTag tag) throws IOException {
            this.app = app;
            this.setTitle("Save File");
        }

        public SaveFile(Application app, String file) {
            this.app = app;
            this.name = file;
            this.setTitle("Save File");
        }

        public SaveFile(Application app) {
            this.app = app;
            this.setTitle("Save File");
        }

        @Override
        public void init(@Nullable CompoundTag intent) {
            super.init(intent);
            this.main = new Layout(211, 145);
            this.browser = new FileBrowser(0, 0, this.app, FileBrowser.Mode.BASIC);
            this.browser.setFilter((FileInfo file) -> this.filter == null || this.filter.test((FileInfo)file) || file.isFolder());
            this.browser.openFolder(this.path);
            this.main.addComponent(this.browser);
            this.buttonPositive = new Button(172, 125, this.positiveText);
            this.buttonPositive.setClickListener((mouseX, mouseY, mouseButton) -> {
                if (mouseButton == 0 && !this.textFieldFileName.getText().isEmpty()) {
                    if (!FileSystem.PATTERN_FILE_NAME.matcher(this.textFieldFileName.getText()).matches()) {
                        Message dialog = new Message("File name may only contain letters, numbers, underscores and spaces.");
                        this.app.openDialog(dialog);
                        return;
                    }
                    FileInfo selectedFile = this.browser.getSelectedFile();
                    if (selectedFile == null) {
                        return;
                    }
                    selectedFile.createFile(this.textFieldFileName.getText(), false, response -> {
                        assert (response != null);
                        if (response.status() == 4) {
                            Confirmation dialog = new Confirmation("A file with that name already exists. Are you sure you want to override it?");
                            dialog.setPositiveText("Override");
                            dialog.setPositiveListener((mouseX1, mouseY1, mouseButton1) -> selectedFile.createFile(this.textFieldFileName.getText(), true, response1 -> {
                                assert (response1 != null);
                                if (response1.success()) {
                                    if (this.responseHandler != null) {
                                        this.responseHandler.onResponse(true, (FileInfo)response1.data());
                                    }
                                } else {
                                    this.app.openDialog(new Message(response1.message()));
                                }
                            }));
                            this.app.openDialog(dialog);
                            return;
                        }
                        if (this.responseHandler != null) {
                            this.responseHandler.onResponse(true, (FileInfo)response.data());
                        }
                    });
                }
            });
            this.main.addComponent(this.buttonPositive);
            this.buttonNegative = new Button(126, 125, this.negativeText);
            this.buttonNegative.setClickListener((mouseX, mouseY, mouseButton) -> this.close());
            this.main.addComponent(this.buttonNegative);
            this.textFieldFileName = new TextField(26, 105, 180);
            this.textFieldFileName.setFocused(true);
            if (this.name != null) {
                this.textFieldFileName.setText(this.name);
            }
            this.main.addComponent(this.textFieldFileName);
            this.setLayout(this.main);
        }

        public void setPositiveText(@NotNull String positiveText) {
            if (positiveText == null) {
                throw new IllegalArgumentException("Text can't be null");
            }
            this.positiveText = positiveText;
        }

        public void setNegativeText(@NotNull String negativeText) {
            if (negativeText == null) {
                throw new IllegalArgumentException("Text can't be null");
            }
            this.negativeText = negativeText;
        }

        public void setResponseHandler(ResponseHandler<FileInfo> responseHandler) {
            this.responseHandler = responseHandler;
        }

        public void setFilter(Predicate<FileInfo> filter) {
            this.filter = filter;
        }

        public void setFilter(Application app) {
            this.filter = file -> app.getInfo().getFormattedId().equals(file.getOpeningApp());
        }

        public void setFolder(Path path) {
            this.path = path;
        }
    }

    public static class OpenFile
    extends Dialog {
        private final Application app;
        private String positiveText = "Open";
        private String negativeText = "Cancel";
        private Layout main;
        private FileBrowser browser;
        private Button buttonPositive;
        private Button buttonNegative;
        private ResponseHandler<FileInfo> responseListener;
        private Predicate<FileInfo> filter;

        public OpenFile(Application app) {
            this.app = app;
            this.setTitle("Open File");
        }

        @Override
        public void init(@Nullable CompoundTag intent) {
            super.init(intent);
            this.main = new Layout(211, 126);
            this.browser = new FileBrowser(0, 0, this.app, FileBrowser.Mode.BASIC);
            this.browser.openFolder(FileSystem.DIR_HOME);
            this.browser.setFilter((FileInfo file) -> this.filter == null || this.filter.test((FileInfo)file) || file.isFolder());
            this.browser.setItemClickListener((file, index, mouseButton) -> {
                if (mouseButton == 0 && !file.isFolder()) {
                    this.buttonPositive.setEnabled(true);
                }
            });
            this.main.addComponent(this.browser);
            int positiveWidth = Minecraft.getInstance().font.width(this.positiveText);
            this.buttonPositive = new Button(172, 106, this.positiveText);
            this.buttonPositive.setSize(positiveWidth + 10, 16);
            this.buttonPositive.setEnabled(false);
            this.buttonPositive.setClickListener((mouseX, mouseY, mouseButton) -> {
                FileInfo file;
                if (mouseButton == 0 && (file = this.browser.getSelectedFile()) != null) {
                    boolean close = true;
                    if (this.responseListener != null) {
                        close = this.responseListener.onResponse(true, file);
                    }
                    if (close) {
                        this.close();
                    }
                }
            });
            this.main.addComponent(this.buttonPositive);
            int negativeWidth = Minecraft.getInstance().font.width(this.negativeText);
            this.buttonNegative = new Button(125, 106, this.negativeText);
            this.buttonNegative.setSize(negativeWidth + 10, 16);
            this.buttonNegative.setClickListener((mouseX, mouseY, mouseButton) -> this.close());
            this.main.addComponent(this.buttonNegative);
            this.setLayout(this.main);
        }

        public void setPositiveText(String positiveText) {
            if (positiveText == null) {
                throw new IllegalArgumentException("Text can't be null");
            }
            this.positiveText = positiveText;
        }

        public void setNegativeText(String negativeText) {
            if (negativeText == null) {
                throw new IllegalArgumentException("Text can't be null");
            }
            this.negativeText = negativeText;
        }

        public void setResponseHandler(ResponseHandler<FileInfo> responseListener) {
            this.responseListener = responseListener;
        }

        public void setFilter(Predicate<FileInfo> filter) {
            this.filter = filter;
        }

        public void setFilter(Application app) {
            this.filter = file -> app.getInfo().getFormattedId().equals(file.getOpeningApp());
        }
    }

    public static class Input
    extends Dialog {
        private static final int DIVIDE_WIDTH = 15;
        private String messageText = null;
        private String inputText = "";
        private String positiveText = "Okay";
        private String negativeText = "Cancel";
        private ResponseHandler<String> responseListener;
        private TextField textFieldInput;
        private Button buttonPositive;
        private Button buttonNegative;

        public Input() {
        }

        public Input(String messageText) {
            this.messageText = messageText;
        }

        @Override
        public void init(@Nullable CompoundTag intent) {
            super.init(intent);
            int offset = 0;
            if (this.messageText != null) {
                int lines = Minecraft.getInstance().font.wordWrapHeight(this.messageText, this.getWidth() - 10);
                this.defaultLayout.height += lines * 9 + 10;
                offset += lines * 9 + 5;
            }
            super.init(intent);
            if (this.messageText != null) {
                Text message = new Text(this.messageText, 5, 5, this.getWidth() - 10);
                this.addComponent(message);
            }
            this.textFieldInput = new TextField(5, 5 + offset, this.getWidth() - 10);
            this.textFieldInput.setText(this.inputText);
            this.textFieldInput.setFocused(true);
            this.addComponent(this.textFieldInput);
            int positiveWidth = Minecraft.getInstance().font.width(this.positiveText);
            this.buttonPositive = new Button(this.getWidth() - positiveWidth - 15, this.getHeight() - 20, this.positiveText);
            this.buttonPositive.setSize(positiveWidth + 10, 16);
            this.buttonPositive.setClickListener((mouseX, mouseY, mouseButton) -> {
                if (!this.textFieldInput.getText().isEmpty()) {
                    boolean close = true;
                    if (this.responseListener != null) {
                        close = this.responseListener.onResponse(true, this.textFieldInput.getText().trim());
                    }
                    if (close) {
                        this.close();
                    }
                }
            });
            this.addComponent(this.buttonPositive);
            int negativeWidth = Minecraft.getInstance().font.width(this.negativeText);
            this.buttonNegative = new Button(this.getWidth() - 15 - positiveWidth - 15 - negativeWidth + 1, this.getHeight() - 20, this.negativeText);
            this.buttonNegative.setSize(negativeWidth + 10, 16);
            this.buttonNegative.setClickListener((mouseX, mouseY, mouseButton) -> this.close());
            this.addComponent(this.buttonNegative);
        }

        public void setInputText(@NotNull String inputText) {
            if (inputText == null) {
                throw new IllegalArgumentException("Text can't be null");
            }
            this.inputText = inputText;
        }

        @Nullable
        public TextField getTextFieldInput() {
            return this.textFieldInput;
        }

        public void setPositiveText(@NotNull String positiveText) {
            if (positiveText == null) {
                throw new IllegalArgumentException("Text can't be null");
            }
            this.positiveText = positiveText;
        }

        public void setNegativeText(@NotNull String negativeText) {
            if (negativeText == null) {
                throw new IllegalArgumentException("Text can't be null");
            }
            this.negativeText = negativeText;
        }

        public void setResponseHandler(ResponseHandler<String> responseListener) {
            this.responseListener = responseListener;
        }
    }

    public static class Confirmation
    extends Dialog {
        private static final int DIVIDE_WIDTH = 15;
        private String messageText = "Are you sure?";
        private String positiveText = "Yes";
        private String negativeText = "No";
        private ClickListener positiveListener;
        private ClickListener negativeListener;
        private Button buttonPositive;
        private Button buttonNegative;

        public Confirmation() {
        }

        public Confirmation(String messageText) {
            this.messageText = messageText;
        }

        @Override
        public void init(@Nullable CompoundTag intent) {
            super.init(intent);
            int lines = Minecraft.getInstance().font.wordWrapHeight(this.messageText, this.getWidth() - 10);
            this.defaultLayout.height += lines - 1;
            super.init(intent);
            Text message = new Text(this.messageText, 5, 5, this.getWidth() - 10);
            this.addComponent(message);
            int positiveWidth = Minecraft.getInstance().font.width(this.positiveText);
            this.buttonPositive = new Button(this.getWidth() - positiveWidth - 15, this.getHeight() - 20, this.positiveText);
            this.buttonPositive.setSize(positiveWidth + 10, 16);
            this.buttonPositive.setClickListener((mouseX, mouseY, mouseButton) -> {
                if (this.positiveListener != null) {
                    this.positiveListener.onClick(mouseX, mouseY, mouseButton);
                }
                this.close();
            });
            this.addComponent(this.buttonPositive);
            int negativeWidth = Math.max(20, Minecraft.getInstance().font.width(this.negativeText));
            this.buttonNegative = new Button(this.getWidth() - 15 - positiveWidth - 15 - negativeWidth + 1, this.getHeight() - 20, this.negativeText);
            this.buttonNegative.setSize(negativeWidth + 10, 16);
            this.buttonNegative.setClickListener((mouseX, mouseY, mouseButton) -> {
                if (this.negativeListener != null) {
                    this.negativeListener.onClick(mouseX, mouseY, mouseButton);
                }
                this.close();
            });
            this.addComponent(this.buttonNegative);
        }

        public void setPositiveText(@NotNull String positiveText) {
            if (positiveText == null) {
                throw new IllegalArgumentException("Text can't be null");
            }
            this.positiveText = positiveText;
        }

        public void setNegativeText(@NotNull String negativeText) {
            if (negativeText == null) {
                throw new IllegalArgumentException("Text can't be null");
            }
            this.negativeText = negativeText;
        }

        public void setPositiveListener(ClickListener positiveListener) {
            this.positiveListener = positiveListener;
        }

        public void setNegativeListener(ClickListener negativeListener) {
            this.negativeListener = negativeListener;
        }

        public void setMessageText(String messageText) {
            this.messageText = messageText;
        }
    }

    public static class Message
    extends Dialog {
        private final String messageText;
        private ClickListener positiveListener;
        private Button buttonPositive;

        public Message(String messageText) {
            this.messageText = messageText;
        }

        @Override
        public void init(@Nullable CompoundTag intent) {
            super.init(intent);
            int textHeight = Minecraft.getInstance().font.wordWrapHeight(this.messageText, this.getWidth() - 10);
            this.defaultLayout.height += textHeight;
            super.init(intent);
            Text message = new Text(this.messageText, 5, 5, this.getWidth() - 10);
            this.addComponent(message);
            this.buttonPositive = new Button(this.getWidth() - 41, this.getHeight() - 20, "Close");
            this.buttonPositive.setSize(36, 16);
            this.buttonPositive.setClickListener((mouseX, mouseY, mouseButton) -> {
                if (this.positiveListener != null) {
                    this.positiveListener.onClick(mouseX, mouseY, mouseButton);
                }
                this.close();
            });
            this.addComponent(this.buttonPositive);
        }
    }

    public static interface ResponseHandler<E> {
        public boolean onResponse(boolean var1, E var2);
    }
}

