/*
 * Decompiled with CFR 0.152.
 */
package dev.ultreon.devices.api.app;

import com.mojang.blaze3d.systems.RenderSystem;
import dev.ultreon.devices.api.app.Component;
import dev.ultreon.devices.api.app.listener.InitListener;
import dev.ultreon.devices.core.ComputerScreen;
import dev.ultreon.devices.util.GLHelper;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;

public class Layout
extends Component {
    public List<Component> components;
    public int width;
    public int height;
    private String title;
    private boolean initialized = false;
    private InitListener initListener;
    private Background background;

    public Layout() {
        this(200, 100);
    }

    public Layout(int width, int height) {
        this(0, 0, width, height);
        if (width < 13) {
            // empty if block
        }
        if (height < 1) {
            // empty if block
        }
        this.components = new CopyOnWriteArrayList<Component>();
        this.width = width;
        this.height = height;
    }

    public Layout(int left, int top, int width, int height) {
        super(left, top);
        if (width < 13) {
            // empty if block
        }
        if (height < 1) {
            // empty if block
        }
        this.components = new CopyOnWriteArrayList<Component>();
        this.width = width;
        this.height = height;
    }

    public void init() {
    }

    public void addComponent(Component c) {
        if (c != null) {
            this.components.add(c);
            c.init(this);
        }
    }

    @Override
    public void init(Layout layout) {
    }

    @Override
    public void handleLoad() {
        if (!this.initialized) {
            this.init();
            this.initialized = true;
        }
        if (this.initListener != null) {
            this.initListener.onInit();
        }
        for (Component c : this.components) {
            c.handleLoad();
        }
    }

    @Override
    protected void handleUnload() {
        for (Component c : this.components) {
            c.handleUnload();
        }
    }

    @Override
    public void handleTick() {
        for (Component c : this.components) {
            c.handleTick();
        }
    }

    @Override
    public void render(GuiGraphics graphics, ComputerScreen computerScreen, Minecraft mc, int x, int y, int mouseX, int mouseY, boolean windowActive, float partialTicks) {
        if (!this.visible) {
            return;
        }
        if (this.background != null) {
            this.background.render(graphics, mc, x, y, this.width, this.height, mouseX, mouseY, windowActive);
        }
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        for (Component c : new ArrayList<Component>(this.components)) {
            RenderSystem.disableDepthTest();
            GLHelper.pushScissor(x, y, this.width, this.height);
            c.render(graphics, computerScreen, mc, x + c.left, y + c.top, mouseX, mouseY, windowActive, partialTicks);
            GLHelper.popScissor();
        }
    }

    @Override
    public void renderOverlay(GuiGraphics graphics, ComputerScreen computerScreen, Minecraft mc, int mouseX, int mouseY, boolean windowActive) {
        if (!this.visible) {
            return;
        }
        for (Component c : this.components.stream().toList()) {
            c.renderOverlay(graphics, computerScreen, mc, mouseX, mouseY, windowActive);
        }
    }

    @Override
    @Deprecated
    public void handleKeyTyped(char character, int code) {
        if (!this.visible || !this.enabled) {
            return;
        }
        for (Component c : this.components) {
            c.handleKeyTyped(character, code);
        }
    }

    @Override
    @Deprecated
    public void handleKeyReleased(char character, int code) {
        if (!this.visible || !this.enabled) {
            return;
        }
        for (Component c : this.components) {
            c.handleKeyReleased(character, code);
        }
    }

    @Override
    public void handleCharTyped(char codePoint, int modifiers) {
        if (!this.visible || !this.enabled) {
            return;
        }
        for (Component c : this.components) {
            c.handleCharTyped(codePoint, modifiers);
        }
    }

    @Override
    public void handleKeyPressed(int keyCode, int scanCode, int modifiers) {
        if (!this.visible || !this.enabled) {
            return;
        }
        for (Component c : this.components) {
            c.handleKeyPressed(keyCode, scanCode, modifiers);
        }
    }

    @Override
    public void handleKeyReleased(int keyCode, int scanCode, int modifiers) {
        if (!this.visible || !this.enabled) {
            return;
        }
        for (Component c : this.components) {
            c.handleKeyReleased(keyCode, scanCode, modifiers);
        }
    }

    @Override
    public void handleMouseClick(int mouseX, int mouseY, int mouseButton) {
        if (!this.visible || !this.enabled) {
            return;
        }
        for (Component c : this.components) {
            c.handleMouseClick(mouseX, mouseY, mouseButton);
        }
    }

    @Override
    public void handleMouseDrag(int mouseX, int mouseY, int mouseButton) {
        if (!this.visible || !this.enabled) {
            return;
        }
        for (Component c : this.components) {
            c.handleMouseDrag(mouseX, mouseY, mouseButton);
        }
    }

    @Override
    public void handleMouseRelease(int mouseX, int mouseY, int mouseButton) {
        if (!this.visible || !this.enabled) {
            return;
        }
        for (Component c : this.components) {
            c.handleMouseRelease(mouseX, mouseY, mouseButton);
        }
    }

    @Override
    public void handleMouseScroll(int mouseX, int mouseY, boolean direction) {
        if (!this.visible || !this.enabled) {
            return;
        }
        for (Component c : this.components) {
            c.handleMouseScroll(mouseX, mouseY, direction);
        }
    }

    @Override
    public void updateComponents(int x, int y) {
        super.updateComponents(x, y);
        for (Component c : this.components) {
            c.updateComponents(x + this.left, y + this.top);
        }
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        for (Component c : this.components) {
            c.setEnabled(enabled);
        }
    }

    @Override
    public void setVisible(boolean visible) {
        super.setVisible(visible);
        for (Component c : this.components) {
            c.setVisible(visible);
        }
    }

    public void setInitListener(InitListener initListener) {
        this.initListener = initListener;
    }

    public void setBackground(Background background) {
        this.background = background;
    }

    public void clear() {
        this.components.clear();
    }

    public boolean hasTitle() {
        return this.title != null;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public void setInitialized(boolean initialized) {
        this.initialized = initialized;
    }

    public static interface Background {
        public void render(GuiGraphics var1, Minecraft var2, int var3, int var4, int var5, int var6, int var7, int var8, boolean var9);
    }

    public static class Context
    extends Layout {
        private boolean borderVisible = true;

        public Context(int width, int height) {
            super(width, height);
        }

        @Override
        public void render(GuiGraphics graphics, ComputerScreen computerScreen, Minecraft mc, int x, int y, int mouseX, int mouseY, boolean windowActive, float partialTicks) {
            super.render(graphics, computerScreen, mc, x, y, mouseX, mouseY, windowActive, partialTicks);
            if (this.borderVisible) {
                this.drawHorizontalLine(graphics, x, x + this.width - 1, y, Color.DARK_GRAY.getRGB());
                this.drawHorizontalLine(graphics, x, x + this.width - 1, y + this.height - 1, Color.DARK_GRAY.getRGB());
                this.drawVerticalLine(graphics, x, y, y + this.height - 1, Color.DARK_GRAY.getRGB());
                this.drawVerticalLine(graphics, x + this.width - 1, y, y + this.height - 1, Color.DARK_GRAY.getRGB());
            }
        }

        public void setBorderVisible(boolean visible) {
            this.borderVisible = visible;
        }
    }
}

