/*
 * Decompiled with CFR 0.152.
 */
package dev.ultreon.devices.api.app;

import dev.ultreon.devices.api.app.IIcon;
import dev.ultreon.devices.network.PacketHandler;
import dev.ultreon.devices.network.task.NotificationPacket;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerPlayer;
import org.apache.commons.lang3.StringUtils;

public class Notification {
    private final IIcon icon;
    private final String title;
    private String subTitle;

    public Notification(IIcon icon, String title) {
        this.icon = icon;
        this.title = title;
    }

    public Notification(IIcon icon, String title, String subTitle) {
        this(icon, title);
        this.subTitle = subTitle;
    }

    public CompoundTag toTag() {
        CompoundTag tag = new CompoundTag();
        tag.putString("title", this.title);
        if (!StringUtils.isEmpty((CharSequence)this.subTitle)) {
            tag.putString("subTitle", this.subTitle);
        }
        CompoundTag tagIcon = new CompoundTag();
        tagIcon.putInt("ordinal", this.icon.getOrdinal());
        tagIcon.putString("className", this.icon.getClass().getName());
        tag.put("icon", (Tag)tagIcon);
        return tag;
    }

    public void pushTo(ServerPlayer player) {
        PacketHandler.sendToClient(new NotificationPacket(this), player);
    }
}

