/*
 * Decompiled with CFR 0.152.
 */
package dev.ultreon.devices.api.app.component;

import com.mojang.blaze3d.systems.RenderSystem;
import dev.ultreon.devices.api.app.Component;
import dev.ultreon.devices.api.app.Layout;
import dev.ultreon.devices.api.app.component.ItemList;
import dev.ultreon.devices.api.app.listener.ChangeListener;
import dev.ultreon.devices.api.app.renderer.ItemRenderer;
import dev.ultreon.devices.api.app.renderer.ListItemRenderer;
import dev.ultreon.devices.api.utils.RenderUtil;
import dev.ultreon.devices.core.ComputerScreen;
import java.awt.Color;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ComboBox<T>
extends Component {
    protected T value;
    protected boolean hovered;
    protected int width = 80;
    protected int height = 14;
    protected Layout layout;
    protected ItemRenderer<T> itemRenderer;
    protected ChangeListener<T> changeListener;
    private boolean opened = false;

    public ComboBox(int left, int top) {
        super(left, top);
    }

    public ComboBox(int left, int top, int width) {
        super(left, top);
        this.width = width;
    }

    @Override
    public void handleTick() {
        super.handleTick();
        if (this.opened && !ComputerScreen.getSystem().hasContext()) {
            this.opened = false;
        }
    }

    @Override
    public void init(Layout layout) {
        this.layout.setBackground((graphics, mc, x, y, width, height, mouseX, mouseY, windowActive) -> graphics.fill(x, y, x + width, y + height, Color.GRAY.getRGB()));
    }

    @Override
    public void render(GuiGraphics graphics, ComputerScreen computerScreen, Minecraft mc, int x, int y, int mouseX, int mouseY, boolean windowActive, float partialTicks) {
        if (this.visible) {
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)Component.COMPONENTS_GUI);
            RenderSystem.enableBlend();
            RenderSystem.blendFuncSeparate((int)770, (int)771, (int)1, (int)0);
            RenderSystem.blendFunc((int)770, (int)771);
            Color bgColor = new Color(this.getColorScheme().getBackgroundColor(), true).brighter().brighter();
            float[] hsb = Color.RGBtoHSB(bgColor.getRed(), bgColor.getGreen(), bgColor.getBlue(), null);
            bgColor = new Color(Color.HSBtoRGB(hsb[0], hsb[1], 1.0f));
            RenderSystem.setShaderColor((float)((float)bgColor.getRed() / 255.0f), (float)((float)bgColor.getGreen() / 255.0f), (float)((float)bgColor.getBlue() / 255.0f), (float)1.0f);
            this.hovered = this.isInside(mouseX, mouseY) && windowActive;
            int i = this.getHoverState(this.hovered);
            int xOffset = this.width - this.height;
            RenderUtil.drawRectWithTexture(Component.COMPONENTS_GUI, graphics, this.xPosition + xOffset, this.yPosition, 96 + i * 5, 12.0f, 2, 2, 2.0f, 2.0f);
            RenderUtil.drawRectWithTexture(Component.COMPONENTS_GUI, graphics, this.xPosition + this.height - 2 + xOffset, this.yPosition, 99 + i * 5, 12.0f, 2, 2, 2.0f, 2.0f);
            RenderUtil.drawRectWithTexture(Component.COMPONENTS_GUI, graphics, this.xPosition + this.height - 2 + xOffset, this.yPosition + this.height - 2, 99 + i * 5, 15.0f, 2, 2, 2.0f, 2.0f);
            RenderUtil.drawRectWithTexture(Component.COMPONENTS_GUI, graphics, this.xPosition + xOffset, this.yPosition + this.height - 2, 96 + i * 5, 15.0f, 2, 2, 2.0f, 2.0f);
            RenderUtil.drawRectWithTexture(Component.COMPONENTS_GUI, graphics, this.xPosition + 2 + xOffset, this.yPosition, 98 + i * 5, 12.0f, this.height - 4, 2, 1.0f, 2.0f);
            RenderUtil.drawRectWithTexture(Component.COMPONENTS_GUI, graphics, this.xPosition + this.height - 2 + xOffset, this.yPosition + 2, 99 + i * 5, 14.0f, 2, this.height - 4, 2.0f, 1.0f);
            RenderUtil.drawRectWithTexture(Component.COMPONENTS_GUI, graphics, this.xPosition + 2 + xOffset, this.yPosition + this.height - 2, 98 + i * 5, 15.0f, this.height - 4, 2, 1.0f, 2.0f);
            RenderUtil.drawRectWithTexture(Component.COMPONENTS_GUI, graphics, this.xPosition + xOffset, this.yPosition + 2, 96 + i * 5, 14.0f, 2, this.height - 4, 2.0f, 1.0f);
            RenderUtil.drawRectWithTexture(Component.COMPONENTS_GUI, graphics, this.xPosition + 2 + xOffset, this.yPosition + 2, 98 + i * 5, 14.0f, this.height - 4, this.height - 4, 1.0f, 1.0f);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderUtil.drawRectWithTexture(Component.COMPONENTS_GUI, graphics, this.xPosition + xOffset + 3, this.yPosition + 5, 111.0f, 12.0f, 8, 5, 8.0f, 5.0f);
            Color boxColor = new Color(this.getColorScheme().getBackgroundColor(), true);
            Color borderColor = boxColor.darker().darker();
            this.drawHorizontalLine(graphics, this.xPosition, this.xPosition + xOffset, this.yPosition, borderColor.getRGB());
            this.drawHorizontalLine(graphics, this.xPosition, this.xPosition + xOffset, this.yPosition + this.height - 1, borderColor.getRGB());
            this.drawVerticalLine(graphics, this.xPosition, this.yPosition, this.yPosition + this.height - 1, borderColor.getRGB());
            graphics.fill(this.xPosition + 1, this.yPosition + 1, this.xPosition + xOffset, this.yPosition + this.height - 1, boxColor.getRGB());
            if (this.itemRenderer != null) {
                this.itemRenderer.render(graphics, this.value, mc, x + 1, y + 1, xOffset - 1, this.height - 2);
            } else if (this.value != null) {
                RenderUtil.drawStringClipped(graphics, this.value.toString(), this.xPosition + 3, this.yPosition + 3, this.width - 15, Color.WHITE.getRGB(), true);
            }
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
    }

    @Override
    public void handleMouseClick(int mouseX, int mouseY, int mouseButton) {
        if (!this.visible || !this.enabled) {
            return;
        }
        if (this.hovered && !this.opened) {
            this.opened = true;
            ComputerScreen.getSystem().openContext(this.layout, this.xPosition, this.yPosition + 13);
        }
    }

    @Nullable
    public T getValue() {
        return this.value;
    }

    protected void updateValue(T newValue) {
        if (newValue != null && this.value != newValue) {
            if (this.value != null && this.changeListener != null) {
                this.changeListener.onChange(this.value, newValue);
            }
            this.value = newValue;
        }
    }

    protected boolean isInside(int mouseX, int mouseY) {
        return mouseX >= this.xPosition && mouseY >= this.yPosition && mouseX < this.xPosition + this.width && mouseY < this.yPosition + this.height;
    }

    protected int getHoverState(boolean mouseOver) {
        int i = 1;
        if (!this.enabled) {
            i = 0;
        } else if (mouseOver) {
            i = 2;
        }
        return i;
    }

    public void setItemRenderer(ItemRenderer<T> itemRenderer) {
        this.itemRenderer = itemRenderer;
    }

    public void setChangeListener(ChangeListener<T> changeListener) {
        this.changeListener = changeListener;
    }

    public void closeContext() {
        ComputerScreen.getSystem().closeContext();
    }

    public static class Custom<T>
    extends ComboBox<T> {
        public Custom(int left, int top, int width, int contextWidth, int contextHeight) {
            super(left, top);
            this.width = width;
            this.layout = new Layout.Context(contextWidth, contextHeight);
        }

        public Layout.Context getLayout() {
            return (Layout.Context)this.layout;
        }

        public void setValue(@NotNull T newVal) {
            this.updateValue(newVal);
        }
    }

    public static class List<T>
    extends ComboBox<T> {
        private final ItemList<T> list;
        private T selected;

        public List(int left, int top, T[] items) {
            super(left, top);
            this.list = new ItemList(0, 0, this.width, 6, false);
            this.layout = new Layout(this.width, List.getListHeight(this.list));
            this.setItems(items);
        }

        public List(int left, int top, int width, T[] items) {
            super(left, top, width);
            this.list = new ItemList(0, 0, width, 6, false);
            this.layout = new Layout(width, List.getListHeight(this.list));
            this.setItems(items);
        }

        public List(int left, int top, int comboBoxWidth, int listWidth, T[] items) {
            super(left, top, comboBoxWidth);
            this.list = new ItemList(0, 0, listWidth, 6, false);
            this.layout = new Layout(listWidth, List.getListHeight(this.list));
            this.setItems(items);
        }

        private static int getListHeight(ItemList<?> list) {
            int size = Math.max(1, Math.min(list.visibleItems, list.getItems().size()));
            return (list.renderer != null ? list.renderer.getHeight() : 13) * size + size + 1;
        }

        private static int getListWidth(ItemList<?> list) {
            return list.width + 15;
        }

        @Override
        public void init(Layout layout) {
            super.init(layout);
            this.list.setItemClickListener((t, index, mouseButton) -> {
                if (mouseButton == 0) {
                    this.selected = t;
                    this.updateValue(t);
                    ComputerScreen.getSystem().closeContext();
                }
            });
            this.layout.addComponent(this.list);
        }

        public void setItems(T[] items) {
            if (items == null) {
                throw new IllegalArgumentException("Cannot set null items");
            }
            this.list.removeAll();
            for (T t : items) {
                this.list.addItem(t);
            }
            if (items.length > 0) {
                this.selected = this.list.getItem(0);
                this.updateValue(this.selected);
            }
            this.layout.height = List.getListHeight(this.list);
        }

        public T getSelectedItem() {
            return this.selected;
        }

        public void setSelectedItem(int index) {
            T t = this.list.getItem(index);
            if (t != null) {
                this.selected = t;
                this.updateValue(t);
            }
        }

        public void setSelectedItem(T t) {
            if (this.list.getItems().stream().anyMatch(i -> i == t)) {
                this.list.setSelectedIndex(this.list.getItems().indexOf(t));
                this.selected = t;
                this.updateValue(t);
            }
        }

        public void setListItemRenderer(ListItemRenderer<T> renderer) {
            this.list.setListItemRenderer(renderer);
            this.layout.height = List.getListHeight(this.list);
        }
    }
}

