/*
 * Decompiled with CFR 0.152.
 */
package dev.ultreon.devices.api.app.component;

import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.platform.TextureUtil;
import com.mojang.blaze3d.systems.RenderSystem;
import dev.ultreon.devices.UltreonDevices;
import dev.ultreon.devices.api.app.Component;
import dev.ultreon.devices.api.app.Dialog;
import dev.ultreon.devices.api.app.IIcon;
import dev.ultreon.devices.api.app.Layout;
import dev.ultreon.devices.api.app.component.Spinner;
import dev.ultreon.devices.api.utils.OnlineRequest;
import dev.ultreon.devices.api.utils.RenderUtil;
import dev.ultreon.devices.core.ComputerScreen;
import dev.ultreon.devices.core.io.Path;
import dev.ultreon.devices.object.AppInfo;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.client.renderer.texture.MissingTextureAtlasSprite;
import net.minecraft.client.renderer.texture.SimpleTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import org.apache.commons.io.IOUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.stb.STBImage;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;

public class Image
extends Component {
    public static final Map<String, CachedImage> CACHE = new HashMap<String, CachedImage>();
    protected ImageLoader loader;
    protected CachedImage image;
    protected boolean initialized = false;
    protected boolean drawFull = false;
    protected int imageU;
    protected int imageV;
    protected int imageWidth;
    protected int imageHeight;
    protected int sourceWidth;
    protected int sourceHeight;
    public int componentWidth;
    public int componentHeight;
    private Spinner spinner;
    private float alpha = 1.0f;
    private Supplier<ColorSupplier> tint = () -> (ColorSupplier)Util.make((Object)new ColorSupplier(), cs -> {
        cs.r = 255;
        cs.g = 255;
        cs.b = 255;
    });
    private boolean hasBorder = false;
    private int borderColor = Color.BLACK.getRGB();
    private int borderThickness = 0;
    private int _pBorderThickness = 1;

    public void setTint(int r, int g, int b) {
        ColorSupplier cs = new ColorSupplier();
        cs.r = r;
        cs.g = g;
        cs.b = b;
        this.setTint(() -> cs);
    }

    public void setTint(Supplier<ColorSupplier> colorSupplier) {
        this.tint = colorSupplier;
    }

    public Image(int left, int top, int width, int height) {
        super(left, top);
        this.componentWidth = width;
        this.componentHeight = height;
    }

    public Image(int left, int top, int imageU, int imageV, int imageWidth, int imageHeight, ResourceLocation resource) {
        this(left, top, imageWidth, imageHeight, imageU, imageV, imageWidth, imageHeight, resource);
    }

    public Image(int left, int top, int componentWidth, int componentHeight, int imageU, int imageV, int imageWidth, int imageHeight, ResourceLocation resource) {
        this(left, top, componentWidth, componentHeight, imageU, imageV, imageWidth, imageHeight, 256, 256, resource);
    }

    public Image(int left, int top, int componentWidth, int componentHeight, int imageU, int imageV, int imageWidth, int imageHeight, int sourceWidth, int sourceHeight, ResourceLocation resource) {
        super(left, top);
        this.loader = new StandardLoader(resource);
        this.componentWidth = componentWidth;
        this.componentHeight = componentHeight;
        this.imageU = imageU;
        this.imageV = imageV;
        this.imageWidth = imageWidth;
        this.imageHeight = imageHeight;
        this.sourceWidth = sourceWidth;
        this.sourceHeight = sourceHeight;
    }

    public Image(int left, int top, int componentWidth, int componentHeight, String url) {
        super(left, top);
        this.loader = new DynamicLoader(url);
        this.componentWidth = componentWidth;
        this.componentHeight = componentHeight;
        this.drawFull = true;
    }

    public Image(int left, int top, IIcon icon) {
        super(left, top);
        this.loader = new StandardLoader(icon.getIconAsset());
        this.componentWidth = icon.getIconSize();
        this.componentHeight = icon.getIconSize();
        this.imageU = icon.getU();
        this.imageV = icon.getV();
        this.imageWidth = icon.getIconSize();
        this.imageHeight = icon.getIconSize();
        this.sourceWidth = icon.getGridWidth() * icon.getIconSize();
        this.sourceHeight = icon.getGridHeight() * icon.getIconSize();
    }

    public Image(int left, int top, int componentWidth, int componentHeight, IIcon icon) {
        super(left, top);
        this.loader = new StandardLoader(icon.getIconAsset());
        this.componentWidth = componentWidth;
        this.componentHeight = componentHeight;
        this.imageU = icon.getU();
        this.imageV = icon.getV();
        this.imageWidth = icon.getIconSize();
        this.imageHeight = icon.getIconSize();
        this.sourceWidth = icon.getGridWidth() * icon.getIconSize();
        this.sourceHeight = icon.getGridHeight() * icon.getIconSize();
    }

    @Override
    public void init(Layout layout) {
        if (layout != null) {
            this.spinner = new Spinner(this.left + this.componentWidth / 2 - 6, this.top + this.componentHeight / 2 - 6);
            layout.addComponent(this.spinner);
        }
        this.initialized = true;
    }

    @Override
    public void handleLoad() {
        this.reload();
    }

    @Override
    protected void handleUnload() {
        this.initialized = false;
    }

    @Override
    public void render(GuiGraphics graphics, ComputerScreen computerScreen, Minecraft mc, int x, int y, int mouseX, int mouseY, boolean windowActive, float partialTicks) {
        if (this.visible) {
            if (this.loader != null && this.loader.setup) {
                this.image = this.loader.load(this);
                this.spinner.setVisible(false);
                this.loader.setup = false;
            }
            if (this.hasBorder) {
                graphics.fill(x, y, x + this.componentWidth, y + this.componentHeight, this.borderColor);
            }
            RenderSystem.setShaderColor((float)((float)this.tint.get().r / 255.0f), (float)((float)this.tint.get().g / 255.0f), (float)((float)this.tint.get().b / 255.0f), (float)this.alpha);
            if (this.image != null && this.image.textureId != -1) {
                this.image.restore();
                RenderSystem.setShaderColor((float)((float)this.tint.get().r / 255.0f), (float)((float)this.tint.get().g / 255.0f), (float)((float)this.tint.get().b / 255.0f), (float)this.alpha);
                RenderSystem.enableBlend();
                RenderSystem.setShaderTexture((int)0, (int)this.image.textureId);
                if (this.drawFull) {
                    RenderUtil.drawRectWithTexture(null, graphics, (double)(x + this.borderThickness), (double)(y + this.borderThickness), 0.0, (float)this.imageU, (float)this.imageV, this.componentWidth - this.borderThickness * 2, this.componentHeight - this.borderThickness * 2, 256.0f, 256.0f);
                } else {
                    RenderUtil.drawRectWithTexture(null, graphics, (double)(x + this.borderThickness), (double)(y + this.borderThickness), (float)this.imageU, (float)this.imageV, this.componentWidth - this.borderThickness * 2, this.componentHeight - this.borderThickness * 2, (float)this.imageWidth, (float)this.imageHeight, this.sourceWidth, this.sourceHeight);
                }
            } else {
                graphics.fill(x + this.borderThickness, y + this.borderThickness, x + this.componentWidth - this.borderThickness, y + this.componentHeight - this.borderThickness, Color.LIGHT_GRAY.getRGB());
            }
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)this.alpha);
        }
    }

    public void reload() {
        if (this.loader != null) {
            this.loader.setup(this);
        }
    }

    public void setImage(ResourceLocation resource) {
        this.setLoader(new StandardLoader(resource));
        this.drawFull = true;
    }

    public void setImage(ComputerScreen.Wallpaper wallpaper) {
        if (wallpaper.isBuiltIn()) {
            this.setImage(ComputerScreen.getWallpapers().get(wallpaper.getLocation()));
        } else {
            this.setImage(wallpaper.getPath());
        }
    }

    public void setImage(String url) {
        this.setLoader(new DynamicLoader(url));
        this.drawFull = true;
    }

    public void setImage(Path path) {
        this.setLoader(new DynamicLoader(path));
        this.drawFull = true;
    }

    private void setLoader(ImageLoader loader) {
        this.loader = loader;
        if (this.initialized) {
            loader.setup(this);
            this.spinner.setVisible(true);
        }
    }

    public void setAlpha(float alpha) {
        if (alpha < 0.0f) {
            this.alpha = 0.0f;
            return;
        }
        if (alpha > 1.0f) {
            this.alpha = 1.0f;
            return;
        }
        this.alpha = alpha;
    }

    public void setBorderVisible(boolean show) {
        this.hasBorder = show;
        this.borderThickness = show ? this._pBorderThickness : 0;
    }

    private void setBorderColor(Color color) {
        this.borderColor = color.getRGB();
    }

    public void setBorderThickness(int thickness) {
        this._pBorderThickness = thickness;
        this.borderThickness = thickness;
    }

    public void setDrawFull(boolean drawFull) {
        this.drawFull = drawFull;
    }

    public static NativeImage read(InputStream textureStream) throws IOException {
        return Image.read(NativeImage.Format.RGBA, textureStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static NativeImage read(@Nullable NativeImage.Format format, InputStream textureStream) throws IOException {
        NativeImage loaded;
        ByteBuffer loadBuffer = null;
        try {
            loadBuffer = TextureUtil.readResource((InputStream)textureStream);
            loadBuffer.rewind();
            loaded = Image.read(format, loadBuffer);
        }
        finally {
            MemoryUtil.memFree((Buffer)loadBuffer);
            IOUtils.closeQuietly((InputStream)textureStream);
        }
        return loaded;
    }

    public static NativeImage read(@Nullable NativeImage.Format format, ByteBuffer textureData) throws IOException {
        if (format != null && !format.supportedByStb()) {
            throw new UnsupportedOperationException("Don't know how to read format " + String.valueOf(format));
        }
        if (MemoryUtil.memAddress((ByteBuffer)textureData) == 0L) {
            throw new IllegalArgumentException("Invalid buffer");
        }
        try (MemoryStack memoryStack = MemoryStack.stackPush();){
            IntBuffer xBuf = memoryStack.mallocInt(1);
            IntBuffer yBuf = memoryStack.mallocInt(1);
            IntBuffer channelBuf = memoryStack.mallocInt(1);
            ByteBuffer imageBuf = STBImage.stbi_load_from_memory((ByteBuffer)textureData, (IntBuffer)xBuf, (IntBuffer)yBuf, (IntBuffer)channelBuf, (int)(format == null ? 0 : format.components()));
            if (imageBuf == null) {
                throw new IOException("Could not load image: " + STBImage.stbi_failure_reason());
            }
            NativeImage nativeImage = new NativeImage(format == null ? Image.getStbFormat(channelBuf.get(0)) : format, xBuf.get(0), yBuf.get(0), true, MemoryUtil.memAddress((ByteBuffer)imageBuf));
            return nativeImage;
        }
    }

    static NativeImage.Format getStbFormat(int channels) {
        return switch (channels) {
            case 1 -> NativeImage.Format.LUMINANCE;
            case 2 -> NativeImage.Format.LUMINANCE_ALPHA;
            case 3 -> NativeImage.Format.RGB;
            default -> NativeImage.Format.RGBA;
        };
    }

    public static class ColorSupplier {
        int r;
        int g;
        int b;
    }

    private static class StandardLoader
    extends ImageLoader {
        private final AbstractTexture texture;
        private final ResourceLocation resource;

        public StandardLoader(ResourceLocation resource) {
            this.texture = new SimpleTexture(resource);
            this.resource = resource;
        }

        @Override
        protected void setup(Image image) {
            this.setup = true;
        }

        @Override
        public CachedImage load(Image image) {
            @Nullable AbstractTexture textureObj = Minecraft.getInstance().getTextureManager().getTexture(this.resource, null);
            if (textureObj != null) {
                return new CachedImage(textureObj.getId(), 0, 0, false);
            }
            SimpleTexture texture = new SimpleTexture(this.resource);
            Minecraft.getInstance().getTextureManager().register(this.resource, (AbstractTexture)texture);
            return new CachedImage(texture.getId(), 0, 0, false);
        }

        public AbstractTexture getTexture() {
            return this.texture;
        }
    }

    protected static abstract class ImageLoader {
        protected boolean setup = false;

        protected ImageLoader() {
        }

        public final boolean isSetup() {
            return this.setup;
        }

        protected void setup(Image image) {
            this.setup = false;
        }

        public abstract CachedImage load(Image var1);
    }

    private static class DynamicLoader
    extends ImageLoader {
        private String url;
        private Path path;
        private AbstractTexture texture;

        public DynamicLoader(String url) {
            this.url = url;
        }

        public DynamicLoader(Path path) {
            this.path = path;
        }

        @Override
        public void setup(Image image) {
            if (CACHE.containsKey(this.url)) {
                this.setup = true;
                return;
            }
            Runnable r = () -> {
                if (this.path != null) {
                    ComputerScreen.getOrLoadMainDrive((drive, success) -> {
                        if (!success) {
                            this.texture = MissingTextureAtlasSprite.getTexture();
                            this.setup = true;
                            return;
                        }
                        if (drive != null) {
                            drive.read(this.path, response -> {
                                if (!response.success()) {
                                    Dialog.Message dialog = new Dialog.Message("Failed to load image: " + response.message());
                                    ComputerScreen.getInstance().setSystemDialog(dialog);
                                    this.texture = MissingTextureAtlasSprite.getTexture();
                                    this.setup = true;
                                    return;
                                }
                                ByteArrayInputStream in = new ByteArrayInputStream((byte[])response.data());
                                try (NativeImage nativeImage = Image.read(in);){
                                    ComputerScreen.runLater(() -> {
                                        UltreonDevices.LOGGER.debug("Loaded image: {}", (Object)this.path);
                                        this.texture = new DynamicTexture(nativeImage);
                                        this.setup = true;
                                    });
                                }
                                catch (IOException e) {
                                    this.texture = MissingTextureAtlasSprite.getTexture();
                                    this.setup = true;
                                    UltreonDevices.LOGGER.error("Failed to load image: {}", (Object)this.path, (Object)e);
                                }
                            });
                        }
                    });
                    return;
                }
                try {
                    URI url = new URI(this.url);
                    OnlineRequest.checkURLForSuspicions(url);
                    HttpURLConnection conn = (HttpURLConnection)url.toURL().openConnection();
                    conn.setRequestProperty("User-Agent", "Mozilla/5.0");
                    conn.setRequestProperty("Accept", "image/png");
                    InputStream connIn = conn.getInputStream();
                    byte[] bytes = connIn.readAllBytes();
                    connIn.close();
                    conn.disconnect();
                    ByteArrayInputStream in = new ByteArrayInputStream(bytes);
                    ByteArrayInputStream imageIn = new ByteArrayInputStream(bytes);
                    NativeImage nativeImage = Image.read(in);
                    ComputerScreen.runLater(() -> {
                        UltreonDevices.LOGGER.debug("Loaded image: {}", (Object)url);
                        this.texture = new DynamicTexture(nativeImage);
                        this.setup = true;
                    });
                }
                catch (IOException | URISyntaxException e) {
                    this.texture = MissingTextureAtlasSprite.getTexture();
                    this.setup = true;
                    UltreonDevices.LOGGER.error("Failed to load image: {}", (Object)this.url, (Object)e);
                }
            };
            Thread thread = new Thread(r, "Image Loader");
            thread.start();
        }

        @Override
        public CachedImage load(Image image) {
            if (CACHE.containsKey(this.url)) {
                CachedImage cachedImage = CACHE.get(this.url);
                image.imageWidth = cachedImage.width;
                image.imageHeight = cachedImage.height;
                return cachedImage;
            }
            try {
                this.texture.load(Minecraft.getInstance().getResourceManager());
                CachedImage cachedImage = new CachedImage(this.texture.getId(), image.imageWidth, image.imageHeight, true);
                if (this.texture != MissingTextureAtlasSprite.getTexture()) {
                    CACHE.put(this.url, cachedImage);
                }
                return cachedImage;
            }
            catch (IOException e) {
                return new CachedImage(MissingTextureAtlasSprite.getTexture().getId(), 0, 0, true);
            }
        }
    }

    public static class CachedImage {
        private final int textureId;
        private final int width;
        private final int height;
        private final boolean dynamic;
        private boolean delete = false;

        private CachedImage(int textureId, int width, int height, boolean dynamic) {
            this.textureId = textureId;
            this.width = width;
            this.height = height;
            this.dynamic = dynamic;
        }

        public int getTextureId() {
            return this.textureId;
        }

        public void restore() {
            this.delete = false;
        }

        public void delete() {
            this.delete = true;
        }

        public boolean isDynamic() {
            return this.dynamic;
        }

        public boolean isPendingDeletion() {
            return this.delete;
        }
    }

    private static class ImageCache
    extends LinkedHashMap<String, CachedImage> {
        private final int CAPACITY;

        private ImageCache(int capacity) {
            super(capacity, 1.0f, true);
            this.CAPACITY = capacity;
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry<String, CachedImage> eldest) {
            if (this.size() > this.CAPACITY) {
                eldest.getValue().delete = true;
                return true;
            }
            return false;
        }
    }

    private static class DynamicLoadedTexture
    extends AbstractTexture {
        private final InputStream in;
        private final BufferedImage image;

        private DynamicLoadedTexture(InputStream in, BufferedImage image) {
            this.in = in;
            this.image = image;
            TextureUtil.prepareImage((int)this.getId(), (int)this.image.getWidth(), (int)this.image.getHeight());
        }

        public void load(@NotNull ResourceManager resourceManager) throws IOException {
            NativeImage nativeImage = Image.read(this.in);
            Minecraft.getInstance().getTextureManager().register(UltreonDevices.res("dynamic_loaded/" + this.getId()), (AbstractTexture)this);
            this.upload(nativeImage);
        }

        private void upload(NativeImage nativeImage) {
            nativeImage.upload(0, 0, 0, this.mipmap);
        }

        public BufferedImage getImage() {
            return this.image;
        }
    }

    public static class AppImage
    extends Layout {
        private final AppInfo appInfo;
        private AppInfo.Icon.Glyph[] glyphs;
        private final int componentWidth;
        private final int componentHeight;

        public AppImage(int left, int top, AppInfo resource) {
            this(left, top, 14, 14, resource);
            this.glyphs = new AppInfo.Icon.Glyph[]{resource.getIcon().getBase(), resource.getIcon().getOverlay0(), resource.getIcon().getOverlay1()};
        }

        public AppImage(int left, int top, int componentWidth, int componentHeight, AppInfo resource) {
            super(left, top, componentWidth, componentHeight);
            this.appInfo = resource;
            AppInfo.Icon icon = resource.getIcon();
            if (icon != null) {
                this.glyphs = new AppInfo.Icon.Glyph[]{icon.getBase(), icon.getOverlay0(), icon.getOverlay1()};
            }
            this.componentWidth = componentWidth;
            this.componentHeight = componentHeight;
        }

        @Override
        public void init(Layout layout) {
            super.init(layout);
            AppInfo.Icon icon = this.appInfo.getIcon();
            if (icon == null || icon.getBase().getU() == -1 && icon.getBase().getV() == -1) {
                Image image = new Image(0, 0, this.componentWidth, this.componentHeight, 0, 0, 14, 14, 224, 224, ComputerScreen.ICON_TEXTURES);
                this.addComponent(image);
                return;
            }
            for (AppInfo.Icon.Glyph glyph : this.glyphs) {
                if (glyph.getU() == -1 || glyph.getV() == -1) continue;
                Image image = new Image(0, 0, this.componentWidth, this.componentHeight, glyph.getU(), glyph.getV(), 14, 14, 224, 224, ComputerScreen.ICON_TEXTURES);
                Supplier<ColorSupplier> suscs = () -> {
                    int tint = this.appInfo.getTint(glyph.getType());
                    Color col = new Color(tint);
                    ColorSupplier cs = new ColorSupplier();
                    cs.r = col.getRed();
                    cs.g = col.getGreen();
                    cs.b = col.getBlue();
                    return cs;
                };
                image.setTint(suscs);
                this.addComponent(image);
            }
        }
    }
}

