/*
 * Decompiled with CFR 0.152.
 */
package dev.ultreon.devices.api.app.component;

import com.mojang.blaze3d.systems.RenderSystem;
import dev.ultreon.devices.api.app.Component;
import dev.ultreon.devices.api.app.listener.ClickListener;
import dev.ultreon.devices.api.utils.RenderUtil;
import dev.ultreon.devices.core.ComputerScreen;
import dev.ultreon.devices.util.GuiHelper;
import java.awt.Color;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;

public class Inventory
extends Component {
    protected static final ResourceLocation CHEST_GUI_TEXTURE = ResourceLocation.parse((String)"textures/gui/container/generic_54.png");
    protected int selectedColor = new Color(1.0f, 1.0f, 0.0f, 0.15f).getRGB();
    protected int hoverColor = new Color(1.0f, 1.0f, 1.0f, 0.15f).getRGB();
    protected int selected = -1;
    protected ClickListener clickListener = null;

    public Inventory(int left, int top) {
        super(left, top);
    }

    @Override
    public void render(GuiGraphics graphics, ComputerScreen computerScreen, Minecraft mc, int x, int y, int mouseX, int mouseY, boolean windowActive, float partialTicks) {
        if (this.visible) {
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)CHEST_GUI_TEXTURE);
            RenderUtil.drawRectWithTexture(CHEST_GUI_TEXTURE, graphics, this.xPosition, this.yPosition, 7.0f, 139.0f, 162, 54, 162.0f, 54.0f);
            assert (mc.player != null);
            net.minecraft.world.entity.player.Inventory inventory = mc.player.getInventory();
            for (int i = 9; i < inventory.getContainerSize() - 4; ++i) {
                ItemStack stack;
                int offsetX = i % 9 * 18;
                int offsetY = i / 9 * 18 - 18;
                if (this.selected == i) {
                    graphics.fill(this.xPosition + offsetX, this.yPosition + offsetY, this.xPosition + offsetX + 18, this.yPosition + offsetY + 18, this.selectedColor);
                }
                if (GuiHelper.isMouseInside(mouseX, mouseY, this.xPosition + offsetX, this.yPosition + offsetY, this.xPosition + offsetX + 17, this.yPosition + offsetY + 17)) {
                    graphics.fill(this.xPosition + offsetX, this.yPosition + offsetY, this.xPosition + offsetX + 18, this.yPosition + offsetY + 18, this.hoverColor);
                }
                if ((stack = inventory.getItem(i)).isEmpty()) continue;
                RenderUtil.renderItem(graphics, this.xPosition + offsetX + 1, this.yPosition + offsetY + 1, stack, true);
            }
        }
    }

    @Override
    public void renderOverlay(GuiGraphics graphics, ComputerScreen computerScreen, Minecraft mc, int mouseX, int mouseY, boolean windowActive) {
        if (this.visible) {
            for (int i = 0; i < 3; ++i) {
                for (int j = 0; j < 9; ++j) {
                    ItemStack stack;
                    int x = this.xPosition + j * 18 - 1;
                    int y = this.yPosition + i * 18 - 1;
                    if (!GuiHelper.isMouseInside(mouseX, mouseY, x, y, x + 18, y + 18)) continue;
                    if (mc.player != null && !(stack = mc.player.getInventory().getItem(i * 9 + j + 9)).isEmpty()) {
                        graphics.renderTooltip(mc.font, stack, mouseX, mouseY);
                    }
                    return;
                }
            }
        }
    }

    @Override
    public void handleMouseClick(int mouseX, int mouseY, int mouseButton) {
        if (!this.visible || !this.enabled) {
            return;
        }
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                int x = this.xPosition + j * 18 - 1;
                int y = this.yPosition + i * 18 - 1;
                if (!GuiHelper.isMouseInside(mouseX, mouseY, x, y, x + 18, y + 18)) continue;
                this.selected = i * 9 + j + 9;
                if (this.clickListener != null) {
                    this.clickListener.onClick(mouseX, mouseY, mouseButton);
                }
                return;
            }
        }
    }

    public int getSelectedSlotIndex() {
        return this.selected;
    }

    public void setClickListener(ClickListener clickListener) {
        this.clickListener = clickListener;
    }

    public void setSelectedColor(int selectedColor) {
        this.selectedColor = selectedColor;
    }

    public void setHoverColor(int hoverColor) {
        this.hoverColor = hoverColor;
    }
}

