/*
 * Decompiled with CFR 0.152.
 */
package dev.ultreon.devices.api.app.component;

import dev.ultreon.devices.api.app.Component;
import dev.ultreon.devices.core.ComputerScreen;
import java.awt.Color;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;

public class Label
extends Component {
    protected String text;
    protected int width;
    protected boolean shadow = true;
    protected double scale = 1.0;
    protected int alignment = 0;
    protected int textColor = Color.WHITE.getRGB();

    public Label(String text, int left, int top) {
        super(left, top);
        this.text = text;
    }

    @Override
    public void render(GuiGraphics graphics, ComputerScreen computerScreen, Minecraft mc, int x, int y, int mouseX, int mouseY, boolean windowActive, float partialTicks) {
        if (this.visible) {
            graphics.pose().pushPose();
            graphics.pose().translate((float)this.xPosition, (float)this.yPosition, 0.0f);
            graphics.pose().scale((float)this.scale, (float)this.scale, (float)this.scale);
            if (this.alignment == 1) {
                graphics.pose().translate((float)((int)(-((double)mc.font.width(this.text) * this.scale))), 0.0f, 0.0f);
            }
            if (this.alignment == 2) {
                graphics.pose().translate((float)((int)(-((double)mc.font.width(this.text) * this.scale)) / (int)(2.0 * this.scale)), 0.0f, 0.0f);
            }
            if (this.shadow) {
                graphics.drawString(mc.font, this.text, 0, 0, this.textColor);
            } else {
                graphics.drawString(mc.font, this.text, 0, 0, this.textColor, false);
            }
            graphics.pose().popPose();
        }
    }

    public void setText(String text) {
        this.text = text;
    }

    public void setTextColor(Color color) {
        this.textColor = color.getRGB();
    }

    public void setShadow(boolean shadow) {
        this.shadow = shadow;
    }

    public void setScale(double scale) {
        this.scale = scale;
    }

    public void setAlignment(int alignment) {
        this.alignment = alignment;
    }
}

