/*
 * Decompiled with CFR 0.152.
 */
package dev.ultreon.devices.api.app.component;

import dev.ultreon.devices.api.app.Component;
import dev.ultreon.devices.core.ComputerScreen;
import java.awt.Color;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;

public class ProgressBar
extends Component {
    protected int barWidth;
    protected int barHeight;
    protected int progress = 0;
    protected int max = 100;
    protected int progressColor = new Color(189, 198, 255).getRGB();
    protected int backgroundColor = Color.DARK_GRAY.getRGB();
    protected int borderColor = Color.BLACK.getRGB();

    public ProgressBar(int left, int top, int width, int height) {
        super(left, top);
        this.barWidth = width;
        this.barHeight = height;
    }

    @Override
    public void render(GuiGraphics graphics, ComputerScreen computerScreen, Minecraft mc, int x, int y, int mouseX, int mouseY, boolean windowActive, float partialTicks) {
        if (this.visible) {
            Color bgColor = new Color(this.getColorScheme().getBackgroundColor(), true);
            graphics.fill(this.xPosition, this.yPosition, this.xPosition + this.barWidth, this.yPosition + this.barHeight, bgColor.darker().darker().getRGB());
            graphics.fill(this.xPosition + 1, this.yPosition + 1, this.xPosition + this.barWidth - 1, this.yPosition + this.barHeight - 1, bgColor.getRGB());
            graphics.fill(this.xPosition + 2, this.yPosition + 2, this.xPosition + 2 + this.getProgressScaled(), this.yPosition + this.barHeight - 2, bgColor.brighter().brighter().getRGB());
        }
    }

    private int getProgressScaled() {
        return (int)Math.ceil((double)(this.barWidth - 4) * ((double)this.progress / (double)this.max));
    }

    public int getProgress() {
        return this.progress;
    }

    public void setProgress(int progress) {
        if (progress > this.max) {
            progress = this.max;
        } else if (progress < 0) {
            progress = 0;
        }
        this.progress = progress;
    }

    public void setMax(int max) {
        if (max > 0) {
            this.max = max;
        }
    }
}

