/*
 * Decompiled with CFR 0.152.
 */
package dev.ultreon.devices.api.app.component;

import com.mojang.blaze3d.systems.RenderSystem;
import dev.ultreon.devices.api.app.Component;
import dev.ultreon.devices.core.ComputerScreen;
import java.awt.Color;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.resources.ResourceLocation;

public class Spinner
extends Component {
    protected final int MAX_PROGRESS = 31;
    protected int currentProgress = 0;
    protected Color spinnerColor = Color.WHITE;

    public Spinner(int left, int top) {
        super(left, top);
    }

    @Override
    public void handleTick() {
        if (this.currentProgress >= 31) {
            this.currentProgress = 0;
        }
        ++this.currentProgress;
    }

    @Override
    public void render(GuiGraphics graphics, ComputerScreen computerScreen, Minecraft mc, int x, int y, int mouseX, int mouseY, boolean windowActive, float partialTicks) {
        if (this.visible) {
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            Color bgColor = new Color(this.getColorScheme().getBackgroundColor()).brighter().brighter();
            float[] hsb = Color.RGBtoHSB(bgColor.getRed(), bgColor.getGreen(), bgColor.getBlue(), null);
            bgColor = new Color(Color.HSBtoRGB(hsb[0], hsb[1], 1.0f));
            RenderSystem.setShaderColor((float)((float)bgColor.getRed() / 255.0f), (float)((float)bgColor.getGreen() / 255.0f), (float)((float)bgColor.getBlue() / 255.0f), (float)1.0f);
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)Component.COMPONENTS_GUI);
            graphics.blit(Component.COMPONENTS_GUI, this.xPosition, this.yPosition, this.currentProgress % 8 * 12, 12 + 12 * (int)Math.floor((double)this.currentProgress / 8.0), 12, 12);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
    }
}

