/*
 * Decompiled with CFR 0.152.
 */
package dev.ultreon.devices.api.app.component;

import dev.ultreon.devices.api.app.Component;
import dev.ultreon.devices.core.ComputerScreen;
import dev.ultreon.devices.util.GuiHelper;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.Style;

public class Text
extends Component {
    protected String rawText;
    protected List<String> lines;
    public int width;
    protected int padding;
    protected boolean shadow = false;
    protected int textColor = Color.WHITE.getRGB();
    private WordListener wordListener = null;

    public Text(String text, int left, int top, int width) {
        super(left, top);
        this.width = width;
        this.setText(text);
    }

    @Override
    public void render(GuiGraphics graphics, ComputerScreen computerScreen, Minecraft mc, int x, int y, int mouseX, int mouseY, boolean windowActive, float partialTicks) {
        if (this.visible) {
            for (int i = 0; i < this.lines.size(); ++i) {
                String text;
                for (text = this.lines.get(i); text != null && text.endsWith("\n"); text = text.substring(0, text.length() - 1)) {
                }
                assert (text != null);
                if (this.shadow) {
                    graphics.drawString(ComputerScreen.getFont(), text, x + this.padding, y + i * 10 + this.padding, this.textColor);
                    continue;
                }
                graphics.drawString(ComputerScreen.getFont(), text, x + this.padding, y + i * 10 + this.padding, this.textColor, false);
            }
        }
    }

    public void setText(String text) {
        this.rawText = text;
        text = text.replace("\\n", "\n");
        ArrayList<String> a = new ArrayList<String>();
        ComputerScreen.getFont().getSplitter().splitLines(FormattedText.of((String)text), this.width - this.padding * 2, Style.EMPTY).forEach(b -> a.add(b.getString()));
        this.lines = a;
    }

    public void setTextColor(Color color) {
        this.textColor = color.getRGB();
    }

    public void setShadow(boolean shadow) {
        this.shadow = shadow;
    }

    public void setPadding(int padding) {
        this.padding = padding;
        this.updateLines();
    }

    private void updateLines() {
        this.setText(this.rawText);
    }

    @Override
    protected void handleMouseClick(int mouseX, int mouseY, int mouseButton) {
        int lineIndex;
        if (GuiHelper.isMouseWithin(mouseX, mouseY, this.xPosition + this.padding, this.yPosition + this.padding, this.width - this.padding * 2, this.getHeight() - this.padding * 2) && this.wordListener != null && !this.lines.isEmpty() && (lineIndex = (mouseY - (this.yPosition + this.padding)) / 10) < this.lines.size()) {
            int index;
            int cursorX = mouseX - (this.xPosition + this.padding);
            String line = this.lines.get(lineIndex);
            String clickedWord = this.getWord(line, index = ComputerScreen.getFont().plainSubstrByWidth(line, cursorX).length());
            if (clickedWord != null) {
                this.wordListener.onWordClicked(clickedWord, mouseButton);
            }
        }
    }

    private String getWord(String line, int index) {
        int startIndex;
        if (index >= line.length() || line.charAt(index) == ' ') {
            return null;
        }
        for (startIndex = index; startIndex > 0 && line.charAt(startIndex - 1) != ' '; --startIndex) {
        }
        int endIndex = index;
        while (endIndex + 1 < line.length() && line.charAt(endIndex + 1) != ' ') {
            ++endIndex;
        }
        endIndex = Math.min(endIndex + 1, line.length());
        return ChatFormatting.stripFormatting((String)line.substring(startIndex, endIndex));
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        int n = this.lines.size();
        Objects.requireNonNull(Minecraft.getInstance().font);
        return n * 9 + this.lines.size() - 1 + this.padding * 2;
    }

    public void setWordListener(WordListener wordListener) {
        this.wordListener = wordListener;
    }

    public boolean hasWordListener() {
        return this.wordListener != null;
    }

    public static interface WordListener {
        public void onWordClicked(String var1, int var2);
    }
}

