/*
 * Decompiled with CFR 0.152.
 */
package dev.ultreon.devices.api.app.component;

import com.mojang.blaze3d.systems.RenderSystem;
import dev.ultreon.devices.api.app.IIcon;
import dev.ultreon.devices.api.app.component.TextArea;
import dev.ultreon.devices.core.ComputerScreen;
import java.awt.Color;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;

public class TextField
extends TextArea {
    private IIcon icon;

    public TextField(int left, int top, int width) {
        super(left, top, width, 16);
        this.setScrollBarVisible(false);
        this.setMaxLines(1);
    }

    @Override
    public void render(GuiGraphics graphics, ComputerScreen computerScreen, Minecraft mc, int x, int y, int mouseX, int mouseY, boolean windowActive, float partialTicks) {
        if (this.icon != null) {
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            Color bgColor = new Color(TextField.color(this.backgroundColor, this.getColorScheme().getBackgroundColor()));
            graphics.fill(x, y, x + 15, y + 16, bgColor.darker().darker().getRGB());
            graphics.fill(x + 1, y + 1, x + 15, y + 15, bgColor.brighter().getRGB());
            this.icon.draw(graphics, mc, x + 3, y + 3);
        }
        super.render(graphics, computerScreen, mc, x + (this.icon != null ? 15 : 0), y, mouseX, mouseY, windowActive, partialTicks);
    }

    @Override
    public void handleMouseClick(int mouseX, int mouseY, int mouseButton) {
        super.handleMouseClick(mouseX - (this.icon != null ? 15 : 0), mouseY, mouseButton);
    }

    @Override
    protected void handleMouseDrag(int mouseX, int mouseY, int mouseButton) {
        super.handleMouseDrag(mouseX - (this.icon != null ? 15 : 0), mouseY, mouseButton);
    }

    @Override
    protected void handleMouseRelease(int mouseX, int mouseY, int mouseButton) {
        super.handleMouseRelease(mouseX - (this.icon != null ? 15 : 0), mouseY, mouseButton);
    }

    public void setIcon(IIcon icon) {
        if (this.icon == null) {
            this.width -= 15;
        } else if (icon == null) {
            this.width += 15;
        }
        this.icon = icon;
    }
}

