/*
 * Decompiled with CFR 0.152.
 */
package dev.ultreon.devices.api.io;

import dev.ultreon.devices.api.app.Application;
import dev.ultreon.devices.api.io.Drive;
import dev.ultreon.devices.api.io.Folder;
import dev.ultreon.devices.api.task.Callback;
import dev.ultreon.devices.core.DataPath;
import dev.ultreon.devices.core.io.FileSystem;
import dev.ultreon.devices.core.io.Path;
import dev.ultreon.devices.core.io.action.FileAction;
import dev.ultreon.devices.programs.system.component.FileBrowser;
import java.io.IOException;
import java.util.Comparator;
import java.util.Objects;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import org.jetbrains.annotations.Nullable;

@Deprecated
public class File {
    @Deprecated
    public static final Comparator<File> SORT_BY_NAME = (f1, f2) -> {
        if (f1.isFolder() && !f2.isFolder()) {
            return -1;
        }
        if (!f1.isFolder() && f2.isFolder()) {
            return 1;
        }
        return f1.name.compareTo(f2.name);
    };
    protected Drive drive;
    protected Folder parent;
    protected String name;
    protected String openingApp;
    protected CompoundTag data;
    protected boolean protect = false;
    protected boolean valid = false;

    protected File() {
    }

    @Deprecated
    public File(String name, Application app, CompoundTag data) {
        this(name, app.getInfo().getFormattedId(), data, false);
    }

    @Deprecated
    public File(String name, String openingAppId, CompoundTag data) {
        this(name, openingAppId, data, false);
    }

    private File(String name, String openingAppId, CompoundTag data, boolean protect) {
        this.name = name;
        this.openingApp = openingAppId;
        this.data = data;
        this.protect = protect;
    }

    @Deprecated
    public String getName() {
        return this.name;
    }

    @Deprecated
    public void rename(String name) {
        this.rename(name, null);
    }

    @Deprecated
    public void rename(String name, @Nullable Callback<FileSystem.Response> callback) {
    }

    @Deprecated
    public String getPath() {
        if (this.parent == null) {
            return "/";
        }
        StringBuilder builder = new StringBuilder();
        for (File current = this; current != null && current.getParent() != null; current = current.getParent()) {
            builder.insert(0, "/" + current.getName());
        }
        return builder.toString();
    }

    @Deprecated
    public String getLocation() {
        if (this.parent == null) {
            throw new NullPointerException("File must have a parent to compile the directory");
        }
        StringBuilder builder = new StringBuilder();
        for (Folder current = this.parent; current != null && current.getParent() != null; current = current.getParent()) {
            builder.insert(0, "/" + current.getName());
        }
        return builder.toString();
    }

    @Deprecated
    @Nullable
    public String getOpeningApp() {
        return this.openingApp;
    }

    @Deprecated
    public void setData(CompoundTag data) {
        this.setData(data, null);
    }

    @Deprecated
    public void setData(CompoundTag data, @Nullable Callback<FileSystem.Response> callback) {
        block7: {
            if (!this.valid) {
                throw new IllegalStateException("File must be added to the system before you can rename it");
            }
            if (this.protect) {
                if (callback != null) {
                    callback.execute(FileSystem.createResponse(3, "Cannot set data on a protected file"), false);
                }
                return;
            }
            if (data == null) {
                if (callback != null) {
                    callback.execute(FileSystem.createResponse(6, "Invalid data"), false);
                }
                return;
            }
            try {
                FileSystem.sendAction(this.drive.getUUID(), FileAction.Factory.makeData(Path.of(this.getPath()), data), (response, success) -> {
                    if (success) {
                        this.data = data.copy();
                    }
                    if (callback != null) {
                        callback.execute((FileSystem.Response)response, success);
                    }
                });
            }
            catch (IOException e) {
                if (callback == null) break block7;
                callback.execute(FileSystem.createResponse(0, "Unknown error occurred"), false);
            }
        }
    }

    @Deprecated
    @Nullable
    public CompoundTag getData() {
        return this.data.copy();
    }

    @Deprecated
    public byte[] getDataBytes() {
        byte[] bytes = new byte[this.data.getByteArray("data").length];
        System.arraycopy(this.data.getByteArray("data"), 0, bytes, 0, bytes.length);
        return bytes;
    }

    @Deprecated
    @Nullable
    public Folder getParent() {
        return this.parent;
    }

    @Deprecated
    public Drive getDrive() {
        return this.drive;
    }

    void setDrive(Drive drive) {
        this.drive = drive;
    }

    @Deprecated
    public boolean isProtected() {
        return this.protect;
    }

    @Deprecated
    public boolean isFolder() {
        return false;
    }

    @Deprecated
    public boolean isForApplication(Application app) {
        return this.openingApp != null && this.openingApp.equals(app.getInfo().getFormattedId());
    }

    @Deprecated
    public void delete() {
        this.delete(null);
    }

    @Deprecated
    public void delete(@Nullable Callback<FileSystem.Response> callback) {
        if (!this.valid) {
            throw new IllegalStateException("File must be added to the system before you can rename it");
        }
        if (this.protect) {
            if (callback != null) {
                callback.execute(FileSystem.createResponse(3, "Cannot delete a protected file"), false);
            }
            return;
        }
        if (this.parent != null) {
            this.parent.delete(this, callback);
        }
    }

    @Deprecated
    public void copyTo(Folder destination, boolean override, @Nullable Callback<FileSystem.Response> callback) {
        if (destination == null) {
            if (callback != null) {
                callback.execute(FileSystem.createResponse(2, "Illegal folder"), false);
            }
            return;
        }
        if (!destination.valid || destination.drive == null) {
            if (callback != null) {
                callback.execute(FileSystem.createResponse(2, "Destination folder is invalid"), false);
            }
            return;
        }
        if (!this.valid || this.drive == null) {
            if (callback != null) {
                callback.execute(FileSystem.createResponse(2, "Source file is invalid"), false);
            }
            return;
        }
        if (destination.hasFile(this.name)) {
            if (!override) {
                if (callback != null) {
                    callback.execute(FileSystem.createResponse(4, "A file with that name already exists"), false);
                }
                return;
            }
            if (Objects.requireNonNull(destination.getFile(this.name)).isProtected()) {
                if (callback != null) {
                    callback.execute(FileSystem.createResponse(3, "Unable to override protected files"), false);
                }
                return;
            }
        }
        FileSystem.sendAction(this.drive.getUUID(), FileAction.Factory.makeCopy(Path.of(this.getPath()), Path.of(destination.getPath()), override), (response, success) -> {
            assert (response != null);
            if (response.getStatus() == 1) {
                if (override) {
                    destination.files.remove(destination.getFile(this.name));
                }
                File file = this.copy();
                file.valid = true;
                file.parent = destination;
                file.setDrive(destination.drive);
                destination.files.add(file);
                FileBrowser.refreshList = true;
            }
            if (callback != null) {
                callback.execute((FileSystem.Response)response, success);
            }
        });
    }

    @Deprecated
    public void moveTo(Folder destination, boolean override, @Nullable Callback<FileSystem.Response> callback) {
        if (destination == null) {
            if (callback != null) {
                callback.execute(FileSystem.createResponse(2, "Illegal folder"), false);
            }
            return;
        }
        if (!destination.valid || destination.drive == null) {
            if (callback != null) {
                callback.execute(FileSystem.createResponse(2, "Destination folder is invalid"), false);
            }
            return;
        }
        if (!this.valid || this.drive == null) {
            if (callback != null) {
                callback.execute(FileSystem.createResponse(2, "Source file is invalid"), false);
            }
            return;
        }
        if (this.equals(destination.getFile(this.name))) {
            if (callback != null) {
                callback.execute(FileSystem.createSuccessResponse(), false);
            }
            return;
        }
        if (destination.hasFile(this.name)) {
            if (!override) {
                if (callback != null) {
                    callback.execute(FileSystem.createResponse(4, "A file with that name already exists"), false);
                }
                return;
            }
            if (Objects.requireNonNull(destination.getFile(this.name)).isProtected()) {
                if (callback != null) {
                    callback.execute(FileSystem.createResponse(3, "Unable to override protected files"), false);
                }
                return;
            }
        }
        FileSystem.sendAction(this.drive.getUUID(), FileAction.Factory.makeCopyCut(Path.of(this.getPath()), new DataPath(destination.drive.getUUID(), Path.of(destination.getPath())), override, true), (response, success) -> {
            assert (response != null);
            if (response.getStatus() == 1) {
                if (override) {
                    destination.files.remove(destination.getFile(this.name));
                }
                this.parent.files.remove(this);
                this.setDrive(destination.drive);
                this.parent = destination;
                destination.files.add(this);
                FileBrowser.refreshList = true;
            }
            if (callback != null) {
                callback.execute((FileSystem.Response)response, success);
            }
        });
    }

    @Deprecated
    public CompoundTag toTag() {
        CompoundTag tag = new CompoundTag();
        tag.putString("openingApp", this.openingApp);
        tag.put("data", (Tag)this.data);
        return tag;
    }

    @Deprecated
    public static File fromTag(String name, CompoundTag tag) {
        return new File(name, tag.getString("openingApp"), tag.getCompound("data"));
    }

    @Deprecated
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof File)) {
            return false;
        }
        File file = (File)obj;
        return this.parent == file.parent && this.name.equalsIgnoreCase(file.name);
    }

    @Deprecated
    public File copy() {
        return new File(this.name, this.openingApp, this.data.copy());
    }

    @Deprecated
    public File copy(String newName) {
        return new File(newName, this.openingApp, this.data.copy());
    }
}

