/*
 * Decompiled with CFR 0.152.
 */
package dev.ultreon.devices.api.print;

import com.mojang.blaze3d.vertex.PoseStack;
import dev.ultreon.devices.api.print.PrintingManager;
import dev.ultreon.devices.init.DeviceBlocks;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.Nullable;

public interface IPrint {
    public static CompoundTag save(IPrint print) {
        CompoundTag tag = new CompoundTag();
        tag.putString("type", PrintingManager.getPrintIdentifier(print));
        tag.put("data", (Tag)print.toTag());
        return tag;
    }

    @Nullable
    public static IPrint load(CompoundTag tag) {
        IPrint print = PrintingManager.getPrint(tag.getString("type"));
        if (print != null) {
            print.fromTag(tag.getCompound("data"));
            return print;
        }
        return null;
    }

    public static ItemStack generateItem(IPrint print) {
        CompoundTag blockEntityTag = new CompoundTag();
        blockEntityTag.put("print", (Tag)IPrint.save(print));
        CompoundTag itemTag = new CompoundTag();
        itemTag.put("BlockEntityTag", (Tag)blockEntityTag);
        ItemStack stack = new ItemStack((ItemLike)DeviceBlocks.PAPER.get());
        stack.set(DataComponents.CUSTOM_DATA, (Object)CustomData.of((CompoundTag)itemTag));
        if (print.getName() != null && !print.getName().isEmpty()) {
            stack.set(DataComponents.CUSTOM_NAME, (Object)Component.literal((String)print.getName()));
        }
        return stack;
    }

    public String getName();

    public int speed();

    public boolean requiresColor();

    public CompoundTag toTag();

    public void fromTag(CompoundTag var1);

    public Class<? extends Renderer> getRenderer();

    public static interface Renderer {
        public boolean render(PoseStack var1, CompoundTag var2);
    }
}

