/*
 * Decompiled with CFR 0.152.
 */
package dev.ultreon.devices.api.print;

import com.google.common.collect.HashBiMap;
import dev.ultreon.devices.UltreonDevices;
import dev.ultreon.devices.api.print.IPrint;
import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.Nullable;

public class PrintingManager {
    private static final HashBiMap<String, Class<? extends IPrint>> registeredPrints = HashBiMap.create();
    private static Map<String, IPrint.Renderer> registeredRenders;

    public static Map<String, IPrint.Renderer> getRegisteredRenders() {
        return registeredRenders;
    }

    public static void setRegisteredRenders(Map<String, IPrint.Renderer> registeredRenders) {
        PrintingManager.registeredRenders = registeredRenders;
    }

    public static void registerPrint(ResourceLocation identifier, Class<? extends IPrint> classPrint) {
        try {
            classPrint.getConstructor(new Class[0]).newInstance(new Object[0]);
            if (UltreonDevices.getInstance().registerPrint(identifier, classPrint)) {
                UltreonDevices.LOGGER.info("Registering print '{}'", (Object)classPrint.getName());
                registeredPrints.put((Object)identifier.toString(), classPrint);
            } else {
                UltreonDevices.LOGGER.error("The print '{}' could not be registered due to a critical error!", (Object)classPrint.getName());
            }
        }
        catch (NoSuchMethodException e) {
            UltreonDevices.LOGGER.error("The print '{}' is missing an empty constructor and could not be registered!", (Object)classPrint.getName());
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            UltreonDevices.LOGGER.error("The print '{}' could not be registered due to a critical error!", (Object)classPrint.getName());
        }
    }

    public static boolean isRegisteredPrint(Class<? extends IPrint> clazz) {
        return registeredPrints.containsValue(clazz);
    }

    @Nullable
    public static IPrint getPrint(String identifier) {
        Class clazz = (Class)registeredPrints.get((Object)identifier);
        if (clazz != null) {
            try {
                return (IPrint)clazz.newInstance();
            }
            catch (IllegalAccessException | InstantiationException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public static IPrint.Renderer getRenderer(IPrint print) {
        String id = PrintingManager.getPrintIdentifier(print);
        return registeredRenders.get(id);
    }

    public static IPrint.Renderer getRenderer(String identifier) {
        return registeredRenders.get(identifier);
    }

    public static String getPrintIdentifier(IPrint print) {
        return (String)registeredPrints.inverse().get(print.getClass());
    }
}

