/*
 * Decompiled with CFR 0.152.
 */
package dev.ultreon.devices.api.task;

import dev.ultreon.devices.api.task.Callback;
import dev.ultreon.devices.api.task.TaskManager;
import dev.ultreon.devices.core.task.TaskInstallApp;
import dev.ultreon.devices.debug.DebugLog;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;

public abstract class Task {
    private Callback<CompoundTag> callback = null;
    private boolean success = false;

    public final Task setCallback(Callback<CompoundTag> callback) {
        this.callback = callback;
        return this;
    }

    public final void callback(CompoundTag tag) {
        if (this.callback != null) {
            this.callback.execute(tag, this.success);
        }
    }

    public final void setSuccessful() {
        if (this instanceof TaskInstallApp) {
            DebugLog.log("Setting successful...");
        }
        this.success = true;
    }

    public final boolean isSuccessful() {
        return this.success;
    }

    public final String getName() {
        return TaskManager.getTaskName(this);
    }

    public abstract void prepareRequest(HolderLookup.Provider var1, CompoundTag var2);

    public abstract void processRequest(HolderLookup.Provider var1, CompoundTag var2, Level var3, Player var4);

    public abstract void prepareResponse(HolderLookup.Provider var1, CompoundTag var2);

    public abstract void processResponse(HolderLookup.Provider var1, CompoundTag var2);

    public void setName(String name) {
    }
}

