/*
 * Decompiled with CFR 0.152.
 */
package dev.ultreon.devices.api.task;

import dev.ultreon.devices.UltreonDevices;
import dev.ultreon.devices.api.task.Task;
import dev.ultreon.devices.network.PacketHandler;
import dev.ultreon.devices.network.task.RequestPacket;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;

public final class TaskManager {
    private static TaskManager instance = null;
    private final Map<Class<?>, String> taskTypeMap = new HashMap();
    private final Map<String, Supplier<Task>> registeredRequests = new HashMap<String, Supplier<Task>>();
    private final Map<Integer, Task> requests = new ConcurrentHashMap<Integer, Task>();
    private int currentId = 0;

    private TaskManager() {
    }

    private static TaskManager get() {
        if (instance == null) {
            instance = new TaskManager();
        }
        return instance;
    }

    public static void registerTask(String name, Supplier<Task> factory, Class<? extends Task> type) {
        try {
            if (TaskManager.get().registeredRequests.containsKey(name)) {
                throw new RuntimeException("Task '" + name + "' is already registered!");
            }
            UltreonDevices.LOGGER.info("Registering task '{}'", (Object)name);
            TaskManager.get().registeredRequests.put(name, factory);
            TaskManager.get().taskTypeMap.put(type, name);
        }
        catch (Exception e) {
            UltreonDevices.LOGGER.error("Failed to register task:", (Throwable)e);
        }
    }

    public static void sendTask(Task task) {
        int requestId;
        TaskManager manager = TaskManager.get();
        String key = TaskManager.get().taskTypeMap.get(task.getClass());
        if (key == null) {
            throw new RuntimeException("Unregistered Task: " + task.getClass().getName() + ". Use TaskManager#registerTask to register your task.");
        }
        if (!manager.registeredRequests.containsKey(key)) {
            throw new RuntimeException("Unregistered Task: " + task.getClass().getName() + ". Use TaskManager#requestRequest to register your task.");
        }
        if (manager.requests.containsKey(requestId = manager.currentId++)) {
            UltreonDevices.LOGGER.warn("Request ID collision! Request ID: {}", (Object)requestId, (Object)new Throwable());
        }
        manager.requests.put(requestId, task);
        if (Minecraft.getInstance().getConnection() != null) {
            PacketHandler.sendToServer(new RequestPacket(requestId, task));
        }
    }

    public static Supplier<Task> getTask(String name) {
        return TaskManager.get().registeredRequests.get(name);
    }

    public static Task getTaskAndRemove(int id) {
        return TaskManager.get().requests.remove(id);
    }

    public static String getTaskName(Task task) {
        return TaskManager.get().taskTypeMap.get(task.getClass());
    }
}

