/*
 * Decompiled with CFR 0.152.
 */
package dev.ultreon.devices.api.utils;

import dev.ultreon.devices.api.WorldSavedData;
import dev.ultreon.devices.api.task.Callback;
import dev.ultreon.devices.api.task.TaskManager;
import dev.ultreon.devices.programs.system.object.Account;
import dev.ultreon.devices.programs.system.task.TaskAdd;
import dev.ultreon.devices.programs.system.task.TaskGetBalance;
import dev.ultreon.devices.programs.system.task.TaskPay;
import dev.ultreon.devices.programs.system.task.TaskRemove;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.player.Player;

public class BankUtil
implements WorldSavedData {
    public static final BankUtil INSTANCE = new BankUtil();
    private final Map<UUID, Account> uuidToAccount = new HashMap<UUID, Account>();

    private BankUtil() {
    }

    public static void getBalance(Callback<CompoundTag> callback) {
        TaskManager.sendTask(new TaskGetBalance().setCallback(callback));
    }

    public static void pay(String uuid, int amount, Callback<CompoundTag> callback) {
        TaskManager.sendTask(new TaskPay().setCallback(callback));
    }

    public static void add(int amount, Callback<CompoundTag> callback) {
        TaskManager.sendTask(new TaskAdd(amount).setCallback(callback));
    }

    public static void remove(int amount, Callback<CompoundTag> callback) {
        TaskManager.sendTask(new TaskRemove(amount).setCallback(callback));
    }

    public Account getAccount(Player player) {
        if (!this.uuidToAccount.containsKey(player.getUUID())) {
            this.uuidToAccount.put(player.getUUID(), new Account(0));
        }
        return this.uuidToAccount.get(player.getUUID());
    }

    public Account getAccount(UUID uuid) {
        return this.uuidToAccount.get(uuid);
    }

    @Override
    public void save(CompoundTag tag) {
        ListTag accountList = new ListTag();
        for (UUID uuid : this.uuidToAccount.keySet()) {
            CompoundTag accountTag = new CompoundTag();
            Account account = this.uuidToAccount.get(uuid);
            accountTag.putString("uuid", uuid.toString());
            accountTag.putInt("balance", account.getBalance());
            accountList.add((Object)accountTag);
        }
        tag.put("accounts", (Tag)accountList);
    }

    @Override
    public void load(CompoundTag tag) {
        ListTag accountList = (ListTag)tag.get("accounts");
        for (int i = 0; i < accountList.size(); ++i) {
            CompoundTag accountTag = accountList.getCompound(i);
            UUID uuid = UUID.fromString(accountTag.getString("uuid"));
            Account account = new Account(accountTag.getInt("balance"));
            this.uuidToAccount.put(uuid, account);
        }
    }
}

