/*
 * Decompiled with CFR 0.152.
 */
package dev.ultreon.devices.api.utils;

import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import dev.ultreon.devices.core.ComputerScreen;
import dev.ultreon.devices.object.AppInfo;
import java.awt.Color;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix3f;
import org.joml.Matrix4f;

public class RenderUtil {
    public static void renderItem(GuiGraphics graphics, int x, int y, ItemStack stack, boolean overlay) {
        RenderSystem.disableDepthTest();
        Lighting.setupForFlatItems();
        PoseStack.Pose last = graphics.pose().last();
        Matrix4f _4d = last.pose();
        Matrix3f _3d = last.normal();
        graphics.pose().setIdentity();
        graphics.renderItem(stack, x, y);
        if (overlay) {
            graphics.renderItemDecorations(Minecraft.getInstance().font, stack, x, y);
        }
        graphics.pose().last().pose().normal(_4d);
        graphics.pose().last().normal().normal(_3d);
    }

    public static void drawIcon(GuiGraphics graphics, double x, double y, AppInfo info, int width, int height) {
        if (info == null || info.getIcon().getBase().getU() == -1 && info.getIcon().getBase().getV() == -1) {
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)ComputerScreen.ICON_TEXTURES);
            RenderUtil.drawRectWithTexture(ComputerScreen.ICON_TEXTURES, graphics, x, y, 0.0f, 0.0f, width, height, 14.0f, 14.0f, 224, 224);
            return;
        }
        RenderSystem.enableBlend();
        AppInfo.Icon.Glyph[] glyphs = new AppInfo.Icon.Glyph[]{info.getIcon().getBase(), info.getIcon().getOverlay0(), info.getIcon().getOverlay1()};
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)ComputerScreen.ICON_TEXTURES);
        for (AppInfo.Icon.Glyph glyph : glyphs) {
            if (glyph.getU() == -1 || glyph.getV() == -1) continue;
            Color col = new Color(info.getTint(glyph.getType()));
            int[] tint = new int[]{col.getRed(), col.getGreen(), col.getBlue()};
            RenderSystem.setShaderColor((float)((float)tint[0] / 255.0f), (float)((float)tint[1] / 255.0f), (float)((float)tint[2] / 255.0f), (float)1.0f);
            RenderUtil.drawRectWithTexture(ComputerScreen.ICON_TEXTURES, graphics, x, y, (float)glyph.getU(), (float)glyph.getV(), width, height, 14.0f, 14.0f, 224, 224);
        }
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public static void drawRectWithTexture(ResourceLocation location, GuiGraphics graphics, double x, double y, float u, float v, int width, int height, float textureWidth, float textureHeight) {
        RenderUtil.drawRectWithTexture(location, graphics, x, y, 0.0, u, v, width, height, textureWidth, textureHeight);
    }

    public static void drawRectWithTexture(ResourceLocation location, GuiGraphics graphics, double x, double y, double z, float u, float v, int width, int height, float textureWidth, float textureHeight) {
        RenderUtil.drawRectWithTexture(location, graphics.pose(), x, y, z, u, v, width, height, textureWidth, textureHeight);
    }

    public static void drawRectWithTexture(ResourceLocation location, PoseStack pose, double x, double y, double z, float u, float v, int width, int height, float textureWidth, float textureHeight) {
        float scale = 0.00390625f;
        Matrix4f e = pose.last().pose();
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        BufferBuilder buffer = Tesselator.getInstance().begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX);
        buffer.addVertex(e, (float)x, (float)(y + (double)height), (float)z).setUv(u * scale, (v + textureHeight) * scale);
        buffer.addVertex(e, (float)(x + (double)width), (float)(y + (double)height), (float)z).setUv((u + textureWidth) * scale, (v + textureHeight) * scale);
        buffer.addVertex(e, (float)(x + (double)width), (float)y, (float)z).setUv((u + textureWidth) * scale, v * scale);
        buffer.addVertex(e, (float)x, (float)y, (float)z).setUv(u * scale, v * scale);
        BufferUploader.drawWithShader((MeshData)buffer.buildOrThrow());
    }

    public static void drawRectWithFullTexture(GuiGraphics graphics, double x, double y, float u, float v, int width, int height) {
        Matrix4f e = graphics.pose().last().pose();
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        BufferBuilder buffer = Tesselator.getInstance().begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX);
        buffer.addVertex(e, (float)x, (float)(y + (double)height), 0.0f).setUv(0.0f, 1.0f);
        buffer.addVertex(e, (float)(x + (double)width), (float)(y + (double)height), 0.0f).setUv(1.0f, 1.0f);
        buffer.addVertex(e, (float)(x + (double)width), (float)y, 0.0f).setUv(1.0f, 0.0f);
        buffer.addVertex(e, (float)x, (float)y, 0.0f).setUv(0.0f, 0.0f);
        BufferUploader.drawWithShader((MeshData)Objects.requireNonNull(buffer.build()));
    }

    public static void drawRectWithTexture(ResourceLocation location, GuiGraphics graphics, double x, double y, float u, float v, int width, int height, float textureWidth, float textureHeight, int sourceWidth, int sourceHeight) {
        RenderUtil.drawRectWithTexture(location, graphics.pose(), x, y, u, v, width, height, textureWidth, textureHeight, sourceWidth, sourceHeight);
    }

    public static void drawRectWithTexture(ResourceLocation location, PoseStack pose, double x, double y, float u, float v, int width, int height, float textureWidth, float textureHeight, int sourceWidth, int sourceHeight) {
        float scaleWidth = 1.0f / (float)sourceWidth;
        float scaleHeight = 1.0f / (float)sourceHeight;
        Matrix4f e = pose.last().pose();
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        BufferBuilder buffer = Tesselator.getInstance().begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX);
        buffer.addVertex(e, (float)x, (float)(y + (double)height), 0.0f).setUv(u * scaleWidth, (v + textureHeight) * scaleHeight);
        buffer.addVertex(e, (float)(x + (double)width), (float)(y + (double)height), 0.0f).setUv((u + textureWidth) * scaleWidth, (v + textureHeight) * scaleHeight);
        buffer.addVertex(e, (float)(x + (double)width), (float)y, 0.0f).setUv((u + textureWidth) * scaleWidth, v * scaleHeight);
        buffer.addVertex(e, (float)x, (float)y, 0.0f).setUv(u * scaleWidth, v * scaleHeight);
        BufferUploader.drawWithShader((MeshData)buffer.buildOrThrow());
    }

    public static void drawApplicationIcon(GuiGraphics graphics, @Nullable AppInfo info, double x, double y) {
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)ComputerScreen.ICON_TEXTURES);
        if (info != null) {
            RenderUtil.drawIcon(graphics, x, y, info, 14, 14);
        } else {
            RenderUtil.drawRectWithTexture(ComputerScreen.ICON_TEXTURES, graphics, x, y, 0.0f, 0.0f, 14, 14, 14.0f, 14.0f, 224, 224);
        }
    }

    public static void drawStringClipped(GuiGraphics graphics, String text, int x, int y, int width, int color, boolean shadow) {
        if (shadow) {
            graphics.drawString(ComputerScreen.getFont(), RenderUtil.clipStringToWidth(text, width) + String.valueOf(ChatFormatting.RESET), x, y, color);
        } else {
            graphics.drawString(ComputerScreen.getFont(), ComputerScreen.getFont().plainSubstrByWidth(text, width) + String.valueOf(ChatFormatting.RESET), x, y, color, false);
        }
    }

    public static String clipStringToWidth(String text, int width) {
        Object clipped;
        Font fontRenderer = ComputerScreen.getFont();
        if (fontRenderer.width((String)(clipped = text)) > width) {
            clipped = fontRenderer.plainSubstrByWidth((String)clipped, width - 8) + "...";
        }
        return clipped;
    }

    public static boolean isMouseInside(int mouseX, int mouseY, int x1, int y1, int x2, int y2) {
        return mouseX >= x1 && mouseX <= x2 && mouseY >= y1 && mouseY <= y2;
    }

    public static int color(int color, int defaultColor) {
        return color > 0 ? color : defaultColor;
    }
}

