/*
 * Decompiled with CFR 0.152.
 */
package dev.ultreon.devices.api.video;

import com.mojang.blaze3d.platform.Window;
import dev.ultreon.devices.core.ComputerScreen;
import dev.ultreon.devices.programs.system.DisplayResolution;
import dev.ultreon.devices.programs.system.PredefinedResolution;
import java.util.Arrays;
import java.util.Collection;
import net.minecraft.client.Minecraft;
import net.minecraft.nbt.CompoundTag;

public class VideoInfo {
    private DisplayResolution resolution = PredefinedResolution.PREDEFINED_384x216;

    public VideoInfo(CompoundTag videoInfoData) {
        if (videoInfoData.contains("resolution")) {
            this.resolution = DisplayResolution.load(videoInfoData.getCompound("resolution"));
        }
    }

    public Collection<PredefinedResolution> getResolutionList() {
        Window window = Minecraft.getInstance().getWindow();
        return Arrays.stream(PredefinedResolution.values()).filter(r -> r.width() <= window.getGuiScaledWidth() && r.height() <= window.getGuiScaledHeight()).toList();
    }

    public void setResolution(DisplayResolution value) {
        this.resolution = value;
        ComputerScreen.getInstance().revalidateDisplay();
    }

    public DisplayResolution getResolution() {
        return this.resolution;
    }

    public void save(CompoundTag tag) {
        if (this.resolution != null) {
            this.resolution.save(tag);
        }
    }
}

