/*
 * Decompiled with CFR 0.152.
 */
package dev.ultreon.devices.block;

import dev.ultreon.devices.DeviceType;
import dev.ultreon.devices.block.ClientLaptopWrapper;
import dev.ultreon.devices.block.ColoredBlock;
import dev.ultreon.devices.block.DeviceBlock;
import dev.ultreon.devices.block.entity.computer.LaptopBlockEntity;
import dev.ultreon.devices.debug.DebugLog;
import dev.ultreon.devices.item.FlashDriveItem;
import dev.ultreon.devices.util.BlockEntityUtil;
import dev.ultreon.devices.util.Colorable;
import dev.ultreon.mods.xinexlib.Env;
import dev.ultreon.mods.xinexlib.EnvExecutor;
import java.util.Locale;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ComputerBlock
extends DeviceBlock {
    public ComputerBlock(BlockBehaviour.Properties properties) {
        super(properties, DeviceType.COMPUTER);
    }

    @NotNull
    public InteractionResult useWithoutItem(@NotNull BlockState state, Level level, @NotNull BlockPos pos, @NotNull Player player, @NotNull BlockHitResult hitResult) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof LaptopBlockEntity) {
            LaptopBlockEntity laptop = (LaptopBlockEntity)blockEntity;
            if (player.isCrouching()) {
                if (!level.isClientSide) {
                    laptop.openClose((Entity)player);
                }
                return InteractionResult.SUCCESS;
            }
            if (laptop.isOpen()) {
                if (level.isClientSide) {
                    EnvExecutor.runInEnv((Env)Env.CLIENT, () -> () -> ClientLaptopWrapper.execute(laptop));
                }
                return InteractionResult.sidedSuccess((boolean)level.isClientSide);
            }
        }
        return InteractionResult.PASS;
    }

    @NotNull
    protected ItemInteractionResult useItemOn(@NotNull ItemStack stack, @NotNull BlockState state, Level level, @NotNull BlockPos pos, @NotNull Player player, @NotNull InteractionHand hand, @NotNull BlockHitResult hitResult) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (!(blockEntity instanceof LaptopBlockEntity)) {
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        LaptopBlockEntity laptop = (LaptopBlockEntity)blockEntity;
        if (hitResult.getDirection() != ((Direction)state.getValue((Property)FACING)).getClockWise(Direction.Axis.Y)) {
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        ItemStack heldItem = player.getItemInHand(hand);
        if (!heldItem.isEmpty() && heldItem.getItem() instanceof FlashDriveItem && laptop.canChangeAttachment()) {
            if (laptop.getFileSystem().attachDrive(heldItem.copy())) {
                DebugLog.logTime(level.getGameTime(), "Attached Drive");
                laptop.setAttachmentCooldown(10);
                heldItem.shrink(1);
                return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide);
            }
            return ItemInteractionResult.FAIL;
        }
        if (!laptop.canChangeAttachment()) {
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        ItemStack detachedDrive = laptop.getFileSystem().detachDrive();
        if (detachedDrive == null) {
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        DebugLog.logTime(level.getGameTime(), "Detached Drive");
        laptop.setAttachmentCooldown(10);
        BlockPos summonPos = pos.relative(((Direction)state.getValue((Property)FACING)).getClockWise(Direction.Axis.Y));
        level.addFreshEntity((Entity)new ItemEntity(level, (double)summonPos.getX() + 0.5, (double)summonPos.getY(), (double)summonPos.getZ() + 0.5, detachedDrive));
        BlockEntityUtil.markBlockForUpdate(level, pos);
        return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide);
    }

    public abstract boolean isDesktopPC();

    public boolean isLaptop() {
        return !this.isDesktopPC();
    }

    @Override
    protected void removeTagsForDrop(CompoundTag tileEntityTag) {
        tileEntityTag.remove("open");
    }

    protected void createBlockStateDefinition(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull StateDefinition.Builder<Block, BlockState> pBuilder) {
        super.createBlockStateDefinition(pBuilder);
        pBuilder.add(new Property[]{FACING});
    }

    public static abstract class Colored
    extends ComputerBlock
    implements ColoredBlock {
        private final DyeColor color;

        protected Colored(BlockBehaviour.Properties properties, DyeColor color, DeviceType deviceType) {
            super(properties);
            this.color = color;
        }

        @Override
        public DyeColor getColor() {
            return this.color;
        }

        @Override
        public void setPlacedBy(@NotNull Level level, @NotNull BlockPos pos, @NotNull BlockState state, @Nullable LivingEntity placer, @NotNull ItemStack stack) {
            super.setPlacedBy(level, pos, state, placer, stack);
            BlockEntity blockEntity = level.getBlockEntity(pos);
            if (blockEntity instanceof Colorable) {
                Colorable colored = (Colorable)blockEntity;
                colored.setColor(this.color);
            }
        }

        @Override
        protected void createBlockStateDefinition(// Could not load outer class - annotation placement on inner may be incorrect
         @NotNull StateDefinition.Builder<Block, BlockState> pBuilder) {
            super.createBlockStateDefinition(pBuilder);
        }
    }

    public static enum Type implements StringRepresentable
    {
        BASE,
        SCREEN;


        @NotNull
        public String getSerializedName() {
            return this.name().toLowerCase(Locale.ROOT);
        }
    }
}

