/*
 * Decompiled with CFR 0.152.
 */
package dev.ultreon.devices.block;

import dev.ultreon.devices.DeviceType;
import dev.ultreon.devices.DeviceTypeSupplier;
import dev.ultreon.devices.block.ColoredBlock;
import dev.ultreon.devices.block.entity.DeviceBlockEntity;
import dev.ultreon.devices.util.BlockEntityUtil;
import dev.ultreon.devices.util.Colorable;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DeviceBlock
extends HorizontalDirectionalBlock
implements EntityBlock,
DeviceTypeSupplier {
    private final DeviceType deviceType;

    public DeviceBlock(BlockBehaviour.Properties properties, DeviceType deviceType) {
        super(properties.strength(0.5f));
        this.deviceType = deviceType;
    }

    @NotNull
    public VoxelShape getShape(@NotNull BlockState pState, @NotNull BlockGetter pLevel, @NotNull BlockPos pPos, @NotNull CollisionContext pContext) {
        return Shapes.empty();
    }

    @Nullable
    public BlockState getStateForPlacement(@NotNull BlockPlaceContext pContext) {
        BlockState state = super.getStateForPlacement(pContext);
        return state != null ? (BlockState)state.setValue((Property)FACING, (Comparable)Objects.requireNonNull(pContext.getPlayer(), "Player in block placement context is null.").getDirection().getOpposite()) : null;
    }

    public void setPlacedBy(@NotNull Level level, @NotNull BlockPos pos, @NotNull BlockState state, @Nullable LivingEntity placer, @NotNull ItemStack stack) {
        super.setPlacedBy(level, pos, state, placer, stack);
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof DeviceBlockEntity) {
            DeviceBlockEntity deviceBlockEntity = (DeviceBlockEntity)blockEntity;
            if (stack.has(DataComponents.CUSTOM_NAME)) {
                deviceBlockEntity.setCustomName(stack.getHoverName().getString());
            }
        }
    }

    public void destroy(LevelAccessor level, BlockPos pos, BlockState state) {
        BlockEntity blockEntity;
        if (!level.isClientSide() && (blockEntity = level.getBlockEntity(pos)) instanceof DeviceBlockEntity) {
            DeviceBlockEntity device = (DeviceBlockEntity)blockEntity;
            CompoundTag blockEntityTag = new CompoundTag();
            blockEntity.saveWithoutMetadata((HolderLookup.Provider)level.registryAccess());
            blockEntityTag.remove("id");
            this.removeTagsForDrop(blockEntityTag);
            CompoundTag tag = new CompoundTag();
            tag.put("BlockEntityTag", (Tag)blockEntityTag);
            ItemStack drop = blockEntity instanceof Colorable ? new ItemStack((ItemLike)this, 1) : new ItemStack((ItemLike)this);
            drop.set(DataComponents.BLOCK_ENTITY_DATA, (Object)CustomData.of((CompoundTag)tag));
            if (device.hasCustomName()) {
                drop.set(DataComponents.CUSTOM_NAME, (Object)Component.literal((String)device.getCustomName()));
            }
            level.addFreshEntity((Entity)new ItemEntity((Level)level, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, drop));
            level.removeBlock(pos, false);
            return;
        }
        super.destroy(level, pos, state);
    }

    protected void removeTagsForDrop(CompoundTag blockEntityTag) {
    }

    @Nullable
    public abstract BlockEntity newBlockEntity(@NotNull BlockPos var1, @NotNull BlockState var2);

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(@NotNull Level level, @NotNull BlockState state, @NotNull BlockEntityType<T> blockEntityType) {
        return BlockEntityUtil.getTicker();
    }

    public boolean triggerEvent(@NotNull BlockState state, Level level, @NotNull BlockPos pos, int id, int param) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        return blockEntity != null && blockEntity.triggerEvent(id, param);
    }

    @Override
    public DeviceType getDeviceType() {
        return this.deviceType;
    }

    public static abstract class Colored
    extends DeviceBlock
    implements ColoredBlock {
        private final DyeColor color;

        protected Colored(BlockBehaviour.Properties properties, DyeColor color, DeviceType deviceType) {
            super(properties, deviceType);
            this.color = color;
        }

        @Override
        public DyeColor getColor() {
            return this.color;
        }

        @Override
        public void setPlacedBy(@NotNull Level level, @NotNull BlockPos pos, @NotNull BlockState state, @Nullable LivingEntity placer, @NotNull ItemStack stack) {
            super.setPlacedBy(level, pos, state, placer, stack);
            BlockEntity blockEntity = level.getBlockEntity(pos);
            if (blockEntity instanceof Colorable) {
                Colorable colored = (Colorable)blockEntity;
                colored.setColor(this.color);
            }
        }

        protected void createBlockStateDefinition(// Could not load outer class - annotation placement on inner may be incorrect
         @NotNull StateDefinition.Builder<Block, BlockState> pBuilder) {
            super.createBlockStateDefinition(pBuilder);
            pBuilder.add(new Property[]{FACING});
        }
    }
}

