/*
 * Decompiled with CFR 0.152.
 */
package dev.ultreon.devices.block;

import com.mojang.serialization.MapCodec;
import dev.ultreon.devices.DeviceType;
import dev.ultreon.devices.block.DeviceBlock;
import dev.ultreon.devices.block.entity.OfficeChairBlockEntity;
import dev.ultreon.devices.debug.DebugLog;
import dev.ultreon.devices.entity.Seat;
import dev.ultreon.devices.util.SeatUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.EntityCollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OfficeChairBlock
extends DeviceBlock.Colored {
    public static final MapCodec<OfficeChairBlock> CODEC = OfficeChairBlock.simpleCodec(OfficeChairBlock::new);
    public static final EnumProperty<Type> TYPE = EnumProperty.create((String)"type", Type.class);
    private static final VoxelShape EMPTY_BOX = Shapes.box((double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0);
    private static final VoxelShape SELECTION_BOX = Shapes.box((double)0.0625, (double)0.0, (double)0.0625, (double)0.9375, (double)0.625, (double)0.9375);
    private static final VoxelShape SEAT_BOUNDING_BOX = Shapes.box((double)0.0625, (double)0.0, (double)0.0625, (double)0.9375, (double)0.625, (double)0.9375);

    public OfficeChairBlock(DyeColor color) {
        super(BlockBehaviour.Properties.of().mapColor(color), color, DeviceType.SEAT);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue(TYPE, (Comparable)((Object)Type.LEGS)));
    }

    private OfficeChairBlock(BlockBehaviour.Properties properties) {
        super(properties, DyeColor.WHITE, DeviceType.SEAT);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue(TYPE, (Comparable)((Object)Type.LEGS)));
    }

    public boolean canSurvive(@NotNull BlockState state, @NotNull LevelReader reader, @NotNull BlockPos pos) {
        return true;
    }

    @Override
    @NotNull
    public VoxelShape getShape(@NotNull BlockState pState, @NotNull BlockGetter pLevel, @NotNull BlockPos pPos, @NotNull CollisionContext pContext) {
        return SELECTION_BOX;
    }

    @NotNull
    public VoxelShape getVisualShape(@NotNull BlockState state, @NotNull BlockGetter level, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        return SEAT_BOUNDING_BOX;
    }

    @NotNull
    public VoxelShape getCollisionShape(@NotNull BlockState state, @NotNull BlockGetter level, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        EntityCollisionContext entityCollisionContext;
        if (context instanceof EntityCollisionContext && (entityCollisionContext = (EntityCollisionContext)context).getEntity() != null && entityCollisionContext.getEntity().getVehicle() instanceof Seat) {
            return EMPTY_BOX;
        }
        return SELECTION_BOX;
    }

    @NotNull
    protected InteractionResult useWithoutItem(@NotNull BlockState state, Level level, @NotNull BlockPos pos, @NotNull Player player, @NotNull BlockHitResult hitResult) {
        DebugLog.log("OKOKJRTKFD");
        if (!level.isClientSide) {
            SeatUtil.createSeatAndSit(level, pos, player, -1.0);
        }
        return InteractionResult.SUCCESS;
    }

    @Override
    @Nullable
    public BlockEntity newBlockEntity(@NotNull BlockPos pos, @NotNull BlockState state) {
        return new OfficeChairBlockEntity(pos, state);
    }

    @Override
    protected void createBlockStateDefinition(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull StateDefinition.Builder<Block, BlockState> pBuilder) {
        super.createBlockStateDefinition(pBuilder);
        pBuilder.add(new Property[]{TYPE});
    }

    @NotNull
    protected MapCodec<? extends HorizontalDirectionalBlock> codec() {
        return CODEC;
    }

    public static enum Type implements StringRepresentable
    {
        LEGS,
        SEAT,
        FULL;


        @NotNull
        public String getSerializedName() {
            return this.name().toLowerCase();
        }
    }
}

