/*
 * Decompiled with CFR 0.152.
 */
package dev.ultreon.devices.block;

import com.mojang.serialization.MapCodec;
import dev.ultreon.devices.api.print.IPrint;
import dev.ultreon.devices.block.entity.PaperBlockEntity;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PaperBlock
extends HorizontalDirectionalBlock
implements EntityBlock {
    public static final MapCodec<PaperBlock> CODEC = PaperBlock.simpleCodec(PaperBlock::new);
    private static final VoxelShape SELECTION_BOUNDS = PaperBlock.box((double)15.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    private static final VoxelShape SELECTION_BOX_NORTH = PaperBlock.box((double)15.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    private static final VoxelShape SELECTION_BOX_SOUTH = PaperBlock.box((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)16.0, (double)16.0);
    private static final VoxelShape SELECTION_BOX_WEST = PaperBlock.box((double)0.0, (double)0.0, (double)15.0, (double)16.0, (double)16.0, (double)16.0);
    private static final VoxelShape SELECTION_BOX_EAST = PaperBlock.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)1.0);
    private static final VoxelShape[] SELECTION_BOUNDING_BOX = new VoxelShape[]{SELECTION_BOX_SOUTH, SELECTION_BOX_WEST, SELECTION_BOX_NORTH, SELECTION_BOX_EAST};

    public PaperBlock() {
        this(BlockBehaviour.Properties.of().noCollission().instabreak().noOcclusion().noLootTable());
    }

    private PaperBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)FACING, (Comparable)Direction.NORTH));
    }

    @NotNull
    public VoxelShape getShape(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return switch ((Direction)pState.getValue((Property)FACING)) {
            case Direction.NORTH -> SELECTION_BOX_NORTH;
            case Direction.SOUTH -> SELECTION_BOX_SOUTH;
            case Direction.WEST -> SELECTION_BOX_WEST;
            case Direction.EAST -> SELECTION_BOX_EAST;
            default -> throw new IllegalStateException("Unexpected value: " + String.valueOf(pState.getValue((Property)FACING)));
        };
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext pContext) {
        BlockState state = super.getStateForPlacement(pContext);
        return state != null ? (BlockState)state.setValue((Property)FACING, (Comparable)pContext.getHorizontalDirection()) : null;
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        BlockEntity blockEntity;
        if (!level.isClientSide && (blockEntity = level.getBlockEntity(pos)) instanceof PaperBlockEntity) {
            PaperBlockEntity paper = (PaperBlockEntity)blockEntity;
            paper.nextRotation();
        }
        return InteractionResult.SUCCESS;
    }

    public List<ItemStack> getDrops(BlockState pState, LootParams.Builder pBuilder) {
        BlockEntity blockEntity = (BlockEntity)pBuilder.getOptionalParameter(LootContextParams.BLOCK_ENTITY);
        if (!(blockEntity instanceof PaperBlockEntity)) {
            return new ArrayList<ItemStack>();
        }
        PaperBlockEntity paper = (PaperBlockEntity)blockEntity;
        IPrint print = paper.getPrint();
        if (print == null) {
            return new ArrayList<ItemStack>();
        }
        ItemStack drop = IPrint.generateItem(print);
        return List.of(drop);
    }

    public boolean triggerEvent(@NotNull BlockState state, Level level, @NotNull BlockPos pos, int id, int param) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        return blockEntity != null && blockEntity.triggerEvent(id, param);
    }

    public boolean dropFromExplosion(Explosion pExplosion) {
        return true;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.add(new Property[]{FACING});
    }

    protected RenderShape getRenderShape(BlockState state) {
        return RenderShape.ENTITYBLOCK_ANIMATED;
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new PaperBlockEntity(pos, state);
    }

    protected MapCodec<? extends HorizontalDirectionalBlock> codec() {
        return CODEC;
    }
}

