/*
 * Decompiled with CFR 0.152.
 */
package dev.ultreon.devices.block;

import com.mojang.serialization.MapCodec;
import dev.ultreon.devices.DeviceType;
import dev.ultreon.devices.UltreonDevices;
import dev.ultreon.devices.block.DeviceBlock;
import dev.ultreon.devices.block.entity.PrinterBlockEntity;
import dev.ultreon.devices.util.Colored;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PrinterBlock
extends DeviceBlock.Colored
implements Colored {
    public static final MapCodec<PrinterBlock> CODEC = PrinterBlock.simpleCodec(PrinterBlock::new);
    private static final VoxelShape SHAPE_NORTH = Shapes.or((VoxelShape)PrinterBlock.box((double)2.0, (double)0.0, (double)7.0, (double)14.0, (double)5.0, (double)12.0), (VoxelShape[])new VoxelShape[]{PrinterBlock.box((double)3.5, (double)0.1, (double)1.0, (double)12.5, (double)1.1, (double)7.0), PrinterBlock.box((double)12.0, (double)0.0, (double)12.0, (double)15.0, (double)5.0, (double)14.0), PrinterBlock.box((double)12.0, (double)0.0, (double)5.0, (double)15.0, (double)3.0, (double)7.0), PrinterBlock.box((double)1.0, (double)0.0, (double)5.0, (double)4.0, (double)3.0, (double)7.0), PrinterBlock.box((double)1.0, (double)0.0, (double)12.0, (double)4.0, (double)75.0, (double)14.0), PrinterBlock.box((double)1.1, (double)0.0, (double)7.0, (double)14.9, (double)5.0, (double)12.0), PrinterBlock.box((double)4.0, (double)0.0, (double)12.0, (double)12.0, (double)3.0, (double)14.0), PrinterBlock.box((double)3.5, (double)0.1, (double)1.0, (double)12.5, (double)1.1, (double)7.5), PrinterBlock.box((double)1.0, (double)3.0, (double)5.0, (double)15.0, (double)5.0, (double)7.0), PrinterBlock.box((double)4.0, (double)3.0, (double)12.0, (double)12.0, (double)9.3, (double)16.0)});
    private static final VoxelShape SHAPE_EAST = Shapes.or((VoxelShape)PrinterBlock.box((double)4.0, (double)0.0, (double)2.0, (double)9.0, (double)5.0, (double)14.0), (VoxelShape[])new VoxelShape[]{PrinterBlock.box((double)9.0, (double)0.1, (double)3.5, (double)15.0, (double)1.1, (double)12.5), PrinterBlock.box((double)2.0, (double)0.0, (double)12.0, (double)4.0, (double)5.0, (double)15.0), PrinterBlock.box((double)9.0, (double)0.0, (double)12.0, (double)11.0, (double)3.0, (double)15.0), PrinterBlock.box((double)9.0, (double)0.0, (double)1.0, (double)11.0, (double)3.0, (double)4.0), PrinterBlock.box((double)2.0, (double)0.0, (double)1.0, (double)4.0, (double)5.0, (double)4.0), PrinterBlock.box((double)4.0, (double)0.0, (double)1.1, (double)9.0, (double)5.0, (double)14.9), PrinterBlock.box((double)2.0, (double)0.0, (double)4.0, (double)4.0, (double)3.0, (double)12.0), PrinterBlock.box((double)8.5, (double)0.1, (double)3.5, (double)15.0, (double)1.1, (double)12.5), PrinterBlock.box((double)9.0, (double)3.0, (double)1.0, (double)11.0, (double)5.0, (double)15.0), PrinterBlock.box((double)0.0, (double)3.0, (double)4.0, (double)4.0, (double)9.3, (double)12.0)});
    private static final VoxelShape SHAPE_SOUTH = Shapes.or((VoxelShape)PrinterBlock.box((double)2.0, (double)0.0, (double)4.0, (double)14.0, (double)5.0, (double)9.0), (VoxelShape[])new VoxelShape[]{PrinterBlock.box((double)3.5, (double)0.1, (double)9.0, (double)12.5, (double)1.1, (double)15.0), PrinterBlock.box((double)1.0, (double)0.0, (double)2.0, (double)4.0, (double)5.0, (double)4.0), PrinterBlock.box((double)1.0, (double)0.0, (double)9.0, (double)4.0, (double)3.0, (double)11.0), PrinterBlock.box((double)12.0, (double)0.0, (double)9.0, (double)15.0, (double)3.0, (double)11.0), PrinterBlock.box((double)12.0, (double)0.0, (double)2.0, (double)15.0, (double)5.0, (double)4.0), PrinterBlock.box((double)1.1, (double)0.0, (double)4.0, (double)14.9, (double)5.0, (double)9.0), PrinterBlock.box((double)4.0, (double)0.0, (double)2.0, (double)12.0, (double)3.0, (double)4.0), PrinterBlock.box((double)3.5, (double)0.1, (double)8.5, (double)12.5, (double)1.1, (double)15.0), PrinterBlock.box((double)1.0, (double)3.0, (double)9.0, (double)15.0, (double)5.0, (double)11.0), PrinterBlock.box((double)4.0, (double)3.0, (double)0.0, (double)12.0, (double)9.3, (double)3.4)});
    private static final VoxelShape SHAPE_WEST = Shapes.or((VoxelShape)PrinterBlock.box((double)7.0, (double)0.0, (double)2.0, (double)12.0, (double)5.0, (double)14.0), (VoxelShape[])new VoxelShape[]{PrinterBlock.box((double)1.0, (double)0.1, (double)3.5, (double)7.0, (double)1.1, (double)12.5), PrinterBlock.box((double)12.0, (double)0.0, (double)1.0, (double)14.0, (double)5.0, (double)4.0), PrinterBlock.box((double)5.0, (double)0.0, (double)1.0, (double)7.0, (double)3.0, (double)4.0), PrinterBlock.box((double)5.0, (double)0.0, (double)12.0, (double)7.0, (double)3.0, (double)15.0), PrinterBlock.box((double)12.0, (double)0.0, (double)12.0, (double)14.0, (double)5.0, (double)15.0), PrinterBlock.box((double)7.0, (double)0.0, (double)1.1, (double)12.0, (double)5.0, (double)14.9), PrinterBlock.box((double)12.0, (double)0.0, (double)4.0, (double)14.0, (double)3.0, (double)12.0), PrinterBlock.box((double)1.0, (double)0.1, (double)3.5, (double)7.5, (double)1.1, (double)12.5), PrinterBlock.box((double)5.0, (double)3.0, (double)1.0, (double)7.0, (double)5.0, (double)15.0), PrinterBlock.box((double)12.0, (double)3.0, (double)4.0, (double)16.0, (double)9.3, (double)12.0)});

    public PrinterBlock(DyeColor color) {
        super(BlockBehaviour.Properties.of().mapColor(color).strength(6.0f).sound(SoundType.METAL), color, DeviceType.PRINTER);
        this.registerDefaultState((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)FACING, (Comparable)Direction.NORTH));
    }

    private PrinterBlock(BlockBehaviour.Properties properties) {
        super(properties, DyeColor.WHITE, DeviceType.PRINTER);
        this.registerDefaultState((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)FACING, (Comparable)Direction.NORTH));
    }

    @Override
    @NotNull
    public VoxelShape getShape(@NotNull BlockState pState, @NotNull BlockGetter pLevel, @NotNull BlockPos pPos, @NotNull CollisionContext pContext) {
        return switch ((Direction)pState.getValue((Property)FACING)) {
            case Direction.NORTH -> SHAPE_NORTH;
            case Direction.EAST -> SHAPE_EAST;
            case Direction.SOUTH -> SHAPE_SOUTH;
            case Direction.WEST -> SHAPE_WEST;
            default -> throw new IllegalStateException("Unexpected value: " + String.valueOf(pState.getValue((Property)FACING)));
        };
    }

    @NotNull
    protected ItemInteractionResult useItemOn(@NotNull ItemStack stack, @NotNull BlockState state, Level level, @NotNull BlockPos pos, @NotNull Player player, @NotNull InteractionHand hand, @NotNull BlockHitResult hitResult) {
        if (level.isClientSide && player.isCrouching()) {
            return ItemInteractionResult.CONSUME;
        }
        ItemStack heldItem = player.getItemInHand(hand);
        BlockEntity tileEntity = level.getChunkAt(pos).getBlockEntity(pos, LevelChunk.EntityCreationType.IMMEDIATE);
        if (tileEntity instanceof PrinterBlockEntity) {
            return ((PrinterBlockEntity)tileEntity).addPaper(heldItem, player.isCrouching()) ? ItemInteractionResult.SUCCESS : ItemInteractionResult.FAIL;
        }
        UltreonDevices.LOGGER.warn("BlockEntity at {} is not a PrinterBlockEntity", (Object)pos);
        return ItemInteractionResult.FAIL;
    }

    @Override
    @Nullable
    public BlockEntity newBlockEntity(@NotNull BlockPos pos, @NotNull BlockState state) {
        return new PrinterBlockEntity(pos, state);
    }

    @NotNull
    protected MapCodec<? extends HorizontalDirectionalBlock> codec() {
        return CODEC;
    }
}

